/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.Objects;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpressionVisitor;
import software.amazon.awssdk.codegen.poet.rules2.RuleRuntimeTypeMirror;
import software.amazon.awssdk.codegen.poet.rules2.RuleType;

public final class ErrorExpression
implements RuleExpression {
    private final RuleType type = RuleRuntimeTypeMirror.VOID;
    private final RuleExpression error;

    public ErrorExpression(RuleExpression error) {
        this.error = error;
    }

    @Override
    public RuleExpression.RuleExpressionKind kind() {
        return RuleExpression.RuleExpressionKind.ERROR;
    }

    @Override
    public StringBuilder appendTo(StringBuilder buf) {
        buf.append("{:type :error, :message ");
        this.error.appendTo(buf);
        return buf.append("}");
    }

    @Override
    public <T> T accept(RuleExpressionVisitor<T> visitor) {
        return visitor.visitErrorExpression(this);
    }

    public RuleExpression error() {
        return this.error;
    }

    @Override
    public RuleType type() {
        return this.type;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorExpression that = (ErrorExpression)o;
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return this.error.equals(that.error);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.error.hashCode();
        return result;
    }
}

