/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.codegen.poet.rules2.RuleType;
import software.amazon.awssdk.utils.Validate;

public final class SymbolTable {
    private final Map<String, RuleType> params;
    private final Map<String, RuleType> locals;
    private final String regionParamName;

    SymbolTable(Builder builder) {
        this.params = Collections.unmodifiableMap(new LinkedHashMap(builder.params));
        this.locals = Collections.unmodifiableMap(new LinkedHashMap(builder.locals));
        this.regionParamName = builder.regionParamName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isParam(String name) {
        return this.params.containsKey(name);
    }

    public RuleType paramType(String name) {
        return this.params.get(name);
    }

    public boolean isLocal(String name) {
        return this.locals.containsKey(name);
    }

    public RuleType localType(String name) {
        return this.locals.get(name);
    }

    public Map<String, RuleType> locals() {
        return this.locals;
    }

    public Map<String, RuleType> params() {
        return this.params;
    }

    public String regionParamName() {
        return this.regionParamName;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private final Map<String, RuleType> params = new LinkedHashMap<String, RuleType>();
        private final Map<String, RuleType> locals = new LinkedHashMap<String, RuleType>();
        private String regionParamName;

        public Builder() {
        }

        public Builder(SymbolTable table) {
            this.params.putAll(table.params);
            this.locals.putAll(table.locals);
            this.regionParamName = table.regionParamName;
        }

        public Builder putParam(String name, RuleType type) {
            this.params.put((String)Validate.paramNotNull((Object)name, (String)"name"), (RuleType)Validate.paramNotNull((Object)type, (String)"type"));
            return this;
        }

        public RuleType param(String name) {
            return this.params.get(name);
        }

        public Builder putLocal(String name, RuleType type) {
            this.locals.put((String)Validate.paramNotNull((Object)name, (String)"name"), (RuleType)Validate.paramNotNull((Object)type, (String)"type"));
            return this;
        }

        public RuleType local(String name) {
            return this.locals.get(name);
        }

        public Builder regionParamName(String regionParamName) {
            this.regionParamName = regionParamName;
            return this;
        }

        public SymbolTable build() {
            return new SymbolTable(this);
        }
    }
}

