/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client.traits;

import com.squareup.javapoet.CodeBlock;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.internal.interceptor.trait.RequestCompression;

public class RequestCompressionTrait {
    private RequestCompressionTrait() {
    }

    public static CodeBlock create(OperationModel operationModel, IntermediateModel model) {
        if (operationModel.getRequestCompression() == null) {
            return CodeBlock.of((String)"", (Object[])new Object[0]);
        }
        if (model.getMetadata().getServiceName().equals("S3")) {
            throw new IllegalStateException("Request compression for S3 is not yet supported in the AWS SDK for Java.");
        }
        List<String> encodings = operationModel.getRequestCompression().getEncodings();
        return CodeBlock.of((String)".putExecutionAttribute($T.REQUEST_COMPRESSION, $T.builder().encodings($L).isStreaming($L).build())", (Object[])new Object[]{SdkInternalExecutionAttribute.class, RequestCompression.class, encodings.stream().collect(Collectors.joining("\", \"", "\"", "\"")), operationModel.hasStreamingInput()});
    }
}

