/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.customization.processors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.codegen.customization.CodegenCustomizationProcessor;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.service.EndpointTrait;
import software.amazon.awssdk.codegen.model.service.Operation;
import software.amazon.awssdk.codegen.model.service.ServiceModel;

public class S3ControlRemoveAccountIdHostPrefixProcessor
implements CodegenCustomizationProcessor {
    private static final String ACCOUNT_ID_HOST_PREFIX = "{AccountId}.";
    private static final Logger log = LoggerFactory.getLogger(S3ControlRemoveAccountIdHostPrefixProcessor.class);

    @Override
    public void preprocess(ServiceModel serviceModel) {
        if (!this.isS3Control(serviceModel)) {
            return;
        }
        log.info("Preprocessing S3 Control model to remove '{AccountId}.' hostPrefix from operations");
        serviceModel.getOperations().forEach(this::removeAccountIdHostPrefixIfNecessary);
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
    }

    private boolean isS3Control(ServiceModel serviceModel) {
        return "S3 Control".equals(serviceModel.getMetadata().getServiceId());
    }

    private void removeAccountIdHostPrefixIfNecessary(String opName, Operation operation) {
        EndpointTrait endpoint = operation.getEndpoint();
        if (endpoint == null) {
            return;
        }
        if (ACCOUNT_ID_HOST_PREFIX.equals(endpoint.getHostPrefix())) {
            log.info("{}: Removing '{AccountId}.' hostPrefix", (Object)opName);
            endpoint.setHostPrefix(null);
        }
    }
}

