/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.rules.endpoints.BuiltInParameter;
import software.amazon.awssdk.codegen.model.rules.endpoints.ParameterModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.codegen.poet.rules.RuleSetCreationSpec;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

public class EndpointProviderSpec
implements ClassSpec {
    private static final String RULE_SET_FIELD_NAME = "ENDPOINT_RULE_SET";
    private final IntermediateModel intermediateModel;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;

    public EndpointProviderSpec(IntermediateModel intermediateModel) {
        this.intermediateModel = intermediateModel;
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(intermediateModel);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder b = PoetUtils.createClassBuilder(this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)this.endpointRulesSpecUtils.providerInterfaceName()).addField(this.ruleSet()).addMethod(this.resolveEndpointMethod()).addMethod(this.toIdentifierValueMap()).addAnnotation(SdkInternalApi.class);
        b.addMethod(this.ruleSetBuildMethod(b));
        b.addMethod(this.equalsMethod());
        b.addMethod(this.hashCodeMethod());
        return b.build();
    }

    private MethodSpec equalsMethod() {
        return MethodSpec.methodBuilder((String)"equals").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addParameter(Object.class, "rhs", new Modifier[0]).addStatement("return rhs != null && getClass().equals(rhs.getClass())", new Object[0]).build();
    }

    private MethodSpec hashCodeMethod() {
        return MethodSpec.methodBuilder((String)"hashCode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return getClass().hashCode()", new Object[0]).build();
    }

    @Override
    public ClassName className() {
        Metadata md = this.intermediateModel.getMetadata();
        return ClassName.get((String)md.getFullInternalEndpointRulesPackageName(), (String)("Default" + this.endpointRulesSpecUtils.providerInterfaceName().simpleName()), (String[])new String[0]);
    }

    private FieldSpec ruleSet() {
        return FieldSpec.builder((TypeName)this.endpointRulesSpecUtils.rulesRuntimeClassName("EndpointRuleset"), (String)RULE_SET_FIELD_NAME, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("ruleSet()", new Object[0]).build();
    }

    private MethodSpec toIdentifierValueMap() {
        ParameterizedTypeName resultType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("Identifier"), this.endpointRulesSpecUtils.rulesRuntimeClassName("Value")});
        String paramsName = "params";
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"toIdentifierValueMap").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter((TypeName)this.endpointRulesSpecUtils.parametersClassName(), paramsName, new Modifier[0]).returns((TypeName)resultType);
        Map<String, ParameterModel> params = this.intermediateModel.getEndpointRuleSetModel().getParameters();
        String resultName = "paramsMap";
        b.addStatement("$T $N = new $T<>()", new Object[]{resultType, resultName, HashMap.class});
        params.forEach((name, model) -> {
            String methodVarName = this.endpointRulesSpecUtils.paramMethodName((String)name);
            CodeBlock identifierExpr = CodeBlock.of((String)"$T.of($S)", (Object[])new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("Identifier"), name});
            CodeBlock coerce = model.getBuiltInEnum() == BuiltInParameter.AWS_REGION ? CodeBlock.builder().add(".id()", new Object[0]).build() : CodeBlock.builder().build();
            CodeBlock valueExpr = this.endpointRulesSpecUtils.valueCreationCode(model.getType(), CodeBlock.builder().add("$N.$N()$L", new Object[]{paramsName, methodVarName, coerce}).build());
            b.beginControlFlow("if ($N.$N() != null)", new Object[]{paramsName, methodVarName});
            b.addStatement("$N.put($L, $L)", new Object[]{resultName, identifierExpr, valueExpr});
            b.endControlFlow();
        });
        b.addStatement("return $N", new Object[]{resultName});
        return b.build();
    }

    private MethodSpec resolveEndpointMethod() {
        String paramsName = "endpointParams";
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"resolveEndpoint").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.endpointRulesSpecUtils.resolverReturnType()).addAnnotation(Override.class).addParameter((TypeName)this.endpointRulesSpecUtils.parametersClassName(), paramsName, new Modifier[0]);
        b.addCode(this.validateRequiredParams());
        b.addStatement("$T res = new $T().evaluate($N, toIdentifierValueMap($N))", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("Value"), this.endpointRulesSpecUtils.rulesRuntimeClassName("DefaultRuleEngine"), RULE_SET_FIELD_NAME, paramsName});
        b.beginControlFlow("try", new Object[0]);
        b.addStatement("return $T.completedFuture($T.valueAsEndpointOrThrow($N))", new Object[]{CompletableFuture.class, this.endpointRulesSpecUtils.rulesRuntimeClassName("AwsEndpointProviderUtils"), "res"});
        b.endControlFlow();
        b.beginControlFlow("catch ($T error)", new Object[]{Exception.class});
        b.addStatement("return $T.failedFuture(error)", new Object[]{CompletableFutureUtils.class});
        b.endControlFlow();
        return b.build();
    }

    private MethodSpec ruleSetBuildMethod(TypeSpec.Builder classBuilder) {
        RuleSetCreationSpec ruleSetCreationSpec = new RuleSetCreationSpec(this.intermediateModel);
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"ruleSet").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns((TypeName)this.endpointRulesSpecUtils.rulesRuntimeClassName("EndpointRuleset")).addStatement("return $L", new Object[]{ruleSetCreationSpec.ruleSetCreationExpr()});
        ruleSetCreationSpec.helperMethods().forEach(arg_0 -> ((TypeSpec.Builder)classBuilder).addMethod(arg_0));
        return b.build();
    }

    private CodeBlock validateRequiredParams() {
        CodeBlock.Builder b = CodeBlock.builder();
        Map<String, ParameterModel> parameters = this.intermediateModel.getEndpointRuleSetModel().getParameters();
        parameters.entrySet().stream().filter(e -> Boolean.TRUE.equals(((ParameterModel)e.getValue()).isRequired())).forEach(e -> b.addStatement("$T.notNull($N.$N(), $S)", new Object[]{Validate.class, "endpointParams", this.endpointRulesSpecUtils.paramMethodName((String)e.getKey()), String.format("Parameter '%s' must not be null", e.getKey())}));
        return b.build();
    }
}

