/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client.specs;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.WildcardTypeName;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.awscore.eventstream.EventStreamAsyncResponseTransformer;
import software.amazon.awssdk.awscore.eventstream.EventStreamTaggedUnionPojoSupplier;
import software.amazon.awssdk.awscore.eventstream.RestEventStreamAsyncResponseTransformer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.codegen.model.config.customization.S3ArnableFieldConfig;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.client.specs.QueryProtocolSpec;
import software.amazon.awssdk.codegen.poet.client.traits.HttpChecksumRequiredTrait;
import software.amazon.awssdk.codegen.poet.client.traits.HttpChecksumTrait;
import software.amazon.awssdk.codegen.poet.client.traits.NoneAuthTypeRequestTrait;
import software.amazon.awssdk.codegen.poet.client.traits.RequestCompressionTrait;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamUtils;
import software.amazon.awssdk.codegen.poet.model.EventStreamSpecHelper;
import software.amazon.awssdk.core.Response;
import software.amazon.awssdk.core.SdkPojoBuilder;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.utils.CompletableFutureUtils;

public final class XmlProtocolSpec
extends QueryProtocolSpec {
    private final IntermediateModel model;

    public XmlProtocolSpec(IntermediateModel model, PoetExtension poetExtensions) {
        super(model, poetExtensions);
        this.model = model;
    }

    @Override
    protected Class<?> protocolFactoryClass() {
        if (this.model.getCustomizationConfig().getCustomProtocolFactoryFqcn() != null) {
            try {
                return Class.forName(this.model.getCustomizationConfig().getCustomProtocolFactoryFqcn());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not find custom protocol factory class", e);
            }
        }
        return AwsXmlProtocolFactory.class;
    }

    @Override
    public CodeBlock responseHandler(IntermediateModel model, OperationModel opModel) {
        if (opModel.hasStreamingOutput()) {
            return this.streamingResponseHandler(opModel);
        }
        ClassName responseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        if (opModel.hasEventStreamOutput()) {
            return CodeBlock.builder().add(this.eventStreamResponseHandlers(opModel, (TypeName)responseType)).build();
        }
        ParameterizedTypeName handlerType = ParameterizedTypeName.get((ClassName)ClassName.get(HttpResponseHandler.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(Response.class), (TypeName[])new TypeName[]{responseType})});
        return CodeBlock.builder().addStatement("\n\n$T responseHandler = protocolFactory.createCombinedResponseHandler($T::builder, new $T().withHasStreamingSuccessResponse($L))", new Object[]{handlerType, responseType, XmlOperationMetadata.class, opModel.hasStreamingOutput()}).build();
    }

    private CodeBlock streamingResponseHandler(OperationModel opModel) {
        ClassName responseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        return CodeBlock.builder().addStatement("\n\n$T<$T> responseHandler = protocolFactory.createResponseHandler($T::builder, new $T().withHasStreamingSuccessResponse($L))", new Object[]{HttpResponseHandler.class, responseType, responseType, XmlOperationMetadata.class, opModel.hasStreamingOutput()}).build();
    }

    @Override
    public Optional<CodeBlock> errorResponseHandler(OperationModel opModel) {
        return opModel.hasStreamingOutput() ? this.streamingErrorResponseHandler(opModel) : Optional.empty();
    }

    private Optional<CodeBlock> streamingErrorResponseHandler(OperationModel opModel) {
        return super.errorResponseHandler(opModel);
    }

    @Override
    public CodeBlock executionHandler(OperationModel opModel) {
        if (opModel.hasStreamingOutput()) {
            return this.streamingExecutionHandler(opModel);
        }
        ClassName responseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        ClassName requestType = this.poetExtensions.getModelClass(opModel.getInput().getVariableType());
        ClassName marshaller = this.poetExtensions.getTransformClass(opModel.getInputShape().getShapeName() + "Marshaller");
        CodeBlock.Builder codeBlock = CodeBlock.builder().add("\n\nreturn clientHandler.execute(new $T<$T, $T>()\n", new Object[]{ClientExecutionParams.class, requestType, responseType}).add(".withOperationName($S)\n", new Object[]{opModel.getOperationName()}).add(".withCombinedResponseHandler(responseHandler)\n", new Object[0]).add(".withMetricCollector(apiCallMetricCollector)\n" + this.hostPrefixExpression(opModel) + this.discoveredEndpoint(opModel), new Object[0]).add(this.credentialType(opModel, this.model)).add(".withRequestConfiguration(clientConfiguration)", new Object[0]).add(".withInput($L)", new Object[]{opModel.getInput().getVariableName()}).add(HttpChecksumRequiredTrait.putHttpChecksumAttribute(opModel)).add(HttpChecksumTrait.create(opModel));
        if (!this.useSraAuth) {
            codeBlock.add(NoneAuthTypeRequestTrait.create(opModel));
        }
        codeBlock.add(RequestCompressionTrait.create(opModel, this.model));
        this.s3ArnableFields(opModel, this.model).ifPresent(arg_0 -> ((CodeBlock.Builder)codeBlock).add(arg_0));
        if (opModel.hasStreamingInput()) {
            return codeBlock.add(".withRequestBody(requestBody)", new Object[0]).add(".withMarshaller($L));", new Object[]{this.syncStreamingMarshaller(this.intermediateModel, opModel, marshaller)}).build();
        }
        return codeBlock.add(".withMarshaller(new $T(protocolFactory)) $L);", new Object[]{marshaller, opModel.hasStreamingOutput() ? ", responseTransformer" : ""}).build();
    }

    private Optional<CodeBlock> s3ArnableFields(OperationModel opModel, IntermediateModel model) {
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        Map<String, S3ArnableFieldConfig> s3ArnableFields = model.getCustomizationConfig().getS3ArnableFields();
        String shapeName = opModel.getInputShape().getShapeName();
        if (s3ArnableFields != null && s3ArnableFields.containsKey(shapeName)) {
            S3ArnableFieldConfig s3ArnableField = s3ArnableFields.get(shapeName);
            codeBlock.add(".putExecutionAttribute($T.$N, $T.builder().arn(arn).build())", new Object[]{PoetUtils.classNameFromFqcn(s3ArnableField.getExecutionAttributeKeyFqcn()), "S3_ARNABLE_FIELD", PoetUtils.classNameFromFqcn(s3ArnableField.getExecutionAttributeValueFqcn())});
            return Optional.of(codeBlock.build());
        }
        return Optional.empty();
    }

    private CodeBlock streamingExecutionHandler(OperationModel opModel) {
        return super.executionHandler(opModel);
    }

    @Override
    public CodeBlock asyncExecutionHandler(IntermediateModel intermediateModel, OperationModel opModel) {
        if (opModel.hasStreamingOutput()) {
            return this.asyncStreamingExecutionHandler(intermediateModel, opModel);
        }
        ClassName pojoResponseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        ClassName requestType = this.poetExtensions.getModelClass(opModel.getInput().getVariableType());
        ClassName marshaller = this.poetExtensions.getRequestTransformClass(opModel.getInputShape().getShapeName() + "Marshaller");
        String eventStreamTransformFutureName = "eventStreamTransformFuture";
        CodeBlock.Builder builder = CodeBlock.builder();
        if (opModel.hasEventStreamOutput()) {
            builder.add(this.eventStreamResponseTransformers(opModel, eventStreamTransformFutureName));
        }
        TypeName executeFutureValueType = this.executeFutureValueType(opModel, this.poetExtensions);
        String executionResponseTransformerName = "asyncResponseTransformer";
        if (opModel.hasEventStreamOutput()) {
            executionResponseTransformerName = "restAsyncResponseTransformer";
        }
        builder.add("\n\n$T<$T> executeFuture = clientHandler.execute(new $T<$T, $T>()\n", new Object[]{CompletableFuture.class, executeFutureValueType, ClientExecutionParams.class, requestType, pojoResponseType}).add(".withOperationName(\"$N\")\n", new Object[]{opModel.getOperationName()}).add(".withRequestConfiguration(clientConfiguration)", new Object[0]).add(".withMarshaller($L)\n", new Object[]{this.asyncMarshaller(intermediateModel, opModel, marshaller, "protocolFactory")});
        if (opModel.hasEventStreamOutput()) {
            builder.add(".withResponseHandler(responseHandler)", new Object[0]).add(".withErrorResponseHandler(errorResponseHandler)", new Object[0]);
        } else {
            builder.add(".withCombinedResponseHandler(responseHandler)", new Object[0]);
        }
        builder.add(this.hostPrefixExpression(opModel), new Object[0]).add(this.credentialType(opModel, this.model)).add(".withMetricCollector(apiCallMetricCollector)\n", new Object[0]).add(this.asyncRequestBody(opModel), new Object[0]).add(HttpChecksumRequiredTrait.putHttpChecksumAttribute(opModel)).add(HttpChecksumTrait.create(opModel));
        if (!this.useSraAuth) {
            builder.add(NoneAuthTypeRequestTrait.create(opModel));
        }
        builder.add(RequestCompressionTrait.create(opModel, this.model));
        this.s3ArnableFields(opModel, this.model).ifPresent(arg_0 -> ((CodeBlock.Builder)builder).add(arg_0));
        builder.add(".withInput($L)", new Object[]{opModel.getInput().getVariableName()});
        if (opModel.hasEventStreamOutput()) {
            builder.add(", $N", new Object[]{executionResponseTransformerName});
        }
        builder.addStatement(")", new Object[0]);
        String whenCompleteFutureName = "whenCompleteFuture";
        builder.addStatement("$T $N = null", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{executeFutureValueType}), whenCompleteFutureName});
        if (opModel.hasEventStreamOutput()) {
            builder.addStatement("$N = executeFuture$L", new Object[]{whenCompleteFutureName, this.whenCompleteBlock(opModel, "asyncResponseHandler", eventStreamTransformFutureName)});
        } else {
            builder.addStatement("$N = executeFuture$L", new Object[]{whenCompleteFutureName, this.publishMetricsWhenComplete()});
        }
        builder.addStatement("$T.forwardExceptionTo($N, executeFuture)", new Object[]{CompletableFutureUtils.class, whenCompleteFutureName});
        if (opModel.hasEventStreamOutput()) {
            builder.addStatement("return $T.forwardExceptionTo($N, executeFuture)", new Object[]{CompletableFutureUtils.class, eventStreamTransformFutureName});
        } else {
            builder.addStatement("return $N", new Object[]{whenCompleteFutureName});
        }
        return builder.build();
    }

    private String asyncRequestBody(OperationModel opModel) {
        return opModel.hasStreamingInput() ? ".withAsyncRequestBody(requestBody)" : "";
    }

    private CodeBlock asyncStreamingExecutionHandler(IntermediateModel intermediateModel, OperationModel opModel) {
        return super.asyncExecutionHandler(intermediateModel, opModel);
    }

    private CodeBlock eventStreamResponseHandlers(OperationModel opModel, TypeName pojoResponseType) {
        CodeBlock streamResponseOpMd = CodeBlock.builder().add("$T.builder()", new Object[]{XmlOperationMetadata.class}).add(".hasStreamingSuccessResponse(true)", new Object[0]).add(".build()", new Object[0]).build();
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.addStatement("$T<$T> responseHandler = protocolFactory.createResponseHandler($T::builder, $L)", new Object[]{HttpResponseHandler.class, pojoResponseType, pojoResponseType, streamResponseOpMd});
        builder.addStatement("$T errorResponseHandler = protocolFactory.createErrorResponseHandler()", new Object[]{ParameterizedTypeName.get(HttpResponseHandler.class, (Type[])new Type[]{AwsServiceException.class})});
        ShapeModel eventStreamShape = EventStreamUtils.getEventStreamInResponse(opModel.getOutputShape());
        ClassName eventStream = this.poetExtensions.getModelClassFromShape(eventStreamShape);
        EventStreamSpecHelper eventStreamSpecHelper = new EventStreamSpecHelper(eventStreamShape, this.intermediateModel);
        CodeBlock.Builder supplierBuilder = CodeBlock.builder().add("$T.builder()", new Object[]{EventStreamTaggedUnionPojoSupplier.class});
        EventStreamUtils.getEvents(eventStreamShape).forEach(m -> {
            String builderName = eventStreamSpecHelper.eventBuilderMethodName((MemberModel)m);
            supplierBuilder.add(".putSdkPojoSupplier($S, $T::$N)", new Object[]{m.getName(), eventStream, builderName});
        });
        supplierBuilder.add(".defaultSdkPojoSupplier(() -> new $T($T.UNKNOWN))", new Object[]{SdkPojoBuilder.class, eventStream});
        CodeBlock supplierCodeBlock = supplierBuilder.add(".build()", new Object[0]).build();
        CodeBlock nonStreamingOpMd = CodeBlock.builder().add("$T.builder()", new Object[]{XmlOperationMetadata.class}).add(".hasStreamingSuccessResponse(false)", new Object[0]).add(".build()", new Object[0]).build();
        builder.addStatement("$T eventResponseHandler = protocolFactory.createResponseHandler($L, $L)", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(HttpResponseHandler.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)eventStream)}), supplierCodeBlock, nonStreamingOpMd});
        return builder.build();
    }

    private CodeBlock eventStreamResponseTransformers(OperationModel opModel, String eventTransformerFutureName) {
        ShapeModel shapeModel = EventStreamUtils.getEventStreamInResponse(opModel.getOutputShape());
        ClassName pojoResponseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        ClassName eventStreamBaseClass = this.poetExtensions.getModelClassFromShape(shapeModel);
        CodeBlock.Builder builder = CodeBlock.builder();
        ParameterizedTypeName transformerType = ParameterizedTypeName.get((ClassName)ClassName.get(EventStreamAsyncResponseTransformer.class), (TypeName[])new TypeName[]{pojoResponseType, eventStreamBaseClass});
        builder.addStatement("$1T<$2T> $3N = new $1T<>()", new Object[]{ClassName.get(CompletableFuture.class), ClassName.get(Void.class), eventTransformerFutureName}).add("$T asyncResponseTransformer = $T.<$T, $T>builder()\n", new Object[]{transformerType, ClassName.get(EventStreamAsyncResponseTransformer.class), pojoResponseType, eventStreamBaseClass}).add(".eventStreamResponseHandler(asyncResponseHandler)\n", new Object[0]).add(".eventResponseHandler(eventResponseHandler)\n", new Object[0]).add(".initialResponseHandler(responseHandler)\n", new Object[0]).add(".exceptionResponseHandler(errorResponseHandler)\n", new Object[0]).add(".future($N)\n", new Object[]{eventTransformerFutureName}).add(".executor(executor)\n", new Object[0]).add(".serviceName(serviceName())\n", new Object[0]).addStatement(".build()", new Object[0]);
        ParameterizedTypeName restTransformType = ParameterizedTypeName.get((ClassName)ClassName.get(RestEventStreamAsyncResponseTransformer.class), (TypeName[])new TypeName[]{pojoResponseType, eventStreamBaseClass});
        builder.addStatement("$T restAsyncResponseTransformer = $T.<$T, $T>builder()\n.eventStreamAsyncResponseTransformer(asyncResponseTransformer)\n.eventStreamResponseHandler(asyncResponseHandler)\n.build()", new Object[]{restTransformType, RestEventStreamAsyncResponseTransformer.class, pojoResponseType, eventStreamBaseClass});
        return builder.build();
    }

    private CodeBlock whenCompleteBlock(OperationModel operationModel, String responseHandlerName, String eventTransformerFutureName) {
        CodeBlock.Builder whenComplete = CodeBlock.builder().add(".whenComplete((r, e) -> ", new Object[0]).beginControlFlow("", new Object[0]).beginControlFlow("if (e != null)", new Object[0]).add("runAndLogError(log, $S, () -> $N.exceptionOccurred(e));", new Object[]{"Exception thrown in exceptionOccurred callback, ignoring", responseHandlerName});
        if (operationModel.hasEventStreamOutput()) {
            whenComplete.add("$N.completeExceptionally(e);", new Object[]{eventTransformerFutureName});
        }
        whenComplete.endControlFlow().add(this.publishMetrics(), new Object[0]).endControlFlow().add(")", new Object[0]).build();
        return whenComplete.build();
    }
}

