/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.WildcardTypeName;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import software.amazon.awssdk.awscore.AwsServiceClientConfiguration;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeSpecUtils;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.IdentityProviders;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.Validate;

public class ServiceClientConfigurationUtils {
    private static final List<Field> BASE_FIELDS = ServiceClientConfigurationUtils.baseServiceClientConfigurationFields();
    private final AuthSchemeSpecUtils authSchemeSpecUtils;
    private final ClassName configurationClassName;
    private final ClassName configurationBuilderClassName;
    private final ClassName sdkClientConfigurationUtilClassName;

    public ServiceClientConfigurationUtils(IntermediateModel model) {
        String basePackage = model.getMetadata().getFullClientPackageName();
        String serviceId = model.getMetadata().getServiceName();
        this.configurationClassName = ClassName.get((String)basePackage, (String)(serviceId + "ServiceClientConfiguration"), (String[])new String[0]);
        this.configurationBuilderClassName = ClassName.get((String)model.getMetadata().getFullClientInternalPackageName(), (String)(serviceId + "ServiceClientConfigurationBuilder"), (String[])new String[0]);
        this.sdkClientConfigurationUtilClassName = ClassName.get((String)model.getMetadata().getFullClientInternalPackageName(), (String)"SdkClientConfigurationUtil", (String[])new String[0]);
        this.authSchemeSpecUtils = new AuthSchemeSpecUtils(model);
    }

    public ClassName serviceClientConfigurationClassName() {
        return this.configurationClassName;
    }

    public ClassName serviceClientConfigurationBuilderClassName() {
        return this.configurationBuilderClassName;
    }

    public List<Field> serviceClientConfigurationFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(this.overrideConfigurationField());
        fields.addAll(BASE_FIELDS);
        fields.add(Field.builder("authSchemeProvider", (TypeName)this.authSchemeSpecUtils.providerInterfaceName()).doc("auth scheme provider").optionClass(SdkClientOption.class).optionValue((ClientOption<?>)SdkClientOption.AUTH_SCHEME_PROVIDER).baseType((TypeName)ClassName.get(AuthSchemeProvider.class)).build());
        return fields;
    }

    private Field overrideConfigurationField() {
        Field.Builder builder = Field.builder("overrideConfiguration", ClientOverrideConfiguration.class).doc("client override configuration").definingClass(SdkServiceClientConfiguration.class);
        builder.copyToConfiguration(CodeBlock.builder().beginControlFlow("if (overrideConfiguration != null)", new Object[0]).addStatement("$T.copyOverridesToConfiguration(overrideConfiguration, internalBuilder)", new Object[]{this.sdkClientConfigurationUtilClassName}).endControlFlow().build());
        return builder.build();
    }

    private static List<Field> baseServiceClientConfigurationFields() {
        return Arrays.asList(ServiceClientConfigurationUtils.endpointOverrideField(), Field.builder("endpointProvider", EndpointProvider.class).doc("endpoint provider").definingClass(SdkServiceClientConfiguration.class).optionClass(SdkClientOption.class).optionValue((ClientOption<?>)SdkClientOption.ENDPOINT_PROVIDER).build(), Field.builder("region", Region.class).doc("AWS region").definingClass(AwsServiceClientConfiguration.class).optionClass(AwsClientOption.class).optionValue((ClientOption<?>)AwsClientOption.AWS_REGION).build(), ServiceClientConfigurationUtils.credentialsProviderField(), ServiceClientConfigurationUtils.authSchemesField());
    }

    private static Field endpointOverrideField() {
        Field.Builder builder = Field.builder("endpointOverride", URI.class).doc("endpoint override").definingClass(SdkServiceClientConfiguration.class);
        builder.constructFromConfiguration(CodeBlock.builder().beginControlFlow("if (Boolean.TRUE.equals(internalBuilder.option($T.$L)))", new Object[]{SdkClientOption.class, ServiceClientConfigurationUtils.fieldName(SdkClientOption.ENDPOINT_OVERRIDDEN, SdkClientOption.class)}).addStatement("this.endpointOverride = internalBuilder.option($T.$L)", new Object[]{SdkClientOption.class, ServiceClientConfigurationUtils.fieldName(SdkClientOption.ENDPOINT, SdkClientOption.class)}).endControlFlow().build());
        builder.copyToConfiguration(CodeBlock.builder().beginControlFlow("if (endpointOverride != null)", new Object[0]).addStatement("internalBuilder.option($T.$L, endpointOverride)", new Object[]{SdkClientOption.class, ServiceClientConfigurationUtils.fieldName(SdkClientOption.ENDPOINT, SdkClientOption.class)}).addStatement("internalBuilder.option($T.$L, true)", new Object[]{SdkClientOption.class, ServiceClientConfigurationUtils.fieldName(SdkClientOption.ENDPOINT_OVERRIDDEN, SdkClientOption.class)}).endControlFlow().build());
        return builder.build();
    }

    private static Field credentialsProviderField() {
        Field.Builder builder = Field.builder("credentialsProvider", (TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(IdentityProvider.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(AwsCredentialsIdentity.class)})).doc("credentials provider").definingClass(AwsServiceClientConfiguration.class);
        builder.constructFromConfiguration(CodeBlock.builder().addStatement("this.credentialsProvider = internalBuilder.option($T.$L)", new Object[]{AwsClientOption.class, ServiceClientConfigurationUtils.fieldName(AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER, AwsClientOption.class)}).build());
        builder.copyToConfiguration(CodeBlock.builder().beginControlFlow("if (credentialsProvider != null && !credentialsProvider.equals(internalBuilder.option($T.$L)))", new Object[]{AwsClientOption.class, ServiceClientConfigurationUtils.fieldName(AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER, AwsClientOption.class)}).addStatement("internalBuilder.option($T.$L, credentialsProvider)", new Object[]{AwsClientOption.class, ServiceClientConfigurationUtils.fieldName(AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER, AwsClientOption.class)}).addStatement("$T identityProviders = internalBuilder.option($T.$L)", new Object[]{IdentityProviders.class, SdkClientOption.class, ServiceClientConfigurationUtils.fieldName(SdkClientOption.IDENTITY_PROVIDERS, SdkClientOption.class)}).beginControlFlow("if (identityProviders == null)", new Object[0]).addStatement("identityProviders = $T.builder().putIdentityProvider(credentialsProvider).build()", new Object[]{IdentityProviders.class}).nextControlFlow(" else ", new Object[0]).addStatement("identityProviders = identityProviders.toBuilder().putIdentityProvider(credentialsProvider).build()", new Object[0]).endControlFlow().addStatement("internalBuilder.option($T.$L, identityProviders)", new Object[]{SdkClientOption.class, ServiceClientConfigurationUtils.fieldName(SdkClientOption.IDENTITY_PROVIDERS, SdkClientOption.class)}).endControlFlow().build());
        return builder.build();
    }

    private static Field authSchemesField() {
        ParameterizedTypeName authSchemeGenericType = ParameterizedTypeName.get((ClassName)ClassName.get(AuthScheme.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)});
        ParameterizedTypeName authSchemesType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), authSchemeGenericType});
        Field.Builder builder = Field.builder("authSchemes", (TypeName)authSchemesType).doc("auth schemes").definingClass(SdkServiceClientConfiguration.class);
        builder.constructFromConfiguration(CodeBlock.builder().addStatement("$T authSchemes = internalBuilder.option($T.$L)", new Object[]{authSchemesType, SdkClientOption.class, ServiceClientConfigurationUtils.fieldName(SdkClientOption.AUTH_SCHEMES, SdkClientOption.class)}).beginControlFlow("if (authSchemes != null)", new Object[0]).addStatement("authSchemes = new $T<>(authSchemes)", new Object[]{HashMap.class}).endControlFlow().addStatement("this.authSchemes = authSchemes", new Object[0]).build());
        builder.copyToConfiguration(CodeBlock.builder().beginControlFlow("if (authSchemes != null && !authSchemes.equals(internalBuilder.option($T.$L)))", new Object[]{SdkClientOption.class, ServiceClientConfigurationUtils.fieldName(SdkClientOption.AUTH_SCHEMES, SdkClientOption.class)}).addStatement("internalBuilder.option($T.$L, authSchemes())", new Object[]{SdkClientOption.class, ServiceClientConfigurationUtils.fieldName(SdkClientOption.AUTH_SCHEMES, SdkClientOption.class)}).endControlFlow().build());
        builder.builderSetterImpl(MethodSpec.methodBuilder((String)"putAuthScheme").addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)authSchemeGenericType, "authScheme", new javax.lang.model.element.Modifier[0]).beginControlFlow("if (authSchemes == null)", new Object[0]).addStatement("authSchemes = new $T<>()", new Object[]{HashMap.class}).endControlFlow().addStatement("authSchemes.put(authScheme.schemeId(), authScheme)", new Object[0]).addStatement("return this", new Object[0]).build());
        builder.builderSetter(MethodSpec.methodBuilder((String)"putAuthScheme").addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)authSchemeGenericType, "authScheme", new javax.lang.model.element.Modifier[0]).build());
        builder.builderGetterImpl(MethodSpec.methodBuilder((String)"authSchemes").addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)authSchemesType).beginControlFlow("if (authSchemes == null)", new Object[0]).addStatement("return $T.emptyMap()", new Object[]{Collections.class}).endControlFlow().addStatement("return $T.unmodifiableMap(new $T<>(authSchemes))", new Object[]{Collections.class, HashMap.class}).build());
        return builder.build();
    }

    private static String fieldName(Object fieldObject, Class<?> parent) {
        java.lang.reflect.Field[] allFields;
        for (java.lang.reflect.Field field : allFields = parent.getFields()) {
            Object currentFieldObject;
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers)) continue;
            try {
                currentFieldObject = field.get(null);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            boolean isWantedField = fieldObject.equals(currentFieldObject);
            if (!isWantedField) continue;
            return field.getName();
        }
        throw new NoSuchElementException(String.format("cannot find constant %s in class %s", fieldObject, parent.getClass().getName()));
    }

    static class Field {
        private final String name;
        private final TypeName type;
        private final Class<? extends SdkServiceClientConfiguration> definingClass;
        private final Class<? extends ClientOption> optionClass;
        private final String optionName;
        private final String doc;
        private final TypeName baseType;
        private final CodeBlock constructFromConfiguration;
        private final CodeBlock copyToConfiguration;
        private final MethodSpec builderSetterImpl;
        private final MethodSpec builderSetter;
        private final MethodSpec builderGetterImpl;

        Field(Builder builder) {
            this.name = (String)Validate.paramNotNull((Object)builder.name, (String)"name");
            this.type = (TypeName)Validate.paramNotNull((Object)builder.type, (String)"type");
            this.definingClass = builder.definingClass;
            this.doc = (String)Validate.paramNotNull((Object)builder.doc, (String)"doc");
            this.optionClass = builder.optionClass;
            this.optionName = builder.optionName;
            this.baseType = builder.baseType;
            this.constructFromConfiguration = builder.constructFromConfiguration;
            this.copyToConfiguration = builder.copyToConfiguration;
            this.builderSetterImpl = builder.builderSetterImpl;
            this.builderSetter = builder.builderSetter;
            this.builderGetterImpl = builder.builderGetterImpl;
        }

        public boolean isLocalField() {
            return this.definingClass == null;
        }

        public String name() {
            return this.name;
        }

        public TypeName type() {
            return this.type;
        }

        public Class<? extends SdkServiceClientConfiguration> definingClass() {
            return this.definingClass;
        }

        public Class<? extends ClientOption> optionClass() {
            return this.optionClass;
        }

        public String optionName() {
            return this.optionName;
        }

        public String doc() {
            return this.doc;
        }

        public TypeName baseType() {
            return this.baseType;
        }

        public CodeBlock constructFromConfiguration() {
            return this.constructFromConfiguration;
        }

        public CodeBlock copyToConfiguration() {
            return this.copyToConfiguration;
        }

        public MethodSpec builderSetterImpl() {
            return this.builderSetterImpl;
        }

        public MethodSpec builderSetter() {
            return this.builderSetter;
        }

        public MethodSpec builderGetterImpl() {
            return this.builderGetterImpl;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Builder builder(String name, TypeName type) {
            return new Builder().name(name).type(type);
        }

        public static Builder builder(String name, Class<?> type) {
            return new Builder().name(name).type(type);
        }

        static class Builder {
            private String name;
            private TypeName type;
            private String doc;
            private Class<? extends SdkServiceClientConfiguration> definingClass;
            private Class<? extends ClientOption> optionClass;
            private ClientOption<?> value;
            private String optionName;
            private TypeName baseType;
            private CodeBlock constructFromConfiguration;
            private CodeBlock copyToConfiguration;
            private MethodSpec builderSetterImpl;
            private MethodSpec builderSetter;
            private MethodSpec builderGetterImpl;

            Builder() {
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder type(Class<?> type) {
                this.type = ClassName.get(type);
                return this;
            }

            public Builder type(TypeName type) {
                this.type = type;
                return this;
            }

            public Builder doc(String doc) {
                this.doc = doc;
                return this;
            }

            public Builder optionClass(Class<? extends ClientOption> optionClass) {
                this.optionClass = optionClass;
                return this;
            }

            public Builder optionValue(ClientOption<?> value) {
                this.value = value;
                return this;
            }

            public Builder baseType(TypeName baseType) {
                this.baseType = baseType;
                return this;
            }

            public Builder definingClass(Class<? extends SdkServiceClientConfiguration> definingClass) {
                this.definingClass = definingClass;
                return this;
            }

            public Builder constructFromConfiguration(CodeBlock constructFromConfiguration) {
                this.constructFromConfiguration = constructFromConfiguration;
                return this;
            }

            public Builder copyToConfiguration(CodeBlock copyToConfiguration) {
                this.copyToConfiguration = copyToConfiguration;
                return this;
            }

            public Builder builderSetterImpl(MethodSpec builderSetter) {
                this.builderSetterImpl = builderSetter;
                return this;
            }

            public Builder builderSetter(MethodSpec builderSetter) {
                this.builderSetter = builderSetter;
                return this;
            }

            public Builder builderGetterImpl(MethodSpec builderGetterImpl) {
                this.builderGetterImpl = builderGetterImpl;
                return this;
            }

            public Field build() {
                if (this.value != null && this.optionClass != null) {
                    this.optionName = ServiceClientConfigurationUtils.fieldName(this.value, this.optionClass);
                }
                return new Field(this);
            }
        }
    }
}

