/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.jmespath.component;

import software.amazon.awssdk.codegen.jmespath.component.Expression;
import software.amazon.awssdk.codegen.jmespath.component.ExpressionType;
import software.amazon.awssdk.codegen.jmespath.parser.JmesPathVisitor;
import software.amazon.awssdk.utils.Validate;

public class FunctionArg {
    private Expression expression;
    private ExpressionType expressionType;

    private FunctionArg() {
    }

    public static FunctionArg expression(Expression expression) {
        Validate.notNull((Object)expression, (String)"expression", (Object[])new Object[0]);
        FunctionArg result = new FunctionArg();
        result.expression = expression;
        return result;
    }

    public static FunctionArg expressionType(ExpressionType expressionType) {
        Validate.notNull((Object)expressionType, (String)"expressionType", (Object[])new Object[0]);
        FunctionArg result = new FunctionArg();
        result.expressionType = expressionType;
        return result;
    }

    public boolean isExpression() {
        return this.expression != null;
    }

    public boolean isExpressionType() {
        return this.expressionType != null;
    }

    public Expression asExpression() {
        Validate.validState((boolean)this.isExpression(), (String)"Not a Expression", (Object[])new Object[0]);
        return this.expression;
    }

    public ExpressionType asExpressionType() {
        Validate.validState((boolean)this.isExpressionType(), (String)"Not a ExpressionType", (Object[])new Object[0]);
        return this.expressionType;
    }

    public void visit(JmesPathVisitor visitor) {
        if (this.isExpression()) {
            visitor.visitExpression(this.asExpression());
        } else if (this.isExpressionType()) {
            visitor.visitExpressionType(this.asExpressionType());
        } else {
            throw new IllegalStateException();
        }
    }
}

