/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.codegen.docs.ClientType;
import software.amazon.awssdk.codegen.docs.DocConfiguration;
import software.amazon.awssdk.codegen.docs.SimpleMethodOverload;
import software.amazon.awssdk.codegen.docs.WaiterDocs;
import software.amazon.awssdk.codegen.model.config.customization.UtilitiesMethod;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.client.AsyncClientInterface;
import software.amazon.awssdk.codegen.poet.client.ClientClassUtils;
import software.amazon.awssdk.codegen.poet.model.DeprecationUtils;
import software.amazon.awssdk.codegen.utils.PaginatorUtils;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServiceMetadataProvider;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;

public class SyncClientInterface
implements ClassSpec {
    private final IntermediateModel model;
    private final ClassName className;
    private final String clientPackageName;
    private final PoetExtension poetExtensions;

    public SyncClientInterface(IntermediateModel model) {
        this.model = model;
        this.clientPackageName = model.getMetadata().getFullClientPackageName();
        this.className = ClassName.get((String)this.clientPackageName, (String)model.getMetadata().getSyncInterface(), (String[])new String[0]);
        this.poetExtensions = new PoetExtension(model);
    }

    @Override
    public final TypeSpec poetSpec() {
        TypeSpec.Builder result = this.createTypeSpec();
        this.addInterfaceClass(result);
        this.addAnnotations(result);
        this.addModifiers(result);
        this.addFields(result);
        result.addMethods(this.operations());
        if (this.model.getCustomizationConfig().getUtilitiesMethod() != null) {
            result.addMethod(this.utilitiesMethod());
        }
        if (this.model.hasWaiters()) {
            result.addMethod(this.waiterMethod());
        }
        this.addAdditionalMethods(result);
        result.addMethod(this.serviceClientConfigMethod());
        this.addCloseMethod(result);
        return result.build();
    }

    protected void addInterfaceClass(TypeSpec.Builder type) {
        type.addSuperinterface(AwsClient.class);
    }

    protected TypeSpec.Builder createTypeSpec() {
        return PoetUtils.createInterfaceBuilder(this.className);
    }

    protected void addAnnotations(TypeSpec.Builder type) {
        type.addAnnotation(SdkPublicApi.class).addAnnotation(ThreadSafe.class);
    }

    protected void addModifiers(TypeSpec.Builder type) {
    }

    protected void addCloseMethod(TypeSpec.Builder type) {
    }

    protected void addFields(TypeSpec.Builder type) {
        type.addField(FieldSpec.builder(String.class, (String)"SERVICE_NAME", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{this.model.getMetadata().getSigningName()}).build()).addField(FieldSpec.builder(String.class, (String)"SERVICE_METADATA_ID", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{this.model.getMetadata().getEndpointPrefix()}).addJavadoc("Value for looking up the service's metadata from the {@link $T}.", new Object[]{ServiceMetadataProvider.class}).build());
    }

    protected void addAdditionalMethods(TypeSpec.Builder type) {
        if (!this.model.getCustomizationConfig().isExcludeClientCreateMethod()) {
            type.addMethod(this.create());
        }
        type.addMethod(this.builder()).addMethod(this.serviceMetadata());
        PoetUtils.addJavadoc(x$0 -> type.addJavadoc(x$0, new Object[0]), this.getJavadoc());
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    private String getJavadoc() {
        return "Service client for accessing " + this.model.getMetadata().getDescriptiveServiceName() + ". This can be created using the static {@link #builder()} method.\n\n" + this.model.getMetadata().getDocumentation();
    }

    private MethodSpec create() {
        return MethodSpec.methodBuilder((String)"create").returns((TypeName)this.className).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addJavadoc("Create a {@link $T} with the region loaded from the {@link $T} and credentials loaded from the {@link $T}.", new Object[]{this.className, DefaultAwsRegionProviderChain.class, DefaultCredentialsProvider.class}).addStatement("return builder().build()", new Object[0]).build();
    }

    private MethodSpec builder() {
        ClassName builderClass = ClassName.get((String)this.clientPackageName, (String)this.model.getMetadata().getSyncBuilder(), (String[])new String[0]);
        ClassName builderInterface = ClassName.get((String)this.clientPackageName, (String)this.model.getMetadata().getSyncBuilderInterface(), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"builder").returns((TypeName)builderInterface).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addJavadoc("Create a builder that can be used to configure and create a {@link $T}.", new Object[]{this.className}).addStatement("return new $T()", new Object[]{builderClass}).build();
    }

    protected Iterable<MethodSpec> operations() {
        return this.model.getOperations().values().stream().filter(o -> !o.hasEventStreamInput()).filter(o -> !o.hasEventStreamOutput()).map(this::operationMethodSpec).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private MethodSpec serviceMetadata() {
        return MethodSpec.methodBuilder((String)"serviceMetadata").returns(ServiceMetadata.class).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addStatement("return $T.of(SERVICE_METADATA_ID)", new Object[]{ServiceMetadata.class}).build();
    }

    private List<MethodSpec> operationMethodSpec(OperationModel opModel) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        if (opModel.getInputShape().isSimpleMethod()) {
            methods.add(this.simpleMethod(opModel));
        }
        methods.addAll(this.operation(opModel));
        methods.addAll(this.streamingSimpleMethods(opModel));
        methods.addAll(this.paginatedMethods(opModel));
        return methods.stream().map(m -> DeprecationUtils.checkDeprecated(opModel, m)).collect(Collectors.toList());
    }

    private MethodSpec simpleMethod(OperationModel opModel) {
        ClassName requestType = ClassName.get((String)this.model.getMetadata().getFullModelPackageName(), (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        return this.operationSimpleMethodSignature(this.model, opModel, opModel.getMethodName()).addStatement("return $L($T.builder().build())", new Object[]{opModel.getMethodName(), requestType}).addJavadoc(opModel.getDocs(this.model, ClientType.SYNC, SimpleMethodOverload.NO_ARG), new Object[0]).build();
    }

    private static MethodSpec.Builder operationBaseSignature(IntermediateModel model, OperationModel opModel, Consumer<MethodSpec.Builder> addFirstParameter, SimpleMethodOverload simpleMethodOverload, String methodName) {
        ClassName responseType = ClassName.get((String)model.getMetadata().getFullModelPackageName(), (String)opModel.getReturnType().getReturnType(), (String[])new String[0]);
        TypeVariableName returnType = opModel.hasStreamingOutput() ? AsyncClientInterface.STREAMING_TYPE_VARIABLE : responseType;
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).returns((TypeName)returnType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(opModel.getDocs(model, ClientType.SYNC, simpleMethodOverload), new Object[0]).addExceptions(SyncClientInterface.getExceptionClasses(model, opModel));
        addFirstParameter.accept(methodBuilder);
        SyncClientInterface.streamingMethod(methodBuilder, opModel, (TypeName)responseType);
        return methodBuilder;
    }

    private List<MethodSpec> operation(OperationModel opModel) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        MethodSpec.Builder builder = SyncClientInterface.operationMethodSignature(this.model, opModel);
        MethodSpec method = this.operationBody(builder, opModel).build();
        methods.add(method);
        this.addConsumerMethod(methods, method, SimpleMethodOverload.NORMAL, opModel);
        return methods;
    }

    protected MethodSpec.Builder operationBody(MethodSpec.Builder builder, OperationModel opModel) {
        return builder.addModifiers(new Modifier[]{Modifier.DEFAULT}).addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class});
    }

    static MethodSpec.Builder operationMethodSignature(IntermediateModel model, OperationModel opModel) {
        return SyncClientInterface.operationMethodSignature(model, opModel, SimpleMethodOverload.NORMAL, opModel.getMethodName());
    }

    static MethodSpec.Builder operationMethodSignature(IntermediateModel model, OperationModel opModel, SimpleMethodOverload simpleMethodOverload, String methodName) {
        ClassName requestType = ClassName.get((String)model.getMetadata().getFullModelPackageName(), (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        return SyncClientInterface.operationBaseSignature(model, opModel, b -> b.addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]), simpleMethodOverload, methodName);
    }

    private MethodSpec.Builder operationSimpleMethodSignature(IntermediateModel model, OperationModel opModel, String methodName) {
        ClassName returnType = ClassName.get((String)model.getMetadata().getFullModelPackageName(), (String)opModel.getReturnType().getReturnType(), (String[])new String[0]);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).returns((TypeName)returnType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addExceptions(SyncClientInterface.getExceptionClasses(model, opModel));
        return this.simpleMethodModifier(builder);
    }

    protected List<MethodSpec> paginatedMethods(OperationModel opModel) {
        ArrayList<MethodSpec> paginatedMethodSpecs = new ArrayList<MethodSpec>();
        if (opModel.isPaginated()) {
            if (opModel.getInputShape().isSimpleMethod()) {
                paginatedMethodSpecs.add(this.paginatedSimpleMethod(opModel));
            }
            MethodSpec.Builder paginatedMethodBuilder = SyncClientInterface.operationMethodSignature(this.model, opModel, SimpleMethodOverload.PAGINATED, PaginatorUtils.getPaginatedMethodName(opModel.getMethodName())).returns((TypeName)this.poetExtensions.getResponseClassForPaginatedSyncOperation(opModel.getOperationName()));
            MethodSpec paginatedMethod = this.paginatedMethodBody(paginatedMethodBuilder, opModel).build();
            paginatedMethodSpecs.add(paginatedMethod);
            this.addConsumerMethod(paginatedMethodSpecs, paginatedMethod, SimpleMethodOverload.PAGINATED, opModel);
        }
        return paginatedMethodSpecs;
    }

    private MethodSpec paginatedSimpleMethod(OperationModel opModel) {
        String paginatedMethodName = PaginatorUtils.getPaginatedMethodName(opModel.getMethodName());
        ClassName requestType = ClassName.get((String)this.model.getMetadata().getFullModelPackageName(), (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        return this.operationSimpleMethodSignature(this.model, opModel, paginatedMethodName).returns((TypeName)this.poetExtensions.getResponseClassForPaginatedSyncOperation(opModel.getOperationName())).addStatement("return $L($T.builder().build())", new Object[]{paginatedMethodName, requestType}).addJavadoc(opModel.getDocs(this.model, ClientType.SYNC, SimpleMethodOverload.NO_ARG_PAGINATED), new Object[0]).build();
    }

    protected MethodSpec.Builder paginatedMethodBody(MethodSpec.Builder builder, OperationModel operationModel) {
        return builder.addModifiers(new Modifier[]{Modifier.DEFAULT}).addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class});
    }

    private static void streamingMethod(MethodSpec.Builder methodBuilder, OperationModel opModel, TypeName responseType) {
        if (opModel.hasStreamingInput()) {
            methodBuilder.addParameter((TypeName)ClassName.get(RequestBody.class), "requestBody", new Modifier[0]);
        }
        if (opModel.hasStreamingOutput()) {
            methodBuilder.addTypeVariable(AsyncClientInterface.STREAMING_TYPE_VARIABLE);
            ParameterizedTypeName streamingResponseHandlerType = ParameterizedTypeName.get((ClassName)ClassName.get(ResponseTransformer.class), (TypeName[])new TypeName[]{responseType, AsyncClientInterface.STREAMING_TYPE_VARIABLE});
            methodBuilder.addParameter((TypeName)streamingResponseHandlerType, "responseTransformer", new Modifier[0]);
        }
    }

    private List<MethodSpec> streamingSimpleMethods(OperationModel opModel) {
        ClassName responseType = ClassName.get((String)this.model.getMetadata().getFullModelPackageName(), (String)opModel.getReturnType().getReturnType(), (String[])new String[0]);
        ClassName requestType = ClassName.get((String)this.model.getMetadata().getFullModelPackageName(), (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        ArrayList<MethodSpec> simpleMethods = new ArrayList<MethodSpec>();
        if (opModel.hasStreamingInput() && opModel.hasStreamingOutput()) {
            MethodSpec simpleMethod = this.streamingInputOutputFileSimpleMethod(opModel, (TypeName)responseType, requestType);
            simpleMethods.add(simpleMethod);
            this.addConsumerMethod(simpleMethods, simpleMethod, SimpleMethodOverload.FILE, opModel);
        } else if (opModel.hasStreamingInput()) {
            MethodSpec simpleMethod = this.uploadFromFileSimpleMethod(opModel, (TypeName)responseType, requestType);
            simpleMethods.add(simpleMethod);
            this.addConsumerMethod(simpleMethods, simpleMethod, SimpleMethodOverload.FILE, opModel);
        } else if (opModel.hasStreamingOutput()) {
            MethodSpec downloadToFileSimpleMethod = this.downloadToFileSimpleMethod(opModel, (TypeName)responseType, requestType);
            MethodSpec inputStreamSimpleMethod = this.inputStreamSimpleMethod(opModel, (TypeName)responseType, requestType);
            MethodSpec bytesSimpleMethod = this.bytesSimpleMethod(opModel, (TypeName)responseType, requestType);
            simpleMethods.add(downloadToFileSimpleMethod);
            this.addConsumerMethod(simpleMethods, downloadToFileSimpleMethod, SimpleMethodOverload.FILE, opModel);
            simpleMethods.add(inputStreamSimpleMethod);
            this.addConsumerMethod(simpleMethods, inputStreamSimpleMethod, SimpleMethodOverload.INPUT_STREAM, opModel);
            simpleMethods.add(bytesSimpleMethod);
            this.addConsumerMethod(simpleMethods, bytesSimpleMethod, SimpleMethodOverload.BYTES, opModel);
        }
        return simpleMethods;
    }

    protected void addConsumerMethod(List<MethodSpec> specs, MethodSpec spec, SimpleMethodOverload overload, OperationModel opModel) {
        String fileConsumerBuilderJavadoc = this.consumerBuilderJavadoc(opModel, overload);
        specs.add(ClientClassUtils.consumerBuilderVariant(spec, fileConsumerBuilderJavadoc));
    }

    private MethodSpec uploadFromFileSimpleMethod(OperationModel opModel, TypeName responseType, ClassName requestType) {
        String methodName = opModel.getMethodName();
        ParameterSpec inputVarParam = ParameterSpec.builder((TypeName)requestType, (String)opModel.getInput().getVariableName(), (Modifier[])new Modifier[0]).build();
        ParameterSpec srcPathParam = ParameterSpec.builder((TypeName)ClassName.get(Path.class), (String)"sourcePath", (Modifier[])new Modifier[0]).build();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).returns(responseType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(inputVarParam).addParameter(srcPathParam).addJavadoc(opModel.getDocs(this.model, ClientType.SYNC, SimpleMethodOverload.FILE), new Object[0]).addExceptions(SyncClientInterface.getExceptionClasses(this.model, opModel)).addStatement("return $L($N, $T.fromFile($N))", new Object[]{methodName, inputVarParam, ClassName.get(RequestBody.class), srcPathParam});
        return this.simpleMethodModifier(builder).build();
    }

    private MethodSpec inputStreamSimpleMethod(OperationModel opModel, TypeName responseType, ClassName requestType) {
        ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)ClassName.get(ResponseInputStream.class), (TypeName[])new TypeName[]{responseType});
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)opModel.getMethodName()).returns((TypeName)returnType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]).addJavadoc(opModel.getDocs(this.model, ClientType.SYNC, SimpleMethodOverload.INPUT_STREAM), new Object[0]).addExceptions(SyncClientInterface.getExceptionClasses(this.model, opModel)).addStatement("return $L($L, $T.toInputStream())", new Object[]{opModel.getMethodName(), opModel.getInput().getVariableName(), ClassName.get(ResponseTransformer.class)});
        return this.simpleMethodModifier(builder).build();
    }

    private MethodSpec bytesSimpleMethod(OperationModel opModel, TypeName responseType, ClassName requestType) {
        ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)ClassName.get(ResponseBytes.class), (TypeName[])new TypeName[]{responseType});
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)(opModel.getMethodName() + "AsBytes")).returns((TypeName)returnType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]).addJavadoc(opModel.getDocs(this.model, ClientType.SYNC, SimpleMethodOverload.BYTES), new Object[0]).addExceptions(SyncClientInterface.getExceptionClasses(this.model, opModel)).addStatement("return $L($L, $T.toBytes())", new Object[]{opModel.getMethodName(), opModel.getInput().getVariableName(), ClassName.get(ResponseTransformer.class)});
        return this.simpleMethodModifier(builder).build();
    }

    private MethodSpec downloadToFileSimpleMethod(OperationModel opModel, TypeName responseType, ClassName requestType) {
        String methodName = opModel.getMethodName();
        ParameterSpec inputVarParam = ParameterSpec.builder((TypeName)requestType, (String)opModel.getInput().getVariableName(), (Modifier[])new Modifier[0]).build();
        ParameterSpec dstFileParam = ParameterSpec.builder((TypeName)ClassName.get(Path.class), (String)"destinationPath", (Modifier[])new Modifier[0]).build();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).returns(responseType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(inputVarParam).addParameter(dstFileParam).addJavadoc(opModel.getDocs(this.model, ClientType.SYNC, SimpleMethodOverload.FILE), new Object[0]).addExceptions(SyncClientInterface.getExceptionClasses(this.model, opModel)).addStatement("return $L($N, $T.toFile($N))", new Object[]{methodName, inputVarParam, ClassName.get(ResponseTransformer.class), dstFileParam});
        return this.simpleMethodModifier(builder).build();
    }

    private MethodSpec streamingInputOutputFileSimpleMethod(OperationModel opModel, TypeName responseType, ClassName requestType) {
        String methodName = opModel.getMethodName();
        ParameterSpec inputVarParam = ParameterSpec.builder((TypeName)requestType, (String)opModel.getInput().getVariableName(), (Modifier[])new Modifier[0]).build();
        ParameterSpec srcFileParam = ParameterSpec.builder((TypeName)ClassName.get(Path.class), (String)"sourcePath", (Modifier[])new Modifier[0]).build();
        ParameterSpec dstFileParam = ParameterSpec.builder((TypeName)ClassName.get(Path.class), (String)"destinationPath", (Modifier[])new Modifier[0]).build();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).returns(responseType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(inputVarParam).addParameter(srcFileParam).addParameter(dstFileParam).addJavadoc(opModel.getDocs(this.model, ClientType.SYNC, SimpleMethodOverload.FILE), new Object[0]).addExceptions(SyncClientInterface.getExceptionClasses(this.model, opModel)).addStatement("return $L($N, $T.fromFile($N), $T.toFile($N))", new Object[]{methodName, inputVarParam, ClassName.get(RequestBody.class), srcFileParam, ClassName.get(ResponseTransformer.class), dstFileParam});
        return this.simpleMethodModifier(builder).build();
    }

    protected MethodSpec.Builder simpleMethodModifier(MethodSpec.Builder builder) {
        return builder.addModifiers(new Modifier[]{Modifier.DEFAULT});
    }

    private static List<ClassName> getExceptionClasses(IntermediateModel model, OperationModel opModel) {
        List exceptions = opModel.getExceptions().stream().map(e -> ClassName.get((String)model.getMetadata().getFullModelPackageName(), (String)e.getExceptionName(), (String[])new String[0])).collect(Collectors.toCollection(ArrayList::new));
        Collections.addAll(exceptions, ClassName.get(AwsServiceException.class), ClassName.get(SdkClientException.class), ClassName.get((String)model.getMetadata().getFullModelPackageName(), (String)model.getSdkModeledExceptionBaseClassName(), (String[])new String[0]));
        return exceptions;
    }

    private String consumerBuilderJavadoc(OperationModel opModel, SimpleMethodOverload overload) {
        return opModel.getDocs(this.model, ClientType.SYNC, overload, new DocConfiguration().isConsumerBuilder(true));
    }

    protected MethodSpec utilitiesMethod() {
        UtilitiesMethod config = this.model.getCustomizationConfig().getUtilitiesMethod();
        ClassName returnType = PoetUtils.classNameFromFqcn(config.getReturnType());
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"utilities").returns((TypeName)returnType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Creates an instance of {@link $T} object with the configuration set on this client.", new Object[]{returnType});
        return this.utilitiesOperationBody(builder).build();
    }

    protected MethodSpec serviceClientConfigMethod() {
        return MethodSpec.methodBuilder((String)"serviceClientConfiguration").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class}).returns((TypeName)new PoetExtension(this.model).getServiceConfigClass()).build();
    }

    protected MethodSpec.Builder utilitiesOperationBody(MethodSpec.Builder builder) {
        return builder.addModifiers(new Modifier[]{Modifier.DEFAULT}).addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class});
    }

    protected MethodSpec waiterMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"waiter").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.poetExtensions.getSyncWaiterInterface()).addJavadoc(WaiterDocs.waiterMethodInClient(this.poetExtensions.getSyncWaiterInterface()));
        return this.waiterOperationBody(builder).build();
    }

    protected MethodSpec.Builder waiterOperationBody(MethodSpec.Builder builder) {
        return builder.addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class});
    }
}

