/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.codegen.docs.ClientType;
import software.amazon.awssdk.codegen.docs.DocConfiguration;
import software.amazon.awssdk.codegen.docs.SimpleMethodOverload;
import software.amazon.awssdk.codegen.docs.WaiterDocs;
import software.amazon.awssdk.codegen.model.config.customization.AdditionalBuilderMethod;
import software.amazon.awssdk.codegen.model.config.customization.UtilitiesMethod;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.client.ClientClassUtils;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamUtils;
import software.amazon.awssdk.codegen.poet.model.DeprecationUtils;
import software.amazon.awssdk.codegen.utils.PaginatorUtils;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadataProvider;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.utils.Validate;

public class AsyncClientInterface
implements ClassSpec {
    public static final TypeVariableName STREAMING_TYPE_VARIABLE = TypeVariableName.get((String)"ReturnT");
    protected final IntermediateModel model;
    protected final ClassName className;
    protected final String clientPackageName;
    private final String modelPackage;
    private final PoetExtension poetExtensions;

    public AsyncClientInterface(IntermediateModel model) {
        this.modelPackage = model.getMetadata().getFullModelPackageName();
        this.clientPackageName = model.getMetadata().getFullClientPackageName();
        this.model = model;
        this.className = ClassName.get((String)model.getMetadata().getFullClientPackageName(), (String)model.getMetadata().getAsyncInterface(), (String[])new String[0]);
        this.poetExtensions = new PoetExtension(model);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder result = this.createTypeSpec();
        this.addInterfaceClass(result);
        this.addAnnotations(result);
        this.addModifiers(result);
        this.addFields(result);
        if (this.model.getCustomizationConfig().getUtilitiesMethod() != null) {
            result.addMethod(this.utilitiesMethod());
        }
        result.addMethods(this.operations());
        if (this.model.hasWaiters()) {
            this.addWaiterMethod(result);
        }
        this.addAdditionalMethods(result);
        this.addCloseMethod(result);
        return result.build();
    }

    protected TypeSpec.Builder createTypeSpec() {
        return PoetUtils.createInterfaceBuilder(this.className);
    }

    protected void addInterfaceClass(TypeSpec.Builder type) {
        type.addSuperinterface(SdkClient.class);
    }

    protected void addAnnotations(TypeSpec.Builder type) {
        type.addAnnotation(SdkPublicApi.class).addAnnotation(ThreadSafe.class);
    }

    protected void addModifiers(TypeSpec.Builder type) {
    }

    protected void addCloseMethod(TypeSpec.Builder type) {
    }

    protected void addFields(TypeSpec.Builder type) {
        type.addField(FieldSpec.builder(String.class, (String)"SERVICE_NAME", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{this.model.getMetadata().getSigningName()}).build()).addField(FieldSpec.builder(String.class, (String)"SERVICE_METADATA_ID", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{this.model.getMetadata().getEndpointPrefix()}).addJavadoc("Value for looking up the service's metadata from the {@link $T}.", new Object[]{ServiceMetadataProvider.class}).build());
    }

    protected void addAdditionalMethods(TypeSpec.Builder type) {
        if (!this.model.getCustomizationConfig().isExcludeClientCreateMethod()) {
            type.addMethod(this.create());
        }
        type.addMethod(this.builder());
        List<AdditionalBuilderMethod> additionaBuilders = this.model.getCustomizationConfig().getAdditionalBuilderMethods();
        if (additionaBuilders != null && !additionaBuilders.isEmpty()) {
            additionaBuilders.stream().filter(builder -> software.amazon.awssdk.core.ClientType.ASYNC.equals((Object)builder.getClientTypeEnum())).forEach(builders -> type.addMethod(this.additionalBuilders((AdditionalBuilderMethod)builders)));
        }
        PoetUtils.addJavadoc(x$0 -> type.addJavadoc(x$0, new Object[0]), this.getJavadoc());
    }

    protected void addWaiterMethod(TypeSpec.Builder type) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"waiter").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.poetExtensions.getAsyncWaiterInterface()).addJavadoc(WaiterDocs.waiterMethodInClient(this.poetExtensions.getAsyncWaiterInterface()));
        type.addMethod(this.waiterOperationBody(builder).build());
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    private String getJavadoc() {
        return "Service client for accessing " + this.model.getMetadata().getDescriptiveServiceName() + " asynchronously. This can be created using the static {@link #builder()} method.\n\n" + this.model.getMetadata().getDocumentation();
    }

    private MethodSpec create() {
        return MethodSpec.methodBuilder((String)"create").returns((TypeName)this.className).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addJavadoc("Create a {@link $T} with the region loaded from the {@link $T} and credentials loaded from the {@link $T}.", new Object[]{this.className, DefaultAwsRegionProviderChain.class, DefaultCredentialsProvider.class}).addStatement("return builder().build()", new Object[0]).build();
    }

    private MethodSpec builder() {
        ClassName builderClass = ClassName.get((String)this.clientPackageName, (String)this.model.getMetadata().getAsyncBuilder(), (String[])new String[0]);
        ClassName builderInterface = ClassName.get((String)this.clientPackageName, (String)this.model.getMetadata().getAsyncBuilderInterface(), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"builder").returns((TypeName)builderInterface).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addJavadoc("Create a builder that can be used to configure and create a {@link $T}.", new Object[]{this.className}).addStatement("return new $T()", new Object[]{builderClass}).build();
    }

    protected Iterable<MethodSpec> operations() {
        return this.model.getOperations().values().stream().flatMap(this::operationsAndSimpleMethods).sorted(Comparator.comparing(m -> m.name)).collect(Collectors.toList());
    }

    private Stream<MethodSpec> operationsAndSimpleMethods(OperationModel operationModel) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        methods.addAll(this.traditionalMethods(operationModel));
        methods.addAll(this.overloadMethods(operationModel));
        methods.addAll(this.paginatedMethods(operationModel));
        return methods.stream().map(m -> DeprecationUtils.checkDeprecated(operationModel, m));
    }

    private List<MethodSpec> paginatedMethods(OperationModel opModel) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        if (opModel.isPaginated()) {
            if (opModel.getInputShape().isSimpleMethod()) {
                methods.add(this.paginatedSimpleMethod(opModel));
            }
            MethodSpec paginatedMethod = this.paginatedTraditionalMethod(opModel);
            methods.add(paginatedMethod);
            String consumerBuilderJavadoc = this.consumerBuilderJavadoc(opModel, SimpleMethodOverload.PAGINATED);
            methods.add(ClientClassUtils.consumerBuilderVariant(paginatedMethod, consumerBuilderJavadoc));
        }
        return methods;
    }

    protected MethodSpec paginatedTraditionalMethod(OperationModel opModel) {
        String methodName = PaginatorUtils.getPaginatedMethodName(opModel.getMethodName());
        ClassName requestType = ClassName.get((String)this.modelPackage, (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        ClassName responsePojoType = this.poetExtensions.getResponseClassForPaginatedAsyncOperation(opModel.getOperationName());
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).returns((TypeName)responsePojoType).addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]).addJavadoc(opModel.getDocs(this.model, ClientType.ASYNC, SimpleMethodOverload.PAGINATED), new Object[0]);
        return this.paginatedMethodBody(builder, opModel).build();
    }

    protected MethodSpec.Builder paginatedMethodBody(MethodSpec.Builder builder, OperationModel operationModel) {
        return builder.addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class});
    }

    private MethodSpec paginatedSimpleMethod(OperationModel opModel) {
        String methodName = PaginatorUtils.getPaginatedMethodName(opModel.getMethodName());
        ClassName requestType = ClassName.get((String)this.modelPackage, (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        ClassName responsePojoType = this.poetExtensions.getResponseClassForPaginatedAsyncOperation(opModel.getOperationName());
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).returns((TypeName)responsePojoType).addStatement("return $L($T.builder().build())", new Object[]{methodName, requestType}).addJavadoc(opModel.getDocs(this.model, ClientType.ASYNC, SimpleMethodOverload.NO_ARG_PAGINATED), new Object[0]);
        return builder.build();
    }

    private List<MethodSpec> overloadMethods(OperationModel opModel) {
        String consumerBuilderFileJavadoc = this.consumerBuilderJavadoc(opModel, SimpleMethodOverload.FILE);
        ArrayList<MethodSpec> methodOverloads = new ArrayList<MethodSpec>();
        if (opModel.getInputShape().isSimpleMethod()) {
            methodOverloads.add(this.noArgSimpleMethod(opModel));
        }
        if (opModel.hasStreamingInput() && opModel.hasStreamingOutput()) {
            MethodSpec streamingMethod = this.streamingInputOutputFileSimpleMethod(opModel);
            methodOverloads.add(streamingMethod);
            methodOverloads.add(ClientClassUtils.consumerBuilderVariant(streamingMethod, consumerBuilderFileJavadoc));
        } else if (opModel.hasStreamingInput()) {
            MethodSpec streamingInputMethod = this.streamingInputFileSimpleMethod(opModel);
            methodOverloads.add(streamingInputMethod);
            methodOverloads.add(ClientClassUtils.consumerBuilderVariant(streamingInputMethod, consumerBuilderFileJavadoc));
        } else if (opModel.hasStreamingOutput()) {
            MethodSpec streamingOutputMethod = this.streamingOutputFileSimpleMethod(opModel);
            methodOverloads.add(streamingOutputMethod);
            methodOverloads.add(ClientClassUtils.consumerBuilderVariant(streamingOutputMethod, consumerBuilderFileJavadoc));
        }
        return methodOverloads;
    }

    protected MethodSpec.Builder operationBody(MethodSpec.Builder builder, OperationModel operationModel) {
        return builder.addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class});
    }

    private List<MethodSpec> traditionalMethods(OperationModel opModel) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        methods.add(this.traditionalMethod(opModel));
        String consumerBuilderJavadoc = this.consumerBuilderJavadoc(opModel, SimpleMethodOverload.NORMAL);
        methods.add(ClientClassUtils.consumerBuilderVariant((MethodSpec)methods.get(0), consumerBuilderJavadoc));
        return methods;
    }

    protected MethodSpec traditionalMethod(OperationModel opModel) {
        ClassName responsePojoType = this.getPojoResponseType(opModel);
        ClassName requestType = ClassName.get((String)this.modelPackage, (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        MethodSpec.Builder builder = this.methodSignatureWithReturnType(opModel).addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]).addJavadoc(opModel.getDocs(this.model, ClientType.ASYNC), new Object[0]);
        if (opModel.hasStreamingInput()) {
            builder.addParameter((TypeName)ClassName.get(AsyncRequestBody.class), "requestBody", new Modifier[0]);
        } else if (opModel.hasEventStreamInput()) {
            String eventStreamShapeName = EventStreamUtils.getEventStreamInRequest(opModel.getInputShape()).getShapeName();
            ClassName shapeClass = ClassName.get((String)this.modelPackage, (String)eventStreamShapeName, (String[])new String[0]);
            ParameterizedTypeName requestPublisher = ParameterizedTypeName.get((ClassName)ClassName.get(Publisher.class), (TypeName[])new TypeName[]{shapeClass});
            builder.addParameter((TypeName)requestPublisher, "requestStream", new Modifier[0]);
        }
        if (opModel.hasStreamingOutput()) {
            builder.addTypeVariable(STREAMING_TYPE_VARIABLE);
            ParameterizedTypeName asyncResponseHandlerType = ParameterizedTypeName.get((ClassName)ClassName.get(AsyncResponseTransformer.class), (TypeName[])new TypeName[]{responsePojoType, STREAMING_TYPE_VARIABLE});
            builder.addParameter((TypeName)asyncResponseHandlerType, "asyncResponseTransformer", new Modifier[0]);
        } else if (opModel.hasEventStreamOutput()) {
            builder.addParameter((TypeName)this.poetExtensions.eventStreamResponseHandlerType(opModel), "asyncResponseHandler", new Modifier[0]);
        }
        return this.operationBody(builder, opModel).build();
    }

    private MethodSpec noArgSimpleMethod(OperationModel opModel) {
        return this.interfaceMethodSignature(opModel).addJavadoc(opModel.getDocs(this.model, ClientType.ASYNC, SimpleMethodOverload.NO_ARG), new Object[0]).addStatement("return $N($N.builder().build())", new Object[]{opModel.getMethodName(), opModel.getInput().getVariableType()}).build();
    }

    private MethodSpec streamingInputFileSimpleMethod(OperationModel opModel) {
        ClassName requestType = ClassName.get((String)this.modelPackage, (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        return this.interfaceMethodSignature(opModel).addJavadoc(opModel.getDocs(this.model, ClientType.ASYNC, SimpleMethodOverload.FILE), new Object[0]).addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]).addParameter((TypeName)ClassName.get(Path.class), "sourcePath", new Modifier[0]).addStatement("return $L($L, $T.fromFile(sourcePath))", new Object[]{opModel.getMethodName(), opModel.getInput().getVariableName(), ClassName.get(AsyncRequestBody.class)}).build();
    }

    private MethodSpec streamingOutputFileSimpleMethod(OperationModel opModel) {
        ClassName requestType = ClassName.get((String)this.modelPackage, (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        return this.interfaceMethodSignature(opModel).returns((TypeName)this.completableFutureType((TypeName)this.getPojoResponseType(opModel))).addJavadoc(opModel.getDocs(this.model, ClientType.ASYNC, SimpleMethodOverload.FILE), new Object[0]).addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]).addParameter((TypeName)ClassName.get(Path.class), "destinationPath", new Modifier[0]).addStatement("return $L($L, $T.toFile(destinationPath))", new Object[]{opModel.getMethodName(), opModel.getInput().getVariableName(), ClassName.get(AsyncResponseTransformer.class)}).build();
    }

    private MethodSpec streamingInputOutputFileSimpleMethod(OperationModel opModel) {
        ClassName requestType = ClassName.get((String)this.modelPackage, (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        return this.interfaceMethodSignature(opModel).returns((TypeName)this.completableFutureType((TypeName)this.getPojoResponseType(opModel))).addJavadoc(opModel.getDocs(this.model, ClientType.ASYNC, SimpleMethodOverload.FILE), new Object[0]).addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]).addParameter((TypeName)ClassName.get(Path.class), "sourcePath", new Modifier[0]).addParameter((TypeName)ClassName.get(Path.class), "destinationPath", new Modifier[0]).addStatement("return $L($L, $T.fromFile(sourcePath), $T.toFile(destinationPath))", new Object[]{opModel.getMethodName(), opModel.getInput().getVariableName(), ClassName.get(AsyncRequestBody.class), ClassName.get(AsyncResponseTransformer.class)}).build();
    }

    private MethodSpec.Builder methodSignatureWithReturnType(OperationModel opModel) {
        ClassName responsePojoType = this.getPojoResponseType(opModel);
        return MethodSpec.methodBuilder((String)opModel.getMethodName()).returns(this.getAsyncReturnType(opModel, responsePojoType));
    }

    private MethodSpec.Builder interfaceMethodSignature(OperationModel opModel) {
        return this.methodSignatureWithReturnType(opModel).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT});
    }

    private ClassName getPojoResponseType(OperationModel opModel) {
        return ClassName.get((String)this.modelPackage, (String)opModel.getReturnType().getReturnType(), (String[])new String[0]);
    }

    private TypeName getAsyncReturnType(OperationModel opModel, ClassName responsePojoType) {
        if (opModel.hasStreamingOutput()) {
            return this.completableFutureType((TypeName)STREAMING_TYPE_VARIABLE);
        }
        if (opModel.hasEventStreamOutput()) {
            return this.completableFutureType((TypeName)ClassName.get(Void.class));
        }
        return this.completableFutureType((TypeName)responsePojoType);
    }

    private ParameterizedTypeName completableFutureType(TypeName typeName) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{typeName});
    }

    private String consumerBuilderJavadoc(OperationModel opModel, SimpleMethodOverload overload) {
        return opModel.getDocs(this.model, ClientType.ASYNC, overload, new DocConfiguration().isConsumerBuilder(true));
    }

    protected MethodSpec utilitiesMethod() {
        UtilitiesMethod config = this.model.getCustomizationConfig().getUtilitiesMethod();
        ClassName returnType = PoetUtils.classNameFromFqcn(config.getReturnType());
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"utilities").returns((TypeName)returnType).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Creates an instance of {@link $T} object with the configuration set on this client.", new Object[]{returnType});
        return this.utilitiesOperationBody(builder).build();
    }

    private MethodSpec additionalBuilders(AdditionalBuilderMethod additionalMethod) {
        String methodName = (String)Validate.paramNotNull((Object)additionalMethod.getMethodName(), (String)"methodName");
        ClassName returnType = PoetUtils.classNameFromFqcn((String)Validate.paramNotNull((Object)additionalMethod.getReturnType(), (String)"returnType"));
        ClassName instanceType = PoetUtils.classNameFromFqcn((String)Validate.paramNotNull((Object)additionalMethod.getInstanceType(), (String)"instanceType"));
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).returns((TypeName)returnType).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addJavadoc(additionalMethod.getJavaDoc(), new Object[0]).addStatement("return $T.$L", new Object[]{instanceType, additionalMethod.getStatement()});
        return builder.build();
    }

    protected MethodSpec.Builder utilitiesOperationBody(MethodSpec.Builder builder) {
        return builder.addModifiers(new Modifier[]{Modifier.DEFAULT}).addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class});
    }

    protected MethodSpec.Builder waiterOperationBody(MethodSpec.Builder builder) {
        return builder.addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class});
    }
}

