/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.model.ShapeModelSpec;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;

public class EventModelBuilderSpecs {
    private final ClassName eventClassName;
    private final ShapeModelSpec shapeModelSpec;

    public EventModelBuilderSpecs(IntermediateModel intermediateModel, MemberModel eventModel, ClassName eventClassName, TypeProvider typeProvider) {
        this.eventClassName = eventClassName;
        this.shapeModelSpec = new ShapeModelSpec(eventModel.getShape(), typeProvider, new PoetExtension(intermediateModel), intermediateModel);
    }

    public ClassName builderInterfaceName() {
        return this.classToBuild().nestedClass("Builder");
    }

    public ClassName builderImplName() {
        return this.classToBuild().nestedClass("BuilderImpl");
    }

    public TypeSpec builderInterface() {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((ClassName)this.builderInterfaceName()).addSuperinterfaces(this.superInterfaces()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.addMethod(MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(Override.class).returns((TypeName)this.eventClassName).build());
        return builder.build();
    }

    public TypeSpec beanStyleBuilder() {
        return TypeSpec.classBuilder((ClassName)this.builderImplName()).addSuperinterfaces(Collections.singletonList(this.builderInterfaceName())).superclass(this.superClass()).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addMethod(this.noArgCConstructor()).addMethod(this.fromEventConstructor()).addMethod(this.buildMethod()).build();
    }

    private ClassName classToBuild() {
        return this.eventClassName;
    }

    private ClassName baseEventClassName() {
        return this.shapeModelSpec.className();
    }

    private List<TypeName> superInterfaces() {
        return Collections.singletonList(this.baseEventClassName().nestedClass("Builder"));
    }

    private TypeName superClass() {
        return this.baseEventClassName().nestedClass("BuilderImpl");
    }

    private MethodSpec buildMethod() {
        return MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return new $T(this)", new Object[]{this.classToBuild()}).returns((TypeName)this.classToBuild()).build();
    }

    private MethodSpec noArgCConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    }

    private MethodSpec fromEventConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.classToBuild(), "event", new Modifier[0]).addStatement("super(event)", new Object[0]).build();
    }
}

