/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client.specs;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.client.specs.ProtocolSpec;
import software.amazon.awssdk.codegen.poet.client.traits.HttpChecksumRequiredTrait;
import software.amazon.awssdk.codegen.poet.client.traits.HttpChecksumTrait;
import software.amazon.awssdk.codegen.poet.client.traits.NoneAuthTypeRequestTrait;
import software.amazon.awssdk.codegen.poet.client.traits.RequestCompressionTrait;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.utils.CompletableFutureUtils;

public class QueryProtocolSpec
implements ProtocolSpec {
    protected final PoetExtension poetExtensions;
    protected final IntermediateModel intermediateModel;

    public QueryProtocolSpec(IntermediateModel intermediateModel, PoetExtension poetExtensions) {
        this.intermediateModel = intermediateModel;
        this.poetExtensions = poetExtensions;
    }

    @Override
    public FieldSpec protocolFactory(IntermediateModel model) {
        return FieldSpec.builder(this.protocolFactoryClass(), (String)"protocolFactory", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    protected Class<?> protocolFactoryClass() {
        return AwsQueryProtocolFactory.class;
    }

    @Override
    public MethodSpec initProtocolFactory(IntermediateModel model) {
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)"init").returns(this.protocolFactoryClass()).addModifiers(new Modifier[]{Modifier.PRIVATE});
        methodSpec.addCode("return $T.builder()\n", new Object[]{this.protocolFactoryClass()});
        this.registerModeledExceptions(model, this.poetExtensions).forEach(arg_0 -> ((MethodSpec.Builder)methodSpec).addCode(arg_0));
        methodSpec.addCode(".clientConfiguration(clientConfiguration)\n.defaultServiceExceptionSupplier($T::builder)\n", new Object[]{this.poetExtensions.getModelClass(model.getSdkModeledExceptionBaseClassName())});
        methodSpec.addCode(".build();", new Object[0]);
        return methodSpec.build();
    }

    @Override
    public CodeBlock responseHandler(IntermediateModel model, OperationModel opModel) {
        ClassName responseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        return CodeBlock.builder().addStatement("\n\n$T<$T> responseHandler = protocolFactory.createResponseHandler($T::builder)", new Object[]{HttpResponseHandler.class, responseType, responseType}).build();
    }

    @Override
    public Optional<CodeBlock> errorResponseHandler(OperationModel opModel) {
        return Optional.of(CodeBlock.builder().add("\n\n$T errorResponseHandler = protocolFactory.createErrorResponseHandler();", new Object[]{ParameterizedTypeName.get(HttpResponseHandler.class, (Type[])new Type[]{AwsServiceException.class})}).build());
    }

    @Override
    public CodeBlock executionHandler(OperationModel opModel) {
        ClassName responseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        ClassName requestType = this.poetExtensions.getModelClass(opModel.getInput().getVariableType());
        ClassName marshaller = this.poetExtensions.getTransformClass(opModel.getInputShape().getShapeName() + "Marshaller");
        CodeBlock.Builder codeBlock = CodeBlock.builder().add("\n\nreturn clientHandler.execute(new $T<$T, $T>()", new Object[]{ClientExecutionParams.class, requestType, responseType}).add(".withOperationName($S)\n", new Object[]{opModel.getOperationName()}).add(".withResponseHandler(responseHandler)\n", new Object[0]).add(".withErrorResponseHandler(errorResponseHandler)\n", new Object[0]).add(this.hostPrefixExpression(opModel), new Object[0]).add(this.discoveredEndpoint(opModel), new Object[0]).add(this.credentialType(opModel, this.intermediateModel)).add(".withInput($L)", new Object[]{opModel.getInput().getVariableName()}).add(".withMetricCollector(apiCallMetricCollector)", new Object[0]).add(HttpChecksumRequiredTrait.putHttpChecksumAttribute(opModel)).add(HttpChecksumTrait.create(opModel)).add(NoneAuthTypeRequestTrait.create(opModel)).add(RequestCompressionTrait.create(opModel, this.intermediateModel));
        if (opModel.hasStreamingInput()) {
            return codeBlock.add(".withRequestBody(requestBody)", new Object[0]).add(".withMarshaller($L));", new Object[]{this.syncStreamingMarshaller(this.intermediateModel, opModel, marshaller)}).build();
        }
        return codeBlock.add(".withMarshaller(new $T(protocolFactory)) $L);", new Object[]{marshaller, opModel.hasStreamingOutput() ? ", responseTransformer" : ""}).build();
    }

    @Override
    public CodeBlock asyncExecutionHandler(IntermediateModel intermediateModel, OperationModel opModel) {
        ClassName pojoResponseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        ClassName requestType = this.poetExtensions.getModelClass(opModel.getInput().getVariableType());
        ClassName marshaller = this.poetExtensions.getRequestTransformClass(opModel.getInputShape().getShapeName() + "Marshaller");
        String asyncRequestBody = opModel.hasStreamingInput() ? ".withAsyncRequestBody(requestBody)" : "";
        TypeName executeFutureValueType = this.executeFutureValueType(opModel, this.poetExtensions);
        CodeBlock.Builder builder = CodeBlock.builder().add("\n\n$T<$T> executeFuture = clientHandler.execute(new $T<$T, $T>()\n", new Object[]{CompletableFuture.class, executeFutureValueType, ClientExecutionParams.class, requestType, pojoResponseType}).add(".withOperationName(\"$N\")\n", new Object[]{opModel.getOperationName()}).add(".withMarshaller($L)\n", new Object[]{this.asyncMarshaller(intermediateModel, opModel, marshaller, "protocolFactory")}).add(".withResponseHandler(responseHandler)\n", new Object[0]).add(".withErrorResponseHandler(errorResponseHandler)\n", new Object[0]).add(this.credentialType(opModel, intermediateModel)).add(".withMetricCollector(apiCallMetricCollector)\n", new Object[0]).add(HttpChecksumRequiredTrait.putHttpChecksumAttribute(opModel)).add(HttpChecksumTrait.create(opModel)).add(NoneAuthTypeRequestTrait.create(opModel)).add(RequestCompressionTrait.create(opModel, intermediateModel));
        builder.add(this.hostPrefixExpression(opModel) + asyncRequestBody + ".withInput($L)$L);", new Object[]{opModel.getInput().getVariableName(), opModel.hasStreamingOutput() ? ", asyncResponseTransformer" : ""});
        String whenCompleteFutureName = "whenCompleteFuture";
        builder.addStatement("$T $N = null", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{executeFutureValueType}), whenCompleteFutureName});
        if (opModel.hasStreamingOutput()) {
            builder.addStatement("$T<$T, ReturnT> finalAsyncResponseTransformer = asyncResponseTransformer", new Object[]{AsyncResponseTransformer.class, pojoResponseType});
            builder.addStatement("$N = executeFuture$L", new Object[]{whenCompleteFutureName, this.streamingOutputWhenComplete("finalAsyncResponseTransformer")});
        } else {
            builder.addStatement("$N = executeFuture$L", new Object[]{whenCompleteFutureName, this.publishMetricsWhenComplete()});
        }
        builder.addStatement("return $T.forwardExceptionTo($N, executeFuture)", new Object[]{CompletableFutureUtils.class, whenCompleteFutureName});
        return builder.build();
    }

    @Override
    public Optional<MethodSpec> createErrorResponseHandler() {
        return Optional.empty();
    }
}

