/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.net.URI;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.AwsServiceClientConfiguration;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;

public class ServiceClientConfigurationClass
implements ClassSpec {
    private final ClassName defaultClientMetadataClassName;

    public ServiceClientConfigurationClass(IntermediateModel model) {
        String basePackage = model.getMetadata().getFullClientPackageName();
        String serviceId = model.getMetadata().getServiceName();
        this.defaultClientMetadataClassName = ClassName.get((String)basePackage, (String)(serviceId + "ServiceClientConfiguration"), (String[])new String[0]);
    }

    @Override
    public TypeSpec poetSpec() {
        return PoetUtils.createClassBuilder(this.defaultClientMetadataClassName).superclass(AwsServiceClientConfiguration.class).addJavadoc("Class to expose the service client settings to the user. Implementation of {@link $T}", new Object[]{AwsServiceClientConfiguration.class}).addMethod(this.constructor()).addMethod(this.builderMethod()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(SdkPublicApi.class).addType(this.builderInterfaceSpec()).addType(this.builderImplSpec()).build();
    }

    @Override
    public ClassName className() {
        return this.defaultClientMetadataClassName;
    }

    public MethodSpec constructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.className().nestedClass("Builder"), "builder", new Modifier[0]).addStatement("super(builder)", new Object[0]).build();
    }

    public MethodSpec builderMethod() {
        return MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addStatement("return new BuilderImpl()", new Object[0]).returns((TypeName)this.className().nestedClass("Builder")).addJavadoc("", new Object[0]).build();
    }

    private TypeSpec builderInterfaceSpec() {
        return TypeSpec.interfaceBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ClassName.get(AwsServiceClientConfiguration.class).nestedClass("Builder")).addJavadoc("A builder for creating a {@link $T}", new Object[]{this.className()}).addMethod(MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)this.className()).build()).addMethod(MethodSpec.methodBuilder((String)"region").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(Region.class, "region", new Modifier[0]).returns((TypeName)this.className().nestedClass("Builder")).addJavadoc("Configure the region", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"endpointOverride").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(URI.class, "endpointOverride", new Modifier[0]).returns((TypeName)this.className().nestedClass("Builder")).addJavadoc("Configure the endpointOverride", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"overrideConfiguration").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ClientOverrideConfiguration.class, "clientOverrideConfiguration", new Modifier[0]).returns((TypeName)this.className().nestedClass("Builder")).addJavadoc("Configure the client override configuration", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"endpointProvider").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(EndpointProvider.class, "endpointProvider", new Modifier[0]).returns((TypeName)this.className().nestedClass("Builder")).addJavadoc("Configure the endpointProvider", new Object[0]).build()).build();
    }

    private TypeSpec builderImplSpec() {
        return TypeSpec.classBuilder((String)"BuilderImpl").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addSuperinterface((TypeName)this.className().nestedClass("Builder")).superclass((TypeName)ClassName.get(AwsServiceClientConfiguration.class).nestedClass("BuilderImpl")).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.className(), "serviceClientConfiguration", new Modifier[0]).addStatement("super(serviceClientConfiguration)", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"region").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Region.class, "region", new Modifier[0]).returns((TypeName)this.className().nestedClass("Builder")).addStatement("this.region = region", new Object[0]).addStatement("return this", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"overrideConfiguration").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ClientOverrideConfiguration.class, "clientOverrideConfiguration", new Modifier[0]).returns((TypeName)this.className().nestedClass("Builder")).addStatement("this.overrideConfiguration = clientOverrideConfiguration", new Object[0]).addStatement("return this", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"endpointOverride").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(URI.class, "endpointOverride", new Modifier[0]).returns((TypeName)this.className().nestedClass("Builder")).addStatement("this.endpointOverride = endpointOverride", new Object[0]).addStatement("return this", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"endpointProvider").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(EndpointProvider.class, "endpointProvider", new Modifier[0]).returns((TypeName)this.className().nestedClass("Builder")).addStatement("this.endpointProvider = endpointProvider", new Object[0]).addStatement("return this", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.className()).addStatement("return new $T(this)", new Object[]{this.className()}).build()).build();
    }
}

