/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.stree.JrsArray;
import com.fasterxml.jackson.jr.stree.JrsBoolean;
import com.fasterxml.jackson.jr.stree.JrsString;
import com.squareup.javapoet.CodeBlock;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.ExpectModel;
import software.amazon.awssdk.codegen.model.service.EndpointTrait;
import software.amazon.awssdk.codegen.model.service.HostPrefixProcessor;
import software.amazon.awssdk.core.rules.testing.model.Expect;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.utils.StringUtils;

public final class TestGeneratorUtils {
    private TestGeneratorUtils() {
    }

    public static CodeBlock createExpect(ExpectModel expect, OperationModel opModel, Map<String, TreeNode> opParams) {
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("$T.builder()", new Object[]{Expect.class});
        if (expect.getError() != null) {
            b.add(".error($S)", new Object[]{expect.getError()});
        } else {
            CodeBlock.Builder endpointBuilder = CodeBlock.builder();
            ExpectModel.Endpoint endpoint = expect.getEndpoint();
            String expectedUrl = TestGeneratorUtils.createExpectedUrl(endpoint, opModel, opParams);
            endpointBuilder.add("$T.builder()", new Object[]{Endpoint.class});
            endpointBuilder.add(".url($T.create($S))", new Object[]{URI.class, expectedUrl});
            if (endpoint.getHeaders() != null) {
                Map<String, List<String>> expectHeaders = endpoint.getHeaders();
                expectHeaders.forEach((name, values) -> values.forEach(v -> endpointBuilder.add(".putHeader($S, $S)", new Object[]{name, v})));
            }
            if (endpoint.getProperties() != null) {
                endpoint.getProperties().forEach((name, value) -> TestGeneratorUtils.addEndpointAttributeBlock(endpointBuilder, name, value));
            }
            endpointBuilder.add(".build()", new Object[0]);
            b.add(".endpoint($L)", new Object[]{endpointBuilder.build()});
        }
        b.add(".build()", new Object[0]);
        return b.build();
    }

    public static Optional<String> getHostPrefixTemplate(OperationModel opModel) {
        EndpointTrait endpointTrait = opModel.getEndpointTrait();
        if (endpointTrait == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(endpointTrait.getHostPrefix());
    }

    private static void addEndpointAttributeBlock(CodeBlock.Builder builder, String attrName, TreeNode attrValue) {
        switch (attrName) {
            case "authSchemes": {
                TestGeneratorUtils.addAuthSchemesBlock(builder, attrValue);
                break;
            }
            default: {
                throw new RuntimeException("Encountered unknown expected endpoint attribute: " + attrName);
            }
        }
    }

    private static void addAuthSchemesBlock(CodeBlock.Builder builder, TreeNode attrValue) {
        CodeBlock keyExpr = CodeBlock.builder().add("$T.AUTH_SCHEMES", new Object[]{AwsEndpointAttribute.class}).build();
        CodeBlock.Builder schemesListExpr = CodeBlock.builder().add("$T.asList(", new Object[]{Arrays.class});
        JrsArray schemesArray = (JrsArray)attrValue;
        Iterator elementsIter = schemesArray.elements();
        while (elementsIter.hasNext()) {
            schemesListExpr.add("$L", new Object[]{TestGeneratorUtils.authSchemeCreationExpr((TreeNode)elementsIter.next())});
            if (!elementsIter.hasNext()) continue;
            schemesListExpr.add(",", new Object[0]);
        }
        schemesListExpr.add(")", new Object[0]);
        builder.add(".putAttribute($L, $L)", new Object[]{keyExpr, schemesListExpr.build()});
    }

    private static CodeBlock authSchemeCreationExpr(TreeNode attrValue) {
        String name;
        CodeBlock.Builder schemeExpr = CodeBlock.builder();
        switch (name = ((JrsString)attrValue.get("name")).getValue()) {
            case "sigv4": {
                schemeExpr.add("$T.builder()", new Object[]{SigV4AuthScheme.class});
                break;
            }
            case "sigv4a": {
                schemeExpr.add("$T.builder()", new Object[]{SigV4aAuthScheme.class});
                break;
            }
            default: {
                throw new RuntimeException("Unknown expected auth scheme: " + name);
            }
        }
        Iterator membersIter = attrValue.fieldNames();
        block22: while (membersIter.hasNext()) {
            String memberName = (String)membersIter.next();
            TreeNode memberValue = attrValue.get(memberName);
            switch (memberName) {
                case "name": {
                    continue block22;
                }
                case "signingName": {
                    schemeExpr.add(".signingName($S)", new Object[]{((JrsString)memberValue).getValue()});
                    continue block22;
                }
                case "signingRegion": {
                    schemeExpr.add(".signingRegion($S)", new Object[]{((JrsString)memberValue).getValue()});
                    continue block22;
                }
                case "disableDoubleEncoding": {
                    schemeExpr.add(".disableDoubleEncoding($L)", new Object[]{((JrsBoolean)memberValue).booleanValue()});
                    continue block22;
                }
                case "signingRegionSet": {
                    JrsArray regions = (JrsArray)memberValue;
                    regions.elements().forEachRemaining(r -> schemeExpr.add(".addSigningRegion($S)", new Object[]{((JrsString)r).getValue()}));
                    continue block22;
                }
            }
            throw new RuntimeException("Unknown auth scheme property: " + memberName);
        }
        schemeExpr.add(".build()", new Object[0]);
        return schemeExpr.build();
    }

    private static String createExpectedUrl(ExpectModel.Endpoint endpoint, OperationModel opModel, Map<String, TreeNode> opParams) {
        Optional<String> prefix = TestGeneratorUtils.getHostPrefix(opModel, opParams);
        if (!prefix.isPresent()) {
            return endpoint.getUrl();
        }
        URI originalUrl = URI.create(endpoint.getUrl());
        try {
            URI newUrl = new URI(originalUrl.getScheme(), null, prefix.get() + originalUrl.getHost(), originalUrl.getPort(), originalUrl.getPath(), originalUrl.getQuery(), originalUrl.getFragment());
            return newUrl.toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Expected url creation failed", e);
        }
    }

    private static Optional<String> getHostPrefix(OperationModel opModel, Map<String, TreeNode> opParams) {
        if (opModel == null) {
            return Optional.empty();
        }
        Optional<String> hostPrefixTemplate = TestGeneratorUtils.getHostPrefixTemplate(opModel);
        if (!hostPrefixTemplate.isPresent() || StringUtils.isBlank((CharSequence)hostPrefixTemplate.get())) {
            return Optional.empty();
        }
        HostPrefixProcessor processor = new HostPrefixProcessor(hostPrefixTemplate.get());
        String pattern = processor.hostWithStringSpecifier();
        for (String c2jName : processor.c2jNames()) {
            if (opParams != null && opParams.containsKey(c2jName)) {
                String value = ((JrsString)opParams.get(c2jName)).getValue();
                pattern = StringUtils.replaceOnce((String)pattern, (String)"%s", (String)value);
                continue;
            }
            pattern = StringUtils.replaceOnce((String)pattern, (String)"%s", (String)"aws");
        }
        return Optional.of(pattern);
    }
}

