/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.eventstream;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeSpec;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.naming.NamingStrategy;
import software.amazon.awssdk.codegen.poet.common.AbstractEnumClass;

public class EventTypeEnumSpec
extends AbstractEnumClass {
    private final String enumPackageName;
    private final IntermediateModel intermediateModel;

    public EventTypeEnumSpec(String enumPackageName, IntermediateModel intermediateModel, ShapeModel eventStream) {
        super(eventStream);
        this.enumPackageName = enumPackageName;
        this.intermediateModel = intermediateModel;
    }

    @Override
    protected void addDeprecated(TypeSpec.Builder enumBuilder) {
    }

    @Override
    protected void addJavadoc(TypeSpec.Builder enumBuilder) {
        enumBuilder.addJavadoc("The known possible types of events for {@code $N}.", new Object[]{this.getShape().getShapeName()});
    }

    @Override
    protected void addEnumConstants(TypeSpec.Builder enumBuilder) {
        NamingStrategy namingStrategy = this.intermediateModel.getNamingStrategy();
        this.getShape().getMembers().stream().filter(m -> m.getShape().isEvent()).forEach(m -> {
            String value = m.getC2jName();
            String name = namingStrategy.getEnumValueName(value);
            enumBuilder.addEnumConstant(name, TypeSpec.anonymousClassBuilder((String)"$S", (Object[])new Object[]{value}).build());
        });
    }

    @Override
    public ClassName className() {
        return ClassName.get((String)this.enumPackageName, (String)"EventType", (String[])new String[0]);
    }
}

