/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.model.AbstractMemberSetters;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.utils.Validate;

class ListSetters
extends AbstractMemberSetters {
    private final TypeProvider typeProvider;
    private final PoetExtensions poetExtensions;

    ListSetters(IntermediateModel intermediateModel, ShapeModel shapeModel, MemberModel memberModel, TypeProvider typeProvider) {
        super(intermediateModel, shapeModel, memberModel, typeProvider);
        this.typeProvider = typeProvider;
        this.poetExtensions = new PoetExtensions(intermediateModel);
    }

    @Override
    public List<MethodSpec> fluentDeclarations(TypeName returnType) {
        ArrayList<MethodSpec> fluentDeclarations = new ArrayList<MethodSpec>();
        String setterDocumentation = this.memberModel().getFluentSetterDocumentation();
        fluentDeclarations.add(this.fluentAbstractSetterDeclaration(this.memberAsParameter(), returnType).addJavadoc("$L", new Object[]{setterDocumentation}).build());
        fluentDeclarations.add(this.fluentAbstractSetterDeclaration(ParameterSpec.builder((TypeName)this.asArray(), (String)this.fieldName(), (Modifier[])new Modifier[0]).build(), returnType).addJavadoc("$L", new Object[]{setterDocumentation}).varargs(true).build());
        if (this.elementModel().hasBuilder()) {
            fluentDeclarations.add(this.fluentAbstractSetterDeclaration(ParameterSpec.builder((TypeName)this.asConsumerBuilderArray(), (String)this.fieldName(), (Modifier[])new Modifier[0]).build(), returnType).varargs(true).addJavadoc("$L", new Object[]{this.memberModel().getDefaultConsumerFluentSetterDocumentation()}).build());
        }
        if (this.enumTypeInListMemberModel() != null) {
            fluentDeclarations.add(this.fluentAbstractSetterDeclaration(this.memberModel().getFluentEnumSetterMethodName(), this.collectionOfModeledEnumAsParameter(), returnType).addJavadoc("$L", new Object[]{setterDocumentation}).build());
            fluentDeclarations.add(this.fluentAbstractSetterDeclaration(this.memberModel().getFluentEnumSetterMethodName(), this.arrayOfModeledEnumAsParameter(), returnType).varargs(true).addJavadoc("$L", new Object[]{setterDocumentation}).build());
        }
        return fluentDeclarations;
    }

    @Override
    public List<MethodSpec> fluent(TypeName returnType) {
        ArrayList<MethodSpec> fluent = new ArrayList<MethodSpec>();
        fluent.add(this.fluentCopySetter(returnType));
        fluent.add(this.fluentVarargToListSetter(returnType));
        if (this.elementModel().hasBuilder()) {
            fluent.add(this.fluentVarargConsumerBuilderSetter(returnType));
        }
        if (this.enumTypeInListMemberModel() != null) {
            fluent.add(this.fluentEnumCollectionsSetter(this.memberModel().getFluentEnumSetterMethodName(), this.collectionOfModeledEnumAsParameter(), returnType));
            fluent.add(this.fluentEnumVarargToListSetter(this.memberModel().getFluentEnumSetterMethodName(), this.arrayOfModeledEnumAsParameter(), returnType));
        }
        return fluent;
    }

    @Override
    public MethodSpec beanStyle() {
        MethodSpec.Builder builder = this.beanStyleSetterBuilder().addCode(this.memberModel().isCollectionWithBuilderMember() ? this.copySetterBuilderBody() : this.beanCopySetterBody());
        return builder.build();
    }

    private MethodSpec fluentCopySetter(TypeName returnType) {
        return this.fluentSetterBuilder(returnType).addCode(this.copySetterBody().toBuilder().addStatement("return this", new Object[0]).build()).build();
    }

    private MethodSpec fluentVarargToListSetter(TypeName returnType) {
        return this.fluentSetterBuilder(ParameterSpec.builder((TypeName)this.asArray(), (String)this.fieldName(), (Modifier[])new Modifier[0]).build(), returnType).varargs(true).addAnnotation(SafeVarargs.class).addCode(this.varargToListSetterBody()).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec fluentVarargConsumerBuilderSetter(TypeName returnType) {
        return this.fluentSetterBuilder(ParameterSpec.builder((TypeName)this.asConsumerBuilderArray(), (String)this.fieldName(), (Modifier[])new Modifier[0]).build(), returnType).varargs(true).addAnnotation(SafeVarargs.class).addCode(this.consumerBuilderVarargSetterBody()).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec fluentEnumCollectionsSetter(String methodName, ParameterSpec parameter, TypeName returnType) {
        return this.fluentSetterBuilder(methodName, parameter, returnType).addCode(this.fluentSetterWithEnumCollectionsParameterMethodBody()).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec fluentEnumVarargToListSetter(String methodName, ParameterSpec parameter, TypeName returnType) {
        return this.fluentSetterBuilder(methodName, parameter, returnType).varargs(true).addAnnotation(SafeVarargs.class).addCode(this.enumVarargToListSetterBody()).addStatement("return this", new Object[0]).build();
    }

    private CodeBlock varargToListSetterBody() {
        return CodeBlock.of((String)"$1L($2T.asList($3L));", (Object[])new Object[]{this.memberModel().getFluentSetterMethodName(), Arrays.class, this.fieldName()});
    }

    private CodeBlock consumerBuilderVarargSetterBody() {
        return CodeBlock.of((String)"$1L($2T.of($1L).map(c -> $3T.builder().applyMutation(c).build()).collect($4T.toList()));", (Object[])new Object[]{this.fieldName(), Stream.class, this.listElementType(), Collectors.class});
    }

    private CodeBlock enumVarargToListSetterBody() {
        return CodeBlock.of((String)"$1L($2T.asList($1L));", (Object[])new Object[]{this.fieldName(), Arrays.class});
    }

    private MemberModel elementModel() {
        return this.memberModel().getListModel().getListMemberModel();
    }

    private TypeName modeledEnumElement() {
        return this.poetExtensions.getModelClass(this.enumTypeInListMemberModel());
    }

    private String enumTypeInListMemberModel() {
        return this.memberModel().getListModel().getListMemberModel().getEnumType();
    }

    private TypeName listElementType() {
        return this.typeProvider.parameterType(this.elementModel());
    }

    private TypeName listElementConsumerBuilderType() {
        TypeName listElementType = this.listElementType();
        ClassName classType = (ClassName)Validate.isInstanceOf(ClassName.class, (Object)listElementType, (String)"List element type must be of type class, but was %s", (Object[])new Object[]{listElementType});
        return classType.nestedClass("Builder");
    }

    private TypeName asConsumerBuilderArray() {
        ParameterizedTypeName consumerBuilder = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{this.listElementConsumerBuilderType()});
        return ArrayTypeName.of((TypeName)consumerBuilder);
    }

    private ArrayTypeName asArray() {
        return ArrayTypeName.of((TypeName)this.listElementType());
    }

    private ArrayTypeName asArrayOfModeledEnum() {
        return ArrayTypeName.of((TypeName)this.modeledEnumElement());
    }

    private ParameterSpec arrayOfModeledEnumAsParameter() {
        return ParameterSpec.builder((TypeName)this.asArrayOfModeledEnum(), (String)this.fieldName(), (Modifier[])new Modifier[0]).build();
    }

    private ParameterSpec collectionOfModeledEnumAsParameter() {
        return ParameterSpec.builder((TypeName)this.typeProvider.listWithEnumParameterType(this.memberModel()), (String)this.fieldName(), (Modifier[])new Modifier[0]).build();
    }
}

