/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.codegen.poet.builder.SyncClientBuilderClass;
import software.amazon.awssdk.codegen.poet.builder.SyncClientBuilderInterface;
import software.amazon.awssdk.codegen.poet.client.ClientSimpleMethodsIntegrationTests;
import software.amazon.awssdk.codegen.poet.client.SyncClientClass;
import software.amazon.awssdk.codegen.poet.client.SyncClientInterface;
import software.amazon.awssdk.codegen.poet.endpointdiscovery.EndpointDiscoveryCacheLoaderGenerator;

public class SyncClientGeneratorTasks
extends BaseGeneratorTasks {
    private final GeneratorTaskParams generatorTaskParams;

    public SyncClientGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.generatorTaskParams = dependencies;
    }

    @Override
    protected boolean hasTasks() {
        return !this.model.getCustomizationConfig().isSkipSyncClientGeneration();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        ArrayList<GeneratorTask> tasks = new ArrayList<GeneratorTask>();
        tasks.add(this.createClientClassTask());
        tasks.add(this.createClientBuilderTask());
        tasks.add(this.createClientInterfaceTask());
        tasks.add(this.createClientBuilderInterfaceTask());
        if (!this.model.simpleMethodsRequiringTesting().isEmpty()) {
            tasks.add(this.createClientSimpleMethodsTest());
        }
        if (this.model.getEndpointOperation().isPresent()) {
            tasks.add(this.createEndpointDiscoveryCacheLoaderTask());
        }
        return tasks;
    }

    private GeneratorTask createClientClassTask() throws IOException {
        return this.createPoetGeneratorTask(new SyncClientClass(this.generatorTaskParams));
    }

    private GeneratorTask createClientBuilderTask() throws IOException {
        return this.createPoetGeneratorTask(new SyncClientBuilderClass(this.model));
    }

    private GeneratorTask createClientInterfaceTask() throws IOException {
        return this.createPoetGeneratorTask(new SyncClientInterface(this.model));
    }

    private GeneratorTask createClientBuilderInterfaceTask() throws IOException {
        return this.createPoetGeneratorTask(new SyncClientBuilderInterface(this.model));
    }

    private GeneratorTask createClientSimpleMethodsTest() throws IOException {
        return this.createPoetGeneratorTestTask(new ClientSimpleMethodsIntegrationTests(this.model));
    }

    private GeneratorTask createEndpointDiscoveryCacheLoaderTask() throws IOException {
        return this.createPoetGeneratorTask(new EndpointDiscoveryCacheLoaderGenerator(this.generatorTaskParams));
    }
}

