/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters;

import java.io.IOException;
import java.io.Writer;
import software.amazon.awssdk.codegen.emitters.CodeWriter;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;

public final class PoetGeneratorTask
extends GeneratorTask {
    private final Writer writer;
    private final ClassSpec classSpec;
    private final String fileHeader;

    public PoetGeneratorTask(String outputDirectory, String fileHeader, ClassSpec classSpec) {
        this(outputDirectory, fileHeader, classSpec, false);
    }

    public PoetGeneratorTask(String outputDirectory, String fileHeader, ClassSpec classSpec, boolean disableFormatting) {
        this.fileHeader = fileHeader;
        this.writer = new CodeWriter(outputDirectory, classSpec.className().simpleName(), disableFormatting);
        this.classSpec = classSpec;
    }

    @Override
    public void compute() {
        try {
            this.writer.write(this.fileHeader);
            this.writer.write("\n");
            PoetUtils.buildJavaFile(this.classSpec).writeTo((Appendable)this.writer);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error creating class %s", this.classSpec.className().simpleName()), e);
        }
        finally {
            Utils.closeQuietly(this.writer);
        }
    }
}

