/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.stree.JrsBoolean;
import com.fasterxml.jackson.jr.stree.JrsString;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.rules.endpoints.BuiltInParameter;
import software.amazon.awssdk.codegen.model.rules.endpoints.ParameterModel;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.internal.CodegenNamingUtils;

public class EndpointRulesSpecUtils {
    private final IntermediateModel intermediateModel;

    public EndpointRulesSpecUtils(IntermediateModel intermediateModel) {
        this.intermediateModel = intermediateModel;
    }

    public String basePackage() {
        return this.intermediateModel.getMetadata().getFullEndpointRulesPackageName();
    }

    public ClassName rulesRuntimeClassName(String name) {
        return ClassName.get((String)this.intermediateModel.getMetadata().getFullInternalEndpointRulesPackageName(), (String)name, (String[])new String[0]);
    }

    public ClassName parametersClassName() {
        return ClassName.get((String)this.basePackage(), (String)(this.intermediateModel.getMetadata().getServiceName() + "EndpointParams"), (String[])new String[0]);
    }

    public ClassName providerInterfaceName() {
        return ClassName.get((String)this.basePackage(), (String)(this.intermediateModel.getMetadata().getServiceName() + "EndpointProvider"), (String[])new String[0]);
    }

    public ClassName providerDefaultImplName() {
        Metadata md = this.intermediateModel.getMetadata();
        return ClassName.get((String)md.getFullInternalEndpointRulesPackageName(), (String)("Default" + this.providerInterfaceName().simpleName()), (String[])new String[0]);
    }

    public ClassName resolverInterceptorName() {
        Metadata md = this.intermediateModel.getMetadata();
        return ClassName.get((String)md.getFullInternalEndpointRulesPackageName(), (String)(md.getServiceName() + "ResolveEndpointInterceptor"), (String[])new String[0]);
    }

    public ClassName authSchemesInterceptorName() {
        Metadata md = this.intermediateModel.getMetadata();
        return ClassName.get((String)md.getFullInternalEndpointRulesPackageName(), (String)(md.getServiceName() + "EndpointAuthSchemeInterceptor"), (String[])new String[0]);
    }

    public ClassName requestModifierInterceptorName() {
        Metadata md = this.intermediateModel.getMetadata();
        return ClassName.get((String)md.getFullInternalEndpointRulesPackageName(), (String)(md.getServiceName() + "RequestSetEndpointInterceptor"), (String[])new String[0]);
    }

    public ClassName clientEndpointTestsName() {
        Metadata md = this.intermediateModel.getMetadata();
        return ClassName.get((String)md.getFullEndpointRulesPackageName(), (String)(md.getServiceName() + "ClientEndpointTests"), (String[])new String[0]);
    }

    public ClassName endpointProviderTestsName() {
        Metadata md = this.intermediateModel.getMetadata();
        return ClassName.get((String)md.getFullEndpointRulesPackageName(), (String)(md.getServiceName() + "EndpointProviderTests"), (String[])new String[0]);
    }

    public ClassName clientContextParamsName() {
        Metadata md = this.intermediateModel.getMetadata();
        return ClassName.get((String)md.getFullEndpointRulesPackageName(), (String)(md.getServiceName() + "ClientContextParams"), (String[])new String[0]);
    }

    public String paramMethodName(String param) {
        return Utils.unCapitalize(CodegenNamingUtils.pascalCase((String)param));
    }

    public String clientContextParamMethodName(String param) {
        return Utils.unCapitalize(CodegenNamingUtils.pascalCase((String)param));
    }

    public String clientContextParamName(String paramName) {
        return this.intermediateModel.getNamingStrategy().getEnumValueName(paramName);
    }

    public TypeName toJavaType(String type) {
        switch (type.toLowerCase(Locale.ENGLISH)) {
            case "boolean": {
                return TypeName.get(Boolean.class);
            }
            case "string": {
                return TypeName.get(String.class);
            }
        }
        throw new RuntimeException("Unknown type: " + type);
    }

    public CodeBlock valueCreationCode(String type, CodeBlock param) {
        String methodName;
        switch (type.toLowerCase(Locale.ENGLISH)) {
            case "boolean": {
                methodName = "fromBool";
                break;
            }
            case "string": {
                methodName = "fromStr";
                break;
            }
            default: {
                throw new RuntimeException("Don't know how to create a Value instance from type " + type);
            }
        }
        return CodeBlock.builder().add("$T.$N($L)", new Object[]{this.rulesRuntimeClassName("Value"), methodName, param}).build();
    }

    public TypeName parameterType(ParameterModel param) {
        if (param.getBuiltInEnum() == null || param.getBuiltInEnum() != BuiltInParameter.AWS_REGION) {
            return this.toJavaType(param.getType());
        }
        if (param.getBuiltInEnum() == BuiltInParameter.AWS_REGION) {
            return ClassName.get(Region.class);
        }
        return this.toJavaType(param.getType());
    }

    public CodeBlock treeNodeToLiteral(TreeNode treeNode) {
        CodeBlock.Builder b = CodeBlock.builder();
        switch (treeNode.asToken()) {
            case VALUE_STRING: {
                b.add("$S", new Object[]{((JrsString)Validate.isInstanceOf(JrsString.class, (Object)treeNode, (String)"Expected string", (Object[])new Object[0])).getValue()});
                break;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                b.add("$L", new Object[]{((JrsBoolean)Validate.isInstanceOf(JrsBoolean.class, (Object)treeNode, (String)"Expected boolean", (Object[])new Object[0])).booleanValue()});
                break;
            }
            default: {
                throw new RuntimeException("Don't know how to set default value for parameter of type " + treeNode.asToken());
            }
        }
        return b.build();
    }

    public boolean isS3() {
        return "S3".equals(this.intermediateModel.getMetadata().getServiceName());
    }

    public boolean isS3Control() {
        return "S3Control".equals(this.intermediateModel.getMetadata().getServiceName());
    }

    public TypeName resolverReturnType() {
        return ParameterizedTypeName.get(CompletableFuture.class, (Type[])new Type[]{Endpoint.class});
    }
}

