/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.stree.JrsArray;
import com.fasterxml.jackson.jr.stree.JrsObject;
import com.fasterxml.jackson.jr.stree.JrsValue;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ParameterHttpMapping;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.EndpointTestModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.EndpointTestSuiteModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.OperationInput;
import software.amazon.awssdk.codegen.model.rules.endpoints.ParameterModel;
import software.amazon.awssdk.codegen.model.service.ClientContextParam;
import software.amazon.awssdk.codegen.model.service.Location;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.codegen.poet.rules.TestGeneratorUtils;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.rules.testing.AsyncTestCase;
import software.amazon.awssdk.core.rules.testing.BaseRuleSetClientTest;
import software.amazon.awssdk.core.rules.testing.SyncTestCase;
import software.amazon.awssdk.core.rules.testing.util.EmptyPublisher;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.Validate;

public class EndpointRulesClientTestSpec
implements ClassSpec {
    private static final Map<String, String> GLOBAL_SKIP_ENDPOINT_TESTS;
    private final IntermediateModel model;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;
    private final PoetExtension poetExtension;

    public EndpointRulesClientTestSpec(IntermediateModel model) {
        this.model = model;
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(model);
        this.poetExtension = new PoetExtension(model);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder b = PoetUtils.createClassBuilder(this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(BaseRuleSetClientTest.class);
        if (this.endpointRulesSpecUtils.isS3()) {
            b.addField(this.s3RegionEndpointSystemPropertySaveValueField());
        }
        b.addMethod(this.methodSetupMethod());
        b.addMethod(this.teardownMethod());
        if (this.hasSyncClient()) {
            b.addMethod(this.syncTest());
        }
        b.addMethod(this.asyncTest());
        if (this.hasSyncClient()) {
            b.addMethod(this.syncTestsSourceMethod());
        }
        b.addMethod(this.asyncTestsSourceMethod());
        return b.build();
    }

    @Override
    public ClassName className() {
        return this.endpointRulesSpecUtils.clientEndpointTestsName();
    }

    private String findDefaultRequest() {
        Map<String, OperationModel> operations = this.model.getOperations();
        Optional<String> name = operations.entrySet().stream().filter(e -> EndpointRulesClientTestSpec.canBeEmpty((OperationModel)e.getValue())).findFirst().map(Map.Entry::getKey);
        if (name.isPresent()) {
            return name.get();
        }
        Optional<String> nonStreaming = operations.entrySet().stream().filter(e -> !((OperationModel)e.getValue()).hasStreamingInput() && !((OperationModel)e.getValue()).hasStreamingOutput()).map(Map.Entry::getKey).findFirst();
        return nonStreaming.orElseGet(() -> (String)operations.keySet().stream().findFirst().get());
    }

    private MethodSpec syncTest() {
        AnnotationSpec methodSourceSpec = AnnotationSpec.builder(MethodSource.class).addMember("value", "$S", new Object[]{"syncTestCases"}).build();
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"syncClient_usesCorrectEndpoint").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(SyncTestCase.class, "tc", new Modifier[0]).addAnnotation(methodSourceSpec).addAnnotation(ParameterizedTest.class).returns(Void.TYPE);
        b.addStatement("runAndVerify(tc)", new Object[0]);
        return b.build();
    }

    private MethodSpec asyncTest() {
        AnnotationSpec methodSourceSpec = AnnotationSpec.builder(MethodSource.class).addMember("value", "$S", new Object[]{"asyncTestCases"}).build();
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"asyncClient_usesCorrectEndpoint").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(AsyncTestCase.class, "tc", new Modifier[0]).addAnnotation(methodSourceSpec).addAnnotation(ParameterizedTest.class).returns(Void.TYPE);
        b.addStatement("runAndVerify(tc)", new Object[0]);
        return b.build();
    }

    private MethodSpec syncTestsSourceMethod() {
        String defaultOperation = this.findDefaultRequest();
        OperationModel defaultOpModel = this.model.getOperation(defaultOperation);
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"syncTestCases").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{SyncTestCase.class}));
        b.addCode("return $T.asList(", new Object[]{Arrays.class});
        EndpointTestSuiteModel endpointTestSuiteModel = this.model.getEndpointTestSuiteModel();
        Iterator<EndpointTestModel> testIter = endpointTestSuiteModel.getTestCases().iterator();
        while (testIter.hasNext()) {
            EndpointTestModel test = testIter.next();
            if (test.getOperationInputs() != null) {
                Iterator<OperationInput> operationInputsIter = test.getOperationInputs().iterator();
                while (operationInputsIter.hasNext()) {
                    OperationInput opInput = operationInputsIter.next();
                    OperationModel opModel = this.model.getOperation(opInput.getOperationName());
                    b.addCode("new $T($S, $L, $L$L)", new Object[]{SyncTestCase.class, test.getDocumentation(), this.syncOperationCallLambda(opModel, test.getParams(), opInput.getOperationParams()), TestGeneratorUtils.createExpect(test.getExpect()), this.getSkipReasonBlock(test.getDocumentation())});
                    if (!operationInputsIter.hasNext()) continue;
                    b.addCode(",", new Object[0]);
                }
            } else {
                b.addCode("new $T($S, $L, $L$L)", new Object[]{SyncTestCase.class, test.getDocumentation(), this.syncOperationCallLambda(defaultOpModel, test.getParams(), Collections.emptyMap()), TestGeneratorUtils.createExpect(test.getExpect()), this.getSkipReasonBlock(test.getDocumentation())});
            }
            if (!testIter.hasNext()) continue;
            b.addCode(",", new Object[0]);
        }
        b.addStatement(")", new Object[0]);
        return b.build();
    }

    private CodeBlock syncOperationCallLambda(OperationModel opModel, Map<String, TreeNode> params, Map<String, TreeNode> opParams) {
        CodeBlock.Builder b = CodeBlock.builder();
        b.beginControlFlow("() -> ", new Object[0]);
        b.addStatement("$T builder = $T.builder()", new Object[]{this.syncClientBuilder(), this.syncClientClass()});
        b.addStatement("builder.credentialsProvider($T.CREDENTIALS_PROVIDER)", new Object[]{BaseRuleSetClientTest.class});
        b.addStatement("builder.httpClient(getSyncHttpClient())", new Object[0]);
        if (params != null) {
            b.add(this.setClientParams("builder", params));
        }
        b.addStatement("$T request = $L", new Object[]{this.poetExtension.getModelClass(opModel.getInputShape().getShapeName()), this.requestCreation(opModel, opParams)});
        b.addStatement("builder.build().$L", new Object[]{this.syncOperationInvocation(opModel)});
        b.endControlFlow();
        return b.build();
    }

    private CodeBlock asyncOperationCallLambda(OperationModel opModel, Map<String, TreeNode> params, Map<String, TreeNode> opParams) {
        CodeBlock.Builder b = CodeBlock.builder();
        b.beginControlFlow("() -> ", new Object[0]);
        b.addStatement("$T builder = $T.builder()", new Object[]{this.asyncClientBuilder(), this.asyncClientClass()});
        b.addStatement("builder.credentialsProvider($T.CREDENTIALS_PROVIDER)", new Object[]{BaseRuleSetClientTest.class});
        b.addStatement("builder.httpClient(getAsyncHttpClient())", new Object[0]);
        if (params != null) {
            b.add(this.setClientParams("builder", params));
        }
        b.addStatement("$T request = $L", new Object[]{this.poetExtension.getModelClass(opModel.getInputShape().getShapeName()), this.requestCreation(opModel, opParams)});
        CodeBlock asyncInvoke = this.asyncOperationInvocation(opModel);
        b.addStatement("return builder.build().$L", new Object[]{asyncInvoke});
        b.endControlFlow();
        return b.build();
    }

    private CodeBlock syncOperationInvocation(OperationModel opModel) {
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("$N(", new Object[]{opModel.getMethodName()});
        b.add("$N", new Object[]{"request"});
        if (opModel.hasStreamingInput()) {
            b.add(", $T.fromString($S)", new Object[]{RequestBody.class, "hello"});
        }
        b.add(")", new Object[0]);
        return b.build();
    }

    private CodeBlock asyncOperationInvocation(OperationModel opModel) {
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("$N(", new Object[]{opModel.getMethodName()});
        b.add("$N", new Object[]{"request"});
        if (opModel.hasEventStreamInput()) {
            b.add(", new $T()", new Object[]{EmptyPublisher.class});
            b.add(", $T.mock($T.class)", new Object[]{Mockito.class, this.poetExtension.eventStreamResponseHandlerType(opModel)});
        } else if (opModel.hasStreamingInput()) {
            b.add(", $T.fromString($S)", new Object[]{AsyncRequestBody.class, "hello"});
        }
        if (opModel.hasStreamingOutput()) {
            b.add(", $T.get($S)", new Object[]{Paths.class, "test.dat"});
        }
        b.add(")", new Object[0]);
        return b.build();
    }

    private MethodSpec asyncTestsSourceMethod() {
        String opName = this.findDefaultRequest();
        OperationModel defaultOpModel = this.model.getOperation(opName);
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"asyncTestCases").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{AsyncTestCase.class}));
        b.addCode("return $T.asList(", new Object[]{Arrays.class});
        EndpointTestSuiteModel endpointTestSuiteModel = this.model.getEndpointTestSuiteModel();
        Iterator<EndpointTestModel> testIter = endpointTestSuiteModel.getTestCases().iterator();
        while (testIter.hasNext()) {
            EndpointTestModel test = testIter.next();
            if (test.getOperationInputs() != null) {
                Iterator<OperationInput> operationInputsIter = test.getOperationInputs().iterator();
                while (operationInputsIter.hasNext()) {
                    OperationInput opInput = operationInputsIter.next();
                    OperationModel opModel = this.model.getOperation(opInput.getOperationName());
                    b.addCode("new $T($S, $L, $L$L)", new Object[]{AsyncTestCase.class, test.getDocumentation(), this.asyncOperationCallLambda(opModel, test.getParams(), opInput.getOperationParams()), TestGeneratorUtils.createExpect(test.getExpect()), this.getSkipReasonBlock(test.getDocumentation())});
                    if (!operationInputsIter.hasNext()) continue;
                    b.addCode(",", new Object[0]);
                }
            } else {
                b.addCode("new $T($S, $L, $L$L)", new Object[]{AsyncTestCase.class, test.getDocumentation(), this.asyncOperationCallLambda(defaultOpModel, test.getParams(), Collections.emptyMap()), TestGeneratorUtils.createExpect(test.getExpect()), this.getSkipReasonBlock(test.getDocumentation())});
            }
            if (!testIter.hasNext()) continue;
            b.addCode(",", new Object[0]);
        }
        b.addStatement(")", new Object[0]);
        return b.build();
    }

    private CodeBlock requestCreation(OperationModel opModel, Map<String, TreeNode> opParams) {
        CodeBlock.Builder b = CodeBlock.builder();
        ShapeModel inputModel = opModel.getInputShape();
        b.add("$T.builder()", new Object[]{this.poetExtension.getModelClass(inputModel.getShapeName())});
        ShapeModel inputShape = opModel.getInputShape();
        if (opParams != null) {
            opParams.forEach((n, v) -> {
                MemberModel memberModel = opModel.getInputShape().getMemberByName((String)n);
                CodeBlock memberValue = this.createMemberValue(memberModel, (TreeNode)v);
                b.add(".$N($L)", new Object[]{memberModel.getFluentSetterMethodName(), memberValue});
            });
        }
        if (EndpointRulesClientTestSpec.canBeEmpty(opModel)) {
            return b.add(".build()", new Object[0]).build();
        }
        inputShape.getMembers().forEach(m -> {
            if (!EndpointRulesClientTestSpec.boundToPath(m)) {
                return;
            }
            if (opParams.containsKey(m.getName())) {
                return;
            }
            b.add(".$N(", new Object[]{m.getFluentSetterMethodName()});
            switch (m.getVariable().getSimpleType()) {
                case "Boolean": {
                    b.add("true", new Object[0]);
                    break;
                }
                case "String": {
                    b.add("$S", new Object[]{"aws"});
                    break;
                }
                case "Long": 
                case "Integer": {
                    b.add("1", new Object[0]);
                    break;
                }
                default: {
                    throw new RuntimeException("Don't know how to set member: " + opModel.getOperationName() + "#" + m.getName() + " with type " + m.getVariable().getSimpleType());
                }
            }
            b.add(")", new Object[0]);
        });
        b.add(".build()", new Object[0]);
        return b.build();
    }

    private static boolean canBeEmpty(OperationModel opModel) {
        List<MemberModel> members = opModel.getInputShape().getMembers();
        if (members == null || members.isEmpty()) {
            return true;
        }
        if (opModel.hasStreamingOutput() || opModel.hasStreamingInput()) {
            return false;
        }
        Optional<MemberModel> pathMemberOrStreaming = members.stream().filter(EndpointRulesClientTestSpec::boundToPath).findFirst();
        return !pathMemberOrStreaming.isPresent();
    }

    private static boolean boundToPath(MemberModel member) {
        ParameterHttpMapping http = member.getHttp();
        if (http == null) {
            return false;
        }
        return http.getLocation() == Location.URI;
    }

    private ClassName syncClientClass() {
        return this.poetExtension.getClientClass(this.model.getMetadata().getSyncInterface());
    }

    private ClassName syncClientBuilder() {
        return this.poetExtension.getClientClass(this.model.getMetadata().getSyncBuilderInterface());
    }

    private ClassName asyncClientClass() {
        return this.poetExtension.getClientClass(this.model.getMetadata().getAsyncInterface());
    }

    private ClassName asyncClientBuilder() {
        return this.poetExtension.getClientClass(this.model.getMetadata().getAsyncBuilderInterface());
    }

    private CodeBlock setClientParams(String builderName, Map<String, TreeNode> params) {
        CodeBlock.Builder b = CodeBlock.builder();
        if (this.hasS3ConfigParams(params)) {
            CodeBlock.Builder config = CodeBlock.builder();
            config.add("$T.builder()", new Object[]{this.configClass()});
            params.forEach((n, v) -> {
                CodeBlock valueLiteral = this.endpointRulesSpecUtils.treeNodeToLiteral((TreeNode)v);
                switch (n) {
                    case "UseDualStack": {
                        config.add(".dualstackEnabled($L)", new Object[]{valueLiteral});
                        break;
                    }
                    case "Accelerate": {
                        config.add(".accelerateModeEnabled($L)", new Object[]{valueLiteral});
                        break;
                    }
                    case "ForcePathStyle": {
                        config.add(".pathStyleAccessEnabled($L)", new Object[]{valueLiteral});
                        break;
                    }
                    case "UseArnRegion": {
                        config.add(".useArnRegionEnabled($L)", new Object[]{valueLiteral});
                        break;
                    }
                    case "DisableMultiRegionAccessPoints": {
                        config.add(".multiRegionEnabled(!$L)", new Object[]{valueLiteral});
                        break;
                    }
                }
            });
            config.add(".build()", new Object[0]);
            b.addStatement("$N.serviceConfiguration($L)", new Object[]{builderName, config.build()});
        }
        params.forEach((n, v) -> {
            block10: {
                CodeBlock valueLiteral;
                block9: {
                    if (!this.isClientParam((String)n)) {
                        return;
                    }
                    ParameterModel paramModel = this.param((String)n);
                    valueLiteral = this.endpointRulesSpecUtils.treeNodeToLiteral((TreeNode)v);
                    if (paramModel.getBuiltInEnum() == null) break block9;
                    switch (paramModel.getBuiltInEnum()) {
                        case AWS_REGION: {
                            b.addStatement("$N.region($T.of($L))", new Object[]{builderName, Region.class, valueLiteral});
                            break;
                        }
                        case AWS_USE_DUAL_STACK: {
                            if (!this.hasS3ConfigParams(params)) {
                                b.addStatement("$N.dualstackEnabled($L)", new Object[]{builderName, valueLiteral});
                                break;
                            }
                            break block10;
                        }
                        case AWS_USE_FIPS: {
                            b.addStatement("$N.fipsEnabled($L)", new Object[]{builderName, valueLiteral});
                            break;
                        }
                        case SDK_ENDPOINT: {
                            b.addStatement("$N.endpointOverride($T.create($L))", new Object[]{builderName, URI.class, valueLiteral});
                            break;
                        }
                        case AWS_S3_USE_GLOBAL_ENDPOINT: {
                            b.addStatement("$T.setProperty($L, $L ? \"global\" : \"regional\")", new Object[]{System.class, this.s3RegionalEndpointSystemPropertyCode(), valueLiteral});
                            break;
                        }
                    }
                    break block10;
                }
                String setterName = this.endpointRulesSpecUtils.clientContextParamMethodName((String)n);
                b.addStatement("$N.$N($L)", new Object[]{builderName, setterName, valueLiteral});
            }
        });
        return b.build();
    }

    private boolean isClientParam(String name) {
        ParameterModel param = this.param(name);
        if (param == null) {
            return false;
        }
        boolean isBuiltIn = param.getBuiltInEnum() != null;
        Map<String, ClientContextParam> clientContextParams = this.model.getClientContextParams();
        boolean isClientContextParam = clientContextParams != null && clientContextParams.containsKey(name);
        return isBuiltIn || isClientContextParam;
    }

    private ParameterModel param(String name) {
        return this.model.getEndpointRuleSetModel().getParameters().get(name);
    }

    private boolean hasSyncClient() {
        return this.model.getOperations().values().stream().anyMatch(o -> !o.hasEventStreamOutput() && !o.hasEventStreamInput());
    }

    private boolean hasS3ConfigParams(Map<String, TreeNode> params) {
        String[] s3ConfigurationParams = new String[]{"ForcePathStyle", "Accelerate", "UseArnRegion", "DisableMultiRegionAccessPoints", "UseDualStack"};
        if (!this.endpointRulesSpecUtils.isS3() && !this.endpointRulesSpecUtils.isS3Control()) {
            return false;
        }
        return Stream.of(s3ConfigurationParams).anyMatch(params.keySet()::contains);
    }

    private ClassName configClass() {
        return this.poetExtension.getClientClass(this.model.getCustomizationConfig().getServiceConfig().getClassName());
    }

    private Map<String, String> getSkippedTests() {
        HashMap<String, String> skippedTests = new HashMap<String, String>(GLOBAL_SKIP_ENDPOINT_TESTS);
        Map<String, String> customSkippedTests = this.model.getCustomizationConfig().getSkipEndpointTests();
        if (customSkippedTests != null) {
            skippedTests.putAll(customSkippedTests);
        }
        return skippedTests;
    }

    private CodeBlock getSkipReasonBlock(String testName) {
        if (this.getSkippedTests().containsKey(testName)) {
            Validate.notNull((Object)this.getSkippedTests().get(testName), (String)"Test %s must have a reason for skipping", (Object[])new Object[]{testName});
            return CodeBlock.builder().add(", $S", new Object[]{this.getSkippedTests().get(testName)}).build();
        }
        return CodeBlock.builder().build();
    }

    private MethodSpec methodSetupMethod() {
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"methodSetup").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(BeforeEach.class).returns(Void.TYPE);
        b.addStatement("super.methodSetup()", new Object[0]);
        if (this.endpointRulesSpecUtils.isS3()) {
            b.addStatement("$T.setProperty($L, $S)", new Object[]{System.class, this.s3RegionalEndpointSystemPropertyCode(), "regional"});
        }
        return b.build();
    }

    private CodeBlock s3RegionalEndpointSystemPropertyCode() {
        return CodeBlock.builder().add("$T.AWS_S3_US_EAST_1_REGIONAL_ENDPOINT.property()", new Object[]{SdkSystemSetting.class}).build();
    }

    private FieldSpec s3RegionEndpointSystemPropertySaveValueField() {
        return FieldSpec.builder(String.class, (String)"regionalEndpointPropertySaveValue", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).initializer("$T.getProperty($L)", new Object[]{System.class, this.s3RegionalEndpointSystemPropertyCode()}).build();
    }

    private MethodSpec teardownMethod() {
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"teardown").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addAnnotation(AfterAll.class).returns(Void.TYPE);
        if (this.endpointRulesSpecUtils.isS3()) {
            b.beginControlFlow("if (regionalEndpointPropertySaveValue != null)", new Object[0]).addStatement("$T.setProperty($L, regionalEndpointPropertySaveValue)", new Object[]{System.class, this.s3RegionalEndpointSystemPropertyCode()}).endControlFlow().beginControlFlow("else", new Object[0]).addStatement("$T.clearProperty($L)", new Object[]{System.class, this.s3RegionalEndpointSystemPropertyCode()}).endControlFlow();
        }
        return b.build();
    }

    private CodeBlock createMemberValue(MemberModel memberModel, TreeNode valueNode) {
        if (memberModel.isSimple()) {
            return this.endpointRulesSpecUtils.treeNodeToLiteral(valueNode);
        }
        CodeBlock.Builder b = CodeBlock.builder();
        if (memberModel.isList()) {
            Iterator elementValuesIter = ((JrsArray)valueNode).elements();
            MemberModel listMemberModel = memberModel.getListModel().getListMemberModel();
            b.add("$T.asList(", new Object[]{Arrays.class});
            while (elementValuesIter.hasNext()) {
                JrsValue v = (JrsValue)elementValuesIter.next();
                b.add(this.createMemberValue(listMemberModel, (TreeNode)v));
                if (!elementValuesIter.hasNext()) continue;
                b.add(",", new Object[0]);
            }
            b.add(")", new Object[0]);
            return b.build();
        }
        if (memberModel.isMap()) {
            throw new RuntimeException("Don't know how to create map member.");
        }
        return this.createModelClass(this.model.getShapes().get(memberModel.getC2jShape()), valueNode);
    }

    private CodeBlock createModelClass(ShapeModel shapeModel, TreeNode valueNode) {
        ClassName modelClassName = this.poetExtension.getModelClass(shapeModel.getC2jName());
        CodeBlock.Builder b = CodeBlock.builder();
        b.add("$T.builder()", new Object[]{modelClassName});
        JrsObject obj = (JrsObject)valueNode;
        Iterator fieldNamesIter = obj.fieldNames();
        while (fieldNamesIter.hasNext()) {
            String fieldName = (String)fieldNamesIter.next();
            MemberModel member = shapeModel.getMemberByName(fieldName);
            JrsValue value = obj.get(fieldName);
            b.add(".$N($L)", new Object[]{member.getFluentSetterMethodName(), this.createMemberValue(member, (TreeNode)value)});
        }
        b.add(".build()", new Object[0]);
        return b.build();
    }

    static {
        HashMap<String, String> tests = new HashMap<String, String>();
        tests.put("For region us-iso-west-1 with FIPS enabled and DualStack enabled", "Client builder does the validation");
        tests.put("For region us-iso-west-1 with FIPS disabled and DualStack enabled", "Client builder does the validation");
        tests.put("For region us-iso-east-1 with FIPS enabled and DualStack enabled", "Client builder does the validation");
        tests.put("For region us-iso-east-1 with FIPS disabled and DualStack enabled", "Client builder does the validation");
        tests.put("For region us-isob-east-1 with FIPS enabled and DualStack enabled", "Client builder does the validation");
        tests.put("For region us-isob-east-1 with FIPS disabled and DualStack enabled", "Client builder does the validation");
        tests.put("For region us-isob-west-1 with FIPS enabled and DualStack enabled", "Client builder does the validation");
        tests.put("For region us-isob-west-1 with FIPS disabled and DualStack enabled", "Client builder does the validation");
        GLOBAL_SKIP_ENDPOINT_TESTS = Collections.unmodifiableMap(tests);
    }
}

