/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.utils;

import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.service.AuthType;

public final class BearerAuthUtils {
    private BearerAuthUtils() {
    }

    public static boolean usesBearerAuth(IntermediateModel model) {
        if (BearerAuthUtils.isServiceBearerAuth(model)) {
            return true;
        }
        return model.getOperations().values().stream().map(OperationModel::getAuthType).anyMatch(authType -> authType == AuthType.BEARER);
    }

    public static boolean isOpBearerAuth(IntermediateModel model, OperationModel opModel) {
        if (opModel.getAuthType() == AuthType.BEARER) {
            return true;
        }
        return BearerAuthUtils.isServiceBearerAuth(model) && BearerAuthUtils.hasNoAuthType(opModel);
    }

    private static boolean isServiceBearerAuth(IntermediateModel model) {
        return model.getMetadata().getAuthType() == AuthType.BEARER;
    }

    private static boolean hasNoAuthType(OperationModel opModel) {
        return opModel.getAuthType() == null || opModel.getAuthType() == AuthType.NONE;
    }
}

