/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.waiters;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.waiters.BaseWaiterClassSpec;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterResponse;

public class WaiterClassSpec
extends BaseWaiterClassSpec {
    private final PoetExtensions poetExtensions;
    private final ClassName className;
    private final String modelPackage;
    private final ClassName clientClassName;

    public WaiterClassSpec(IntermediateModel model) {
        super(model, ClassName.get(Waiter.class));
        this.modelPackage = model.getMetadata().getFullModelPackageName();
        this.poetExtensions = new PoetExtensions(model);
        this.className = this.poetExtensions.getSyncWaiterClass();
        this.clientClassName = this.poetExtensions.getClientClass(model.getMetadata().getSyncInterface());
    }

    @Override
    protected ClassName clientClassName() {
        return this.clientClassName;
    }

    protected ParameterizedTypeName getWaiterResponseType(OperationModel opModel) {
        ClassName pojoResponse = ClassName.get((String)this.modelPackage, (String)opModel.getReturnType().getReturnType(), (String[])new String[0]);
        return ParameterizedTypeName.get((ClassName)ClassName.get(WaiterResponse.class), (TypeName[])new TypeName[]{pojoResponse});
    }

    @Override
    protected ClassName interfaceClassName() {
        return this.poetExtensions.getSyncWaiterInterface();
    }

    @Override
    public ClassName className() {
        return this.className;
    }
}

