/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.eventstream;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.docs.DocumentationBuilder;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamUtils;
import software.amazon.awssdk.codegen.poet.model.EventStreamSpecHelper;

public class EventStreamVisitorBuilderInterfaceSpec
implements ClassSpec {
    private final PoetExtensions poetExt;
    private final OperationModel operationModel;
    private final ShapeModel eventStreamShape;
    private final ClassName visitorBuilderType;
    private final EventStreamSpecHelper eventStreamSpecHelper;

    EventStreamVisitorBuilderInterfaceSpec(PoetExtensions poetExt, IntermediateModel intermediateModel, OperationModel opModel) {
        this.poetExt = poetExt;
        this.operationModel = opModel;
        this.eventStreamShape = EventStreamUtils.getEventStreamInResponse(this.operationModel.getOutputShape());
        this.visitorBuilderType = poetExt.eventStreamResponseHandlerVisitorBuilderType(opModel);
        this.eventStreamSpecHelper = new EventStreamSpecHelper(this.eventStreamShape, intermediateModel);
    }

    @Override
    public final TypeSpec poetSpec() {
        TypeSpec.Builder typeBuilder = this.createTypeSpec().addMethod(this.applyOnDefaultMethodSpecUpdates(this.createOnDefaultMethodSpec()).build()).addMethod(this.applyBuildMethodSpecUpdates(this.createBuildMethodSpec()).build());
        EventStreamUtils.getEvents(this.eventStreamShape).forEach(e -> typeBuilder.addMethod(this.applyOnSubTypeMethodSpecUpdates(typeBuilder, this.createOnSubTypeMethodSpec((MemberModel)e), (MemberModel)e).build()));
        return typeBuilder.build();
    }

    protected TypeSpec.Builder createTypeSpec() {
        String javadocs = "Builder for {@link $1T}. The {@link $1T} class may also be extended for a more traditional style but this builder allows for a more functional way of creating a visitor will callback methods.";
        return PoetUtils.createInterfaceBuilder(this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addJavadoc(javadocs, new Object[]{this.poetExt.eventStreamResponseHandlerVisitorType(this.operationModel)});
    }

    @Override
    public ClassName className() {
        return this.visitorBuilderType;
    }

    private MethodSpec.Builder createOnDefaultMethodSpec() {
        ParameterizedTypeName eventConsumerType = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{this.poetExt.getModelClassFromShape(this.eventStreamShape)});
        return MethodSpec.methodBuilder((String)"onDefault").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)eventConsumerType, (String)"c", (Modifier[])new Modifier[0]).build()).returns((TypeName)this.visitorBuilderType);
    }

    protected MethodSpec.Builder applyOnDefaultMethodSpecUpdates(MethodSpec.Builder builder) {
        String javadocs = new DocumentationBuilder().description("Callback to invoke when either an unknown event is visited or an unhandled event is visited.").param("c", "Callback to process the event.").returns("This builder for method chaining.").build();
        return builder.addModifiers(new Modifier[]{Modifier.ABSTRACT}).addJavadoc(javadocs, new Object[0]);
    }

    private MethodSpec.Builder createBuildMethodSpec() {
        return MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.poetExt.eventStreamResponseHandlerVisitorType(this.operationModel));
    }

    protected MethodSpec.Builder applyBuildMethodSpecUpdates(MethodSpec.Builder builder) {
        return builder.addModifiers(new Modifier[]{Modifier.ABSTRACT}).addJavadoc("@return Visitor implementation.", new Object[0]);
    }

    protected MethodSpec.Builder applyOnSubTypeMethodSpecUpdates(TypeSpec.Builder typeBuilder, MethodSpec.Builder methodBuilder, MemberModel event) {
        ClassName eventSubType = this.poetExt.getModelClass(event.getShape().getShapeName());
        String javadocs = new DocumentationBuilder().description("Callback to invoke when a {@link $T} is visited.").param("c", "Callback to process the event.").returns("This builder for method chaining.").build();
        return methodBuilder.addModifiers(new Modifier[]{Modifier.ABSTRACT}).addJavadoc(javadocs, new Object[]{eventSubType});
    }

    private MethodSpec.Builder createOnSubTypeMethodSpec(MemberModel event) {
        ClassName eventSubType = this.poetExt.getModelClass(event.getShape().getShapeName());
        ParameterizedTypeName eventConsumerType = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{eventSubType});
        return MethodSpec.methodBuilder((String)this.eventStreamSpecHelper.eventConsumerName(event)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)eventConsumerType, (String)"c", (Modifier[])new Modifier[0]).build()).returns((TypeName)this.visitorBuilderType);
    }
}

