/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client.specs;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.model.service.AuthType;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.runtime.transform.AsyncStreamingRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.StreamingRequestMarshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.utils.StringUtils;

public interface ProtocolSpec {
    public FieldSpec protocolFactory(IntermediateModel var1);

    public MethodSpec initProtocolFactory(IntermediateModel var1);

    public CodeBlock responseHandler(IntermediateModel var1, OperationModel var2);

    public Optional<CodeBlock> errorResponseHandler(OperationModel var1);

    public CodeBlock executionHandler(OperationModel var1);

    default public CodeBlock asyncExecutionHandler(IntermediateModel intermediateModel, OperationModel opModel) {
        return this.executionHandler(opModel);
    }

    default public Class<? extends SyncClientHandler> getClientHandlerClass() {
        return AwsSyncClientHandler.class;
    }

    public Optional<MethodSpec> createErrorResponseHandler();

    default public List<MethodSpec> additionalMethods() {
        return new ArrayList<MethodSpec>();
    }

    default public List<CodeBlock> registerModeledExceptions(IntermediateModel model, PoetExtension poetExtensions) {
        return model.getShapes().values().stream().filter(s -> s.getShapeType() == ShapeType.Exception).map(e -> CodeBlock.builder().add(".registerModeledException($T.builder().errorCode($S).exceptionBuilderSupplier($T::builder)$L.build())", new Object[]{ExceptionMetadata.class, e.getErrorCode(), poetExtensions.getModelClass(e.getShapeName()), this.populateHttpStatusCode((ShapeModel)e, model)}).build()).collect(Collectors.toList());
    }

    default public String populateHttpStatusCode(ShapeModel shapeModel, IntermediateModel model) {
        Integer statusCode = shapeModel.getHttpStatusCode();
        if (statusCode == null && model.getMetadata().getProtocol() == Protocol.AWS_JSON) {
            statusCode = shapeModel.isFault() ? Integer.valueOf(500) : Integer.valueOf(400);
        }
        return statusCode != null ? String.format(".httpStatusCode(%d)", statusCode) : "";
    }

    default public String hostPrefixExpression(OperationModel opModel) {
        return opModel.getEndpointTrait() != null && !StringUtils.isEmpty((CharSequence)opModel.getEndpointTrait().getHostPrefix()) ? ".hostPrefixExpression(resolvedHostExpression)\n" : "";
    }

    default public String discoveredEndpoint(OperationModel opModel) {
        return opModel.getEndpointDiscovery() != null ? ".discoveredEndpoint(cachedEndpoint)\n" : "";
    }

    default public CodeBlock syncStreamingMarshaller(IntermediateModel model, OperationModel opModel, ClassName marshaller) {
        return this.streamingMarshallerCode(model, opModel, marshaller, "protocolFactory", false);
    }

    default public CodeBlock asyncMarshaller(IntermediateModel model, OperationModel opModel, ClassName marshaller, String protocolFactory) {
        if (opModel.hasStreamingInput()) {
            return this.streamingMarshallerCode(model, opModel, marshaller, protocolFactory, true);
        }
        return CodeBlock.builder().add("new $T($L)", new Object[]{marshaller, protocolFactory}).build();
    }

    default public CodeBlock streamingMarshallerCode(IntermediateModel model, OperationModel opModel, ClassName marshaller, String protocolFactory, boolean isAsync) {
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.builder().delegateMarshaller(new $T($L))", new Object[]{isAsync ? AsyncStreamingRequestMarshaller.class : StreamingRequestMarshaller.class, marshaller, protocolFactory}).add(".$L(requestBody)", new Object[]{isAsync ? "asyncRequestBody" : "requestBody"});
        if (opModel.hasRequiresLengthInInput()) {
            builder.add(".requiresLength(true)", new Object[0]);
        }
        if (opModel.getAuthType() == AuthType.V4_UNSIGNED_BODY) {
            builder.add(".transferEncoding(true)", new Object[0]);
        }
        if (model.getMetadata().supportsH2()) {
            builder.add(".useHttp2(true)", new Object[0]);
        }
        builder.add(".build()", new Object[0]);
        return builder.build();
    }

    default public String streamingOutputWhenComplete(String responseHandlerName) {
        return String.format(".whenComplete((r, e) -> {%n     if (e != null) {%n         runAndLogError(log, \"Exception thrown in exceptionOccurred callback, ignoring\", () -> %s.exceptionOccurred(e));%n     }%n     endOfStreamFuture.whenComplete((r2, e2) -> {%n         %s%n     });})", responseHandlerName, this.publishMetrics());
    }

    default public TypeName executeFutureValueType(OperationModel opModel, PoetExtension poetExtensions) {
        if (opModel.hasEventStreamOutput()) {
            return ClassName.get(Void.class);
        }
        if (opModel.hasStreamingOutput()) {
            return TypeVariableName.get((String)"ReturnT");
        }
        return this.getPojoResponseType(opModel, poetExtensions);
    }

    default public TypeName getPojoResponseType(OperationModel opModel, PoetExtension poetExtensions) {
        return poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
    }

    default public String publishMetricsWhenComplete() {
        return String.format(".whenComplete((r, e) -> {%n%s%n})", this.publishMetrics());
    }

    default public String publishMetrics() {
        return "metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));";
    }
}

