/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.eventstream;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.function.Consumer;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamUtils;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamVisitorBuilderInterfaceSpec;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamVisitorInterfaceSpec;
import software.amazon.awssdk.codegen.poet.model.EventStreamSpecHelper;

public class EventStreamVisitorBuilderImplSpec
extends EventStreamVisitorBuilderInterfaceSpec {
    private final IntermediateModel intermediateModel;
    private final PoetExtensions poetExt;
    private final OperationModel opModel;
    private final ClassName visitorType;
    private final ClassName visitorBuilderType;
    private final ClassName eventStreamBaseClass;
    private final EventStreamSpecHelper eventStreamSpecHelper;

    public EventStreamVisitorBuilderImplSpec(GeneratorTaskParams params, OperationModel operationModel) {
        super(params.getPoetExtensions(), params.getModel(), operationModel);
        this.intermediateModel = params.getModel();
        this.poetExt = params.getPoetExtensions();
        this.opModel = operationModel;
        this.visitorType = this.poetExt.eventStreamResponseHandlerVisitorType(this.opModel);
        this.visitorBuilderType = this.poetExt.eventStreamResponseHandlerVisitorBuilderType(this.opModel);
        ShapeModel eventStream = EventStreamUtils.getEventStreamInResponse(operationModel.getOutputShape());
        this.eventStreamBaseClass = this.poetExt.getModelClassFromShape(eventStream);
        this.eventStreamSpecHelper = new EventStreamSpecHelper(eventStream, this.intermediateModel);
    }

    @Override
    protected TypeSpec.Builder createTypeSpec() {
        return PoetUtils.createClassBuilder(this.className()).addModifiers(new Modifier[]{Modifier.FINAL}).addAnnotation(SdkInternalApi.class).addSuperinterface((TypeName)this.visitorBuilderType).addField(FieldSpec.builder((TypeName)this.consumerType(this.eventStreamBaseClass), (String)"onDefault", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build()).addType(new VisitorFromBuilderImplSpec().poetSpec());
    }

    @Override
    protected MethodSpec.Builder applyOnSubTypeMethodSpecUpdates(TypeSpec.Builder typeBuilder, MethodSpec.Builder methodBuilder, MemberModel event) {
        ClassName eventSubType = this.poetExt.getModelClass(event.getShape().getShapeName());
        TypeName eventConsumerType = this.consumerType(eventSubType);
        FieldSpec consumerField = FieldSpec.builder((TypeName)eventConsumerType, (String)this.eventStreamSpecHelper.eventConsumerName(event), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
        typeBuilder.addField(consumerField);
        return methodBuilder.addAnnotation(Override.class).addStatement("this.$L = c", new Object[]{consumerField.name}).addStatement("return this", new Object[0]);
    }

    @Override
    protected MethodSpec.Builder applyOnDefaultMethodSpecUpdates(MethodSpec.Builder builder) {
        return builder.addAnnotation(Override.class).addStatement("this.onDefault = c", new Object[0]).addStatement("return this", new Object[0]);
    }

    @Override
    protected MethodSpec.Builder applyBuildMethodSpecUpdates(MethodSpec.Builder builder) {
        return builder.addAnnotation(Override.class).addStatement("return new $T(this)", new Object[]{this.className().nestedClass("VisitorFromBuilder")});
    }

    @Override
    public ClassName className() {
        return this.poetExt.getModelClass(String.format("Default%sVisitorBuilder", this.poetExt.getApiName(this.opModel)));
    }

    private TypeName consumerType(ClassName paramType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{paramType});
    }

    private class VisitorFromBuilderImplSpec
    extends EventStreamVisitorInterfaceSpec {
        private final MethodSpec.Builder constrBuilder;

        VisitorFromBuilderImplSpec() {
            super(EventStreamVisitorBuilderImplSpec.this.intermediateModel, EventStreamVisitorBuilderImplSpec.this.poetExt, EventStreamVisitorBuilderImplSpec.this.opModel);
            this.constrBuilder = MethodSpec.constructorBuilder().addParameter((TypeName)this.enclosingClassName(), "builder", new Modifier[0]).addStatement("this.onDefault = builder.onDefault != null ?\nbuilder.onDefault :\n$T.super::visitDefault", new Object[]{EventStreamVisitorBuilderImplSpec.this.visitorType});
        }

        @Override
        protected TypeSpec.Builder createTypeSpec() {
            return PoetUtils.createClassBuilder(this.className()).addModifiers(new Modifier[]{Modifier.STATIC}).addField(EventStreamVisitorBuilderImplSpec.this.consumerType(EventStreamVisitorBuilderImplSpec.this.eventStreamBaseClass), "onDefault", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addSuperinterface((TypeName)EventStreamVisitorBuilderImplSpec.this.visitorType);
        }

        @Override
        protected TypeSpec.Builder finalizeTypeSpec(TypeSpec.Builder builder) {
            return builder.addMethod(this.constrBuilder.build());
        }

        @Override
        protected MethodSpec.Builder applyVisitDefaultMethodSpecUpdates(MethodSpec.Builder builder) {
            return builder.addAnnotation(Override.class).addStatement("onDefault.accept(event)", new Object[0]);
        }

        @Override
        protected MethodSpec.Builder applyVisitSubTypeMethodSpecUpdates(TypeSpec.Builder typeBuilder, MethodSpec.Builder methodBuilder, MemberModel event) {
            ClassName eventSubType = EventStreamVisitorBuilderImplSpec.this.poetExt.getModelClass(event.getShape().getShapeName());
            TypeName eventConsumerType = EventStreamVisitorBuilderImplSpec.this.consumerType(eventSubType);
            FieldSpec consumerField = FieldSpec.builder((TypeName)eventConsumerType, (String)EventStreamVisitorBuilderImplSpec.this.eventStreamSpecHelper.eventConsumerName(event), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
            typeBuilder.addField(consumerField);
            this.constrBuilder.addStatement("this.$1L = builder.$1L != null ?\nbuilder.$1L :\n$2T.super::$3N", new Object[]{consumerField.name, EventStreamVisitorBuilderImplSpec.this.visitorType, EventStreamVisitorBuilderImplSpec.this.eventStreamSpecHelper.visitMethodName(event)});
            return methodBuilder.addAnnotation(Override.class).addStatement("$L.accept(event)", new Object[]{consumerField.name});
        }

        @Override
        public ClassName className() {
            return this.enclosingClassName().nestedClass("VisitorFromBuilder");
        }

        private ClassName enclosingClassName() {
            return EventStreamVisitorBuilderImplSpec.this.className();
        }
    }
}

