/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.io.File;
import java.util.function.Consumer;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.model.config.customization.ShareModelConfig;

public class SharedModelsTaskParamsValidator
implements Consumer<GeneratorTaskParams> {
    @Override
    public void accept(GeneratorTaskParams params) {
        File modelPackageDirectory;
        ShareModelConfig sharedModelService = params.getModel().getCustomizationConfig().getShareModelConfig();
        if (sharedModelService != null && !(modelPackageDirectory = new File(params.getPathProvider().getModelDirectory())).exists()) {
            String error = String.format("Unable to share models with '%s', because that service's models haven't been generated yet ('%s' doesn't exist). You must generate that service before generating '%s'.", sharedModelService, modelPackageDirectory, params.getModel().getMetadata().getDescriptiveServiceName());
            throw new IllegalStateException(error);
        }
    }
}

