/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.waiters;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.docs.WaiterDocs;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.waiters.BaseWaiterInterfaceSpec;
import software.amazon.awssdk.core.waiters.WaiterResponse;

public final class AsyncWaiterInterfaceSpec
extends BaseWaiterInterfaceSpec {
    private final IntermediateModel model;
    private final PoetExtensions poetExtensions;
    private final ClassName className;
    private final String modelPackage;

    public AsyncWaiterInterfaceSpec(IntermediateModel model) {
        super(model);
        this.modelPackage = model.getMetadata().getFullModelPackageName();
        this.model = model;
        this.poetExtensions = new PoetExtensions(model);
        this.className = this.poetExtensions.getAsyncWaiterInterface();
    }

    @Override
    protected ClassName waiterImplName() {
        return this.poetExtensions.getAsyncWaiterClass();
    }

    @Override
    protected ClassName clientClassName() {
        return this.poetExtensions.getClientClass(this.model.getMetadata().getAsyncInterface());
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    @Override
    protected ParameterizedTypeName getWaiterResponseType(OperationModel opModel) {
        ClassName pojoResponse = ClassName.get((String)this.modelPackage, (String)opModel.getReturnType().getReturnType(), (String[])new String[0]);
        ParameterizedTypeName waiterResponse = ParameterizedTypeName.get((ClassName)ClassName.get(WaiterResponse.class), (TypeName[])new TypeName[]{pojoResponse});
        return ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{waiterResponse});
    }

    @Override
    protected void additionalBuilderTypeSpecModification(TypeSpec.Builder type) {
        type.addMethod(MethodSpec.methodBuilder((String)"scheduledExecutorService").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)ClassName.get(ScheduledExecutorService.class), "executorService", new Modifier[0]).addJavadoc(WaiterDocs.waiterBuilderScheduledExecutorServiceJavadoc()).returns((TypeName)this.className().nestedClass("Builder")).build());
    }
}

