/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.jmespath.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiFunction;
import software.amazon.awssdk.codegen.internal.Jackson;
import software.amazon.awssdk.codegen.jmespath.component.AndExpression;
import software.amazon.awssdk.codegen.jmespath.component.BracketSpecifier;
import software.amazon.awssdk.codegen.jmespath.component.BracketSpecifierWithQuestionMark;
import software.amazon.awssdk.codegen.jmespath.component.Comparator;
import software.amazon.awssdk.codegen.jmespath.component.ComparatorExpression;
import software.amazon.awssdk.codegen.jmespath.component.CurrentNode;
import software.amazon.awssdk.codegen.jmespath.component.Expression;
import software.amazon.awssdk.codegen.jmespath.component.ExpressionType;
import software.amazon.awssdk.codegen.jmespath.component.FunctionArg;
import software.amazon.awssdk.codegen.jmespath.component.FunctionExpression;
import software.amazon.awssdk.codegen.jmespath.component.IndexExpression;
import software.amazon.awssdk.codegen.jmespath.component.KeyValueExpression;
import software.amazon.awssdk.codegen.jmespath.component.Literal;
import software.amazon.awssdk.codegen.jmespath.component.MultiSelectHash;
import software.amazon.awssdk.codegen.jmespath.component.MultiSelectList;
import software.amazon.awssdk.codegen.jmespath.component.NotExpression;
import software.amazon.awssdk.codegen.jmespath.component.OrExpression;
import software.amazon.awssdk.codegen.jmespath.component.ParenExpression;
import software.amazon.awssdk.codegen.jmespath.component.PipeExpression;
import software.amazon.awssdk.codegen.jmespath.component.SliceExpression;
import software.amazon.awssdk.codegen.jmespath.component.SubExpression;
import software.amazon.awssdk.codegen.jmespath.component.SubExpressionRight;
import software.amazon.awssdk.codegen.jmespath.component.WildcardExpression;
import software.amazon.awssdk.codegen.jmespath.parser.ParseResult;
import software.amazon.awssdk.codegen.jmespath.parser.Parser;
import software.amazon.awssdk.codegen.jmespath.parser.util.CompositeParser;
import software.amazon.awssdk.utils.Logger;

public class JmesPathParser {
    private static final Logger log = Logger.loggerFor(JmesPathParser.class);
    private final String input;

    private JmesPathParser(String input) {
        this.input = input;
    }

    public static Expression parse(String jmesPathString) {
        return new JmesPathParser(jmesPathString).parse();
    }

    private Expression parse() {
        ParseResult<Expression> expression = this.parseExpression(0, this.input.length());
        if (!expression.hasResult()) {
            throw new IllegalArgumentException("Failed to parse expression.");
        }
        return expression.result();
    }

    private ParseResult<Expression> parseExpression(int startPosition, int endPosition) {
        startPosition = this.trimLeftWhitespace(startPosition, endPosition);
        endPosition = this.trimRightWhitespace(startPosition, endPosition);
        if (startPosition < 0 || endPosition > this.input.length() + 1) {
            return ParseResult.error();
        }
        return CompositeParser.firstTry(this::parseSubExpression, Expression::subExpression).thenTry(this::parseIndexExpression, Expression::indexExpression).thenTry(this::parseNotExpression, Expression::notExpression).thenTry(this::parseAndExpression, Expression::andExpression).thenTry(this::parseOrExpression, Expression::orExpression).thenTry(this::parseComparatorExpression, Expression::comparatorExpression).thenTry(this::parsePipeExpression, Expression::pipeExpression).thenTry(this::parseIdentifier, Expression::identifier).thenTry(this::parseParenExpression, Expression::parenExpression).thenTry(this::parseWildcardExpression, Expression::wildcardExpression).thenTry(this::parseMultiSelectList, Expression::multiSelectList).thenTry(this::parseMultiSelectHash, Expression::multiSelectHash).thenTry(this::parseLiteral, Expression::literal).thenTry(this::parseFunctionExpression, Expression::functionExpression).thenTry(this::parseRawString, Expression::rawString).thenTry(this::parseCurrentNode, Expression::currentNode).parse(startPosition, endPosition);
    }

    private ParseResult<SubExpression> parseSubExpression(int startPosition, int endPosition) {
        startPosition = this.trimLeftWhitespace(startPosition, endPosition);
        endPosition = this.trimRightWhitespace(startPosition, endPosition);
        List<Integer> dotPositions = this.findCharacters(startPosition + 1, endPosition - 1, ".");
        for (Integer dotPosition : dotPositions) {
            ParseResult<SubExpressionRight> rightSide;
            ParseResult<Expression> leftSide = this.parseExpression(startPosition, dotPosition);
            if (!leftSide.hasResult() || !(rightSide = CompositeParser.firstTry(this::parseIdentifier, SubExpressionRight::identifier).thenTry(this::parseMultiSelectList, SubExpressionRight::multiSelectList).thenTry(this::parseMultiSelectHash, SubExpressionRight::multiSelectHash).thenTry(this::parseFunctionExpression, SubExpressionRight::functionExpression).thenTry(this::parseWildcardExpression, SubExpressionRight::wildcardExpression).parse(dotPosition + 1, endPosition)).hasResult()) continue;
            return ParseResult.success(new SubExpression(leftSide.result(), rightSide.result()));
        }
        this.logError("sub-expression", "Invalid sub-expression", startPosition);
        return ParseResult.error();
    }

    private ParseResult<PipeExpression> parsePipeExpression(int startPosition, int endPosition) {
        return this.parseBinaryExpression(startPosition, endPosition, "|", PipeExpression::new);
    }

    private ParseResult<OrExpression> parseOrExpression(int startPosition, int endPosition) {
        return this.parseBinaryExpression(startPosition, endPosition, "||", OrExpression::new);
    }

    private ParseResult<AndExpression> parseAndExpression(int startPosition, int endPosition) {
        return this.parseBinaryExpression(startPosition, endPosition, "&&", AndExpression::new);
    }

    private <T> ParseResult<T> parseBinaryExpression(int startPosition, int endPosition, String delimiter, BiFunction<Expression, Expression, T> constructor) {
        startPosition = this.trimLeftWhitespace(startPosition, endPosition);
        endPosition = this.trimRightWhitespace(startPosition, endPosition);
        List<Integer> delimiterPositions = this.findCharacters(startPosition + 1, endPosition - 1, delimiter);
        for (Integer delimiterPosition : delimiterPositions) {
            ParseResult<Expression> rightSide;
            ParseResult<Expression> leftSide = this.parseExpression(startPosition, delimiterPosition);
            if (!leftSide.hasResult() || !(rightSide = this.parseExpression(delimiterPosition + delimiter.length(), endPosition)).hasResult()) continue;
            return ParseResult.success(constructor.apply(leftSide.result(), rightSide.result()));
        }
        this.logError("binary-expression", "Invalid binary-expression", startPosition);
        return ParseResult.error();
    }

    private ParseResult<NotExpression> parseNotExpression(int startPosition, int endPosition) {
        startPosition = this.trimLeftWhitespace(startPosition, endPosition);
        endPosition = this.trimRightWhitespace(startPosition, endPosition);
        if (!this.startsWith(startPosition, '!')) {
            this.logError("not-expression", "Expected '!'", startPosition);
            return ParseResult.error();
        }
        return this.parseExpression(startPosition + 1, endPosition).mapResult(NotExpression::new);
    }

    private ParseResult<ParenExpression> parseParenExpression(int startPosition, int endPosition) {
        if (!this.startsAndEndsWith(startPosition = this.trimLeftWhitespace(startPosition, endPosition), endPosition = this.trimRightWhitespace(startPosition, endPosition), '(', ')')) {
            this.logError("paren-expression", "Expected '(' and ')'", startPosition);
            return ParseResult.error();
        }
        return this.parseExpression(startPosition + 1, endPosition - 1).mapResult(ParenExpression::new);
    }

    private ParseResult<IndexExpression> parseIndexExpression(int startPosition, int endPosition) {
        startPosition = this.trimLeftWhitespace(startPosition, endPosition);
        endPosition = this.trimRightWhitespace(startPosition, endPosition);
        return CompositeParser.firstTry(this::parseIndexExpressionWithLhsExpression).thenTry(this::parseBracketSpecifier, b -> IndexExpression.indexExpression(null, b)).parse(startPosition, endPosition);
    }

    private ParseResult<IndexExpression> parseIndexExpressionWithLhsExpression(int startPosition, int endPosition) {
        startPosition = this.trimLeftWhitespace(startPosition, endPosition);
        endPosition = this.trimRightWhitespace(startPosition, endPosition);
        List<Integer> bracketPositions = this.findCharacters(startPosition + 1, endPosition - 1, "[");
        for (Integer bracketPosition : bracketPositions) {
            ParseResult<BracketSpecifier> rightSide;
            ParseResult<Expression> leftSide = this.parseExpression(startPosition, bracketPosition);
            if (!leftSide.hasResult() || !(rightSide = this.parseBracketSpecifier(bracketPosition, endPosition)).hasResult()) continue;
            return ParseResult.success(IndexExpression.indexExpression(leftSide.result(), rightSide.result()));
        }
        this.logError("index-expression with lhs-expression", "Invalid index-expression with lhs-expression", startPosition);
        return ParseResult.error();
    }

    private ParseResult<MultiSelectList> parseMultiSelectList(int startPosition, int endPosition) {
        return this.parseMultiSelect(startPosition, endPosition, '[', ']', this::parseExpression).mapResult(MultiSelectList::new);
    }

    private ParseResult<MultiSelectHash> parseMultiSelectHash(int startPosition, int endPosition) {
        return this.parseMultiSelect(startPosition, endPosition, '{', '}', this::parseKeyValueExpression).mapResult(MultiSelectHash::new);
    }

    private <T> ParseResult<List<T>> parseMultiSelect(int startPosition, int endPosition, char startDelimiter, char endDelimiter, Parser<T> entryParser) {
        if (!this.startsAndEndsWith(startPosition = this.trimLeftWhitespace(startPosition, endPosition), endPosition = this.trimRightWhitespace(startPosition, endPosition), startDelimiter, endDelimiter)) {
            this.logError("multi-select", "Expected '" + startDelimiter + "' and '" + endDelimiter + "'", startPosition);
            return ParseResult.error();
        }
        List<Integer> commaPositions = this.findCharacters(startPosition + 1, endPosition - 1, ",");
        if (commaPositions.isEmpty()) {
            return entryParser.parse(startPosition + 1, endPosition - 1).mapResult(Collections::singletonList);
        }
        ArrayList<T> results = new ArrayList<T>();
        int startOfSecondEntry = -1;
        for (Integer n : commaPositions) {
            ParseResult<T> result = entryParser.parse(startPosition + 1, n);
            if (!result.hasResult()) continue;
            results.add(result.result());
            startOfSecondEntry = n + 1;
        }
        if (results.size() == 0) {
            this.logError("multi-select", "Invalid value", startPosition + 1);
            return ParseResult.error();
        }
        if (results.size() > 1) {
            this.logError("multi-select", "Ambiguous separation", startPosition);
            return ParseResult.error();
        }
        int startPositionAfterComma = startOfSecondEntry;
        for (Integer commaPosition : commaPositions) {
            ParseResult<T> entry;
            if (startPositionAfterComma > commaPosition || !(entry = entryParser.parse(startPositionAfterComma, commaPosition)).hasResult()) continue;
            results.add(entry.result());
            startPositionAfterComma = commaPosition + 1;
        }
        ParseResult<T> parseResult = entryParser.parse(startPositionAfterComma, endPosition - 1);
        if (!parseResult.hasResult()) {
            this.logError("multi-select", "Ambiguous separation", startPosition);
            return ParseResult.error();
        }
        results.add(parseResult.result());
        return ParseResult.success(results);
    }

    private ParseResult<KeyValueExpression> parseKeyValueExpression(int startPosition, int endPosition) {
        startPosition = this.trimLeftWhitespace(startPosition, endPosition);
        endPosition = this.trimRightWhitespace(startPosition, endPosition);
        List<Integer> delimiterPositions = this.findCharacters(startPosition + 1, endPosition - 1, ":");
        for (Integer delimiterPosition : delimiterPositions) {
            ParseResult<Expression> expression;
            ParseResult<String> identifier = this.parseIdentifier(startPosition, delimiterPosition);
            if (!identifier.hasResult() || !(expression = this.parseExpression(delimiterPosition + 1, endPosition)).hasResult()) continue;
            return ParseResult.success(new KeyValueExpression(identifier.result(), expression.result()));
        }
        this.logError("keyval-expr", "Invalid keyval-expr", startPosition);
        return ParseResult.error();
    }

    private ParseResult<BracketSpecifier> parseBracketSpecifier(int startPosition, int endPosition) {
        if (!this.startsAndEndsWith(startPosition = this.trimLeftWhitespace(startPosition, endPosition), endPosition = this.trimRightWhitespace(startPosition, endPosition), '[', ']')) {
            this.logError("bracket-specifier", "Expecting '[' and ']'", startPosition);
            return ParseResult.error();
        }
        if (this.charsInRange(startPosition, endPosition) == 2) {
            return ParseResult.success(BracketSpecifier.withoutContents());
        }
        if (this.input.charAt(startPosition + 1) == '?') {
            return this.parseExpression(startPosition + 2, endPosition - 1).mapResult(e -> BracketSpecifier.withQuestionMark(new BracketSpecifierWithQuestionMark((Expression)e)));
        }
        return CompositeParser.firstTry(this::parseNumber, BracketSpecifier::withNumberContents).thenTry(this::parseWildcardExpression, BracketSpecifier::withWildcardExpressionContents).thenTry(this::parseSliceExpression, BracketSpecifier::withSliceExpressionContents).parse(startPosition + 1, endPosition - 1);
    }

    private ParseResult<ComparatorExpression> parseComparatorExpression(int startPosition, int endPosition) {
        startPosition = this.trimLeftWhitespace(startPosition, endPosition);
        endPosition = this.trimRightWhitespace(startPosition, endPosition);
        for (Comparator comparator : Comparator.values()) {
            List<Integer> comparatorPositions = this.findCharacters(startPosition, endPosition, comparator.tokenSymbol());
            for (Integer comparatorPosition : comparatorPositions) {
                ParseResult<Expression> rhsExpression;
                ParseResult<Expression> lhsExpression = this.parseExpression(startPosition, comparatorPosition);
                if (!lhsExpression.hasResult() || !(rhsExpression = this.parseExpression(comparatorPosition + comparator.tokenSymbol().length(), endPosition)).hasResult()) continue;
                return ParseResult.success(new ComparatorExpression(lhsExpression.result(), comparator, rhsExpression.result()));
            }
        }
        this.logError("comparator-expression", "Invalid comparator expression", startPosition);
        return ParseResult.error();
    }

    private ParseResult<SliceExpression> parseSliceExpression(int startPosition, int endPosition) {
        startPosition = this.trimLeftWhitespace(startPosition, endPosition);
        endPosition = this.trimRightWhitespace(startPosition, endPosition);
        int firstColonIndex = this.input.indexOf(58, startPosition);
        if (firstColonIndex < 0 || firstColonIndex >= endPosition) {
            this.logError("slice-expression", "Expected slice expression", startPosition);
            return ParseResult.error();
        }
        int maybeSecondColonIndex = this.input.indexOf(58, firstColonIndex + 1);
        OptionalInt secondColonIndex = maybeSecondColonIndex < 0 || maybeSecondColonIndex >= endPosition ? OptionalInt.empty() : OptionalInt.of(maybeSecondColonIndex);
        int firstNumberStart = startPosition;
        int firstNumberEnd = firstColonIndex;
        int secondNumberStart = firstColonIndex + 1;
        int secondNumberEnd = secondColonIndex.orElse(endPosition);
        int thirdNumberStart = secondColonIndex.orElse(endPosition) + 1;
        int thirdNumberEnd = endPosition;
        Optional<Object> firstNumber = Optional.empty();
        if (firstNumberStart < firstNumberEnd) {
            ParseResult<Integer> firstNumberParse = this.parseNumber(firstNumberStart, firstNumberEnd);
            if (!firstNumberParse.hasResult()) {
                return ParseResult.error();
            }
            firstNumber = Optional.of(firstNumberParse.result());
        }
        Optional<Object> secondNumber = Optional.empty();
        if (secondNumberStart < secondNumberEnd) {
            ParseResult<Integer> secondNumberParse = this.parseNumber(secondNumberStart, secondNumberEnd);
            if (!secondNumberParse.hasResult()) {
                return ParseResult.error();
            }
            secondNumber = Optional.of(secondNumberParse.result());
        }
        Optional<Object> thirdNumber = Optional.empty();
        if (thirdNumberStart < thirdNumberEnd) {
            ParseResult<Integer> thirdNumberParse = this.parseNumber(thirdNumberStart, thirdNumberEnd);
            if (!thirdNumberParse.hasResult()) {
                return ParseResult.error();
            }
            thirdNumber = Optional.of(thirdNumberParse.result());
        }
        return ParseResult.success(new SliceExpression(firstNumber.orElse(null), secondNumber.orElse(null), thirdNumber.orElse(null)));
    }

    private ParseResult<FunctionExpression> parseFunctionExpression(int startPosition, int endPosition) {
        startPosition = this.trimLeftWhitespace(startPosition, endPosition);
        endPosition = this.trimRightWhitespace(startPosition, endPosition);
        int paramIndex = this.input.indexOf(40, startPosition);
        if (paramIndex <= 0) {
            this.logError("function-expression", "Expected function", startPosition);
            return ParseResult.error();
        }
        ParseResult<String> functionNameParse = this.parseUnquotedString(startPosition, paramIndex);
        if (!functionNameParse.hasResult()) {
            this.logError("function-expression", "Expected valid function name", startPosition);
            return ParseResult.error();
        }
        return CompositeParser.firstTry(this::parseNoArgs).thenTry(this::parseOneOrMoreArgs).parse(paramIndex, endPosition).mapResult(args -> new FunctionExpression((String)functionNameParse.result(), (List<FunctionArg>)args));
    }

    private ParseResult<List<FunctionArg>> parseNoArgs(int startPosition, int endPosition) {
        startPosition = this.trimLeftWhitespace(startPosition, endPosition);
        endPosition = this.trimRightWhitespace(startPosition, endPosition);
        if (!this.startsWith(startPosition, '(')) {
            this.logError("no-args", "Expected '('", startPosition);
            return ParseResult.error();
        }
        int closePosition = this.trimLeftWhitespace(startPosition + 1, endPosition);
        if (this.input.charAt(closePosition) != ')') {
            this.logError("no-args", "Expected ')'", closePosition);
            return ParseResult.error();
        }
        if (closePosition + 1 != endPosition) {
            this.logError("no-args", "Unexpected character", closePosition + 1);
            return ParseResult.error();
        }
        return ParseResult.success(Collections.emptyList());
    }

    private ParseResult<List<FunctionArg>> parseOneOrMoreArgs(int startPosition, int endPosition) {
        return this.parseMultiSelect(startPosition, endPosition, '(', ')', this::parseFunctionArg);
    }

    private ParseResult<FunctionArg> parseFunctionArg(int startPosition, int endPosition) {
        return CompositeParser.firstTry(this::parseExpression, FunctionArg::expression).thenTry(this::parseExpressionType, FunctionArg::expressionType).parse(startPosition, endPosition);
    }

    private ParseResult<CurrentNode> parseCurrentNode(int startPosition, int endPosition) {
        startPosition = this.trimLeftWhitespace(startPosition, endPosition);
        endPosition = this.trimRightWhitespace(startPosition, endPosition);
        return this.parseExpectedToken("current-node", startPosition, endPosition, '@').mapResult(x -> new CurrentNode());
    }

    private ParseResult<ExpressionType> parseExpressionType(int startPosition, int endPosition) {
        startPosition = this.trimLeftWhitespace(startPosition, endPosition);
        endPosition = this.trimRightWhitespace(startPosition, endPosition);
        if (!this.startsWith(startPosition, '&')) {
            this.logError("expression-type", "Expected '&'", startPosition);
            return ParseResult.error();
        }
        return this.parseExpression(startPosition + 1, endPosition).mapResult(ExpressionType::new);
    }

    private ParseResult<String> parseRawString(int startPosition, int endPosition) {
        if (this.charsInRange(startPosition = this.trimLeftWhitespace(startPosition, endPosition), endPosition = this.trimRightWhitespace(startPosition, endPosition)) < 2) {
            this.logError("raw-string", "Invalid length", startPosition);
            return ParseResult.error();
        }
        if (!this.startsAndEndsWith(startPosition, endPosition, '\'', '\'')) {
            this.logError("raw-string", "Expected opening and closing \"'\"", startPosition);
            return ParseResult.error();
        }
        if (this.charsInRange(startPosition, endPosition) == 2) {
            return ParseResult.success("");
        }
        return this.parseRawStringChars(startPosition + 1, endPosition - 1);
    }

    private ParseResult<String> parseRawStringChars(int startPosition, int endPosition) {
        StringBuilder result = new StringBuilder();
        for (int i = startPosition; i < endPosition; ++i) {
            ParseResult<String> rawStringChar = this.parseLegalRawStringChar(i, i + 1);
            if (rawStringChar.hasResult()) {
                result.append(rawStringChar.result());
                continue;
            }
            ParseResult<String> preservedEscape = this.parsePreservedEscape(i, i + 2);
            if (preservedEscape.hasResult()) {
                result.append(preservedEscape.result());
                ++i;
                continue;
            }
            ParseResult<String> rawStringEscape = this.parseRawStringEscape(i, i + 2);
            if (rawStringEscape.hasResult()) {
                result.append(rawStringEscape.result());
                ++i;
                continue;
            }
            this.logError("raw-string", "Unexpected character", i);
            return ParseResult.error();
        }
        return ParseResult.success(result.toString());
    }

    private ParseResult<String> parseLegalRawStringChar(int startPosition, int endPosition) {
        if (this.charsInRange(startPosition, endPosition) != 1) {
            this.logError("raw-string-chars", "Invalid bounds", startPosition);
            return ParseResult.error();
        }
        if (!this.isLegalRawStringChar(this.input.charAt(startPosition))) {
            this.logError("raw-string-chars", "Invalid character in sequence", startPosition);
            return ParseResult.error();
        }
        return ParseResult.success(this.input.substring(startPosition, endPosition));
    }

    private boolean isLegalRawStringChar(char c) {
        return c >= ' ' && c <= '&' || c >= '(' && c <= '[' || c >= ']';
    }

    private ParseResult<String> parsePreservedEscape(int startPosition, int endPosition) {
        if (endPosition > this.input.length()) {
            this.logError("preserved-escape", "Invalid end position", startPosition);
            return ParseResult.error();
        }
        if (this.charsInRange(startPosition, endPosition) != 2) {
            this.logError("preserved-escape", "Invalid length", startPosition);
            return ParseResult.error();
        }
        if (!this.startsWith(startPosition, '\\')) {
            this.logError("preserved-escape", "Expected \\", startPosition);
            return ParseResult.error();
        }
        return this.parseLegalRawStringChar(startPosition + 1, endPosition).mapResult(v -> "\\" + v);
    }

    private ParseResult<String> parseRawStringEscape(int startPosition, int endPosition) {
        if (endPosition > this.input.length()) {
            this.logError("preserved-escape", "Invalid end position", startPosition);
            return ParseResult.error();
        }
        if (this.charsInRange(startPosition, endPosition) != 2) {
            this.logError("raw-string-escape", "Invalid length", startPosition);
            return ParseResult.error();
        }
        if (!this.startsWith(startPosition, '\\')) {
            this.logError("raw-string-escape", "Expected '\\'", startPosition);
            return ParseResult.error();
        }
        if (this.input.charAt(startPosition + 1) != '\'' && this.input.charAt(startPosition + 1) != '\\') {
            this.logError("raw-string-escape", "Expected \"'\" or \"\\\"", startPosition);
            return ParseResult.error();
        }
        return ParseResult.success(this.input.substring(startPosition, endPosition));
    }

    private ParseResult<Literal> parseLiteral(int startPosition, int endPosition) {
        if (this.charsInRange(startPosition = this.trimLeftWhitespace(startPosition, endPosition), endPosition = this.trimRightWhitespace(startPosition, endPosition)) < 2) {
            this.logError("literal", "Invalid bounds", startPosition);
            return ParseResult.error();
        }
        if (!this.startsAndEndsWith(startPosition, endPosition, '`', '`')) {
            this.logError("literal", "Expected opening and closing '`'", startPosition);
            return ParseResult.error();
        }
        StringBuilder jsonString = new StringBuilder();
        for (int i = startPosition + 1; i < endPosition - 1; ++i) {
            char character = this.input.charAt(i);
            if (character == '`') {
                int lastChar = i - 1;
                if (lastChar <= 0) {
                    this.logError("literal", "Unexpected '`'", startPosition);
                    return ParseResult.error();
                }
                int escapeCount = 0;
                for (int j = i - 1; j >= startPosition && this.input.charAt(j) == '\\'; --j) {
                    ++escapeCount;
                }
                if (escapeCount % 2 == 0) {
                    this.logError("literal", "Unescaped '`'", startPosition);
                    return ParseResult.error();
                }
                jsonString.setLength(jsonString.length() - 1);
                jsonString.append('`');
                continue;
            }
            jsonString.append(character);
        }
        try {
            return ParseResult.success(new Literal(Jackson.readJrsValue(jsonString.toString())));
        }
        catch (IOException e) {
            this.logError("literal", "Invalid JSON: " + e.getMessage(), startPosition);
            return ParseResult.error();
        }
    }

    private ParseResult<Integer> parseNumber(int startPosition, int endPosition) {
        startPosition = this.trimLeftWhitespace(startPosition, endPosition);
        endPosition = this.trimRightWhitespace(startPosition, endPosition);
        if (this.startsWith(startPosition, '-')) {
            return this.parseNonNegativeNumber(startPosition + 1, endPosition).mapResult(i -> -i.intValue());
        }
        return this.parseNonNegativeNumber(startPosition, endPosition);
    }

    private ParseResult<Integer> parseNonNegativeNumber(int startPosition, int endPosition) {
        if (this.charsInRange(startPosition = this.trimLeftWhitespace(startPosition, endPosition), endPosition = this.trimRightWhitespace(startPosition, endPosition)) < 1) {
            this.logError("number", "Expected number", startPosition);
            return ParseResult.error();
        }
        try {
            return ParseResult.success(Integer.parseInt(this.input.substring(startPosition, endPosition)));
        }
        catch (NumberFormatException e) {
            this.logError("number", "Expected number", startPosition);
            return ParseResult.error();
        }
    }

    private ParseResult<String> parseIdentifier(int startPosition, int endPosition) {
        return CompositeParser.firstTry(this::parseUnquotedString).thenTry(this::parseQuotedString).parse(startPosition, endPosition);
    }

    private ParseResult<String> parseUnquotedString(int startPosition, int endPosition) {
        if (this.charsInRange(startPosition = this.trimLeftWhitespace(startPosition, endPosition), endPosition = this.trimRightWhitespace(startPosition, endPosition)) < 1) {
            this.logError("unquoted-string", "Invalid unquoted-string", startPosition);
            return ParseResult.error();
        }
        char firstToken = this.input.charAt(startPosition);
        if (!Character.isLetter(firstToken) && firstToken != '_') {
            this.logError("unquoted-string", "Unescaped strings must start with [A-Za-z_]", startPosition);
            return ParseResult.error();
        }
        for (int i = startPosition; i < endPosition; ++i) {
            char c = this.input.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            this.logError("unquoted-string", "Invalid character in unescaped-string", i);
            return ParseResult.error();
        }
        return ParseResult.success(this.input.substring(startPosition, endPosition));
    }

    private ParseResult<String> parseQuotedString(int startPosition, int endPosition) {
        if (!this.startsAndEndsWith(startPosition = this.trimLeftWhitespace(startPosition, endPosition), endPosition = this.trimRightWhitespace(startPosition, endPosition), '\"', '\"')) {
            this.logError("quoted-string", "Expected opening and closing '\"'", startPosition);
            return ParseResult.error();
        }
        int stringStart = startPosition + 1;
        int stringEnd = endPosition - 1;
        int stringTokenCount = this.charsInRange(stringStart, stringEnd);
        if (stringTokenCount < 1) {
            this.logError("quoted-string", "Invalid quoted-string", startPosition);
            return ParseResult.error();
        }
        StringBuilder result = new StringBuilder();
        for (int i = stringStart; i < stringEnd; ++i) {
            ParseResult<String> unescapedChar = this.parseUnescapedChar(i, i + 1);
            if (unescapedChar.hasResult()) {
                result.append(unescapedChar.result());
                continue;
            }
            ParseResult<String> escapedChar = this.parseEscapedChar(i, i + 2);
            if (escapedChar.hasResult()) {
                result.append(escapedChar.result());
                ++i;
                continue;
            }
            ParseResult<String> escapedUnicodeSequence = this.parseEscapedUnicodeSequence(i, i + 6);
            if (escapedUnicodeSequence.hasResult()) {
                result.append(escapedUnicodeSequence.result());
                i += 5;
                continue;
            }
            if (this.input.charAt(i) == '\\') {
                this.logError("quoted-string", "Unsupported escape sequence", i);
            } else {
                this.logError("quoted-string", "Unexpected character", i);
            }
            return ParseResult.error();
        }
        return ParseResult.success(result.toString());
    }

    private ParseResult<String> parseUnescapedChar(int startPosition, int endPosition) {
        for (int i = startPosition; i < endPosition; ++i) {
            if (this.isLegalUnescapedChar(this.input.charAt(i))) continue;
            this.logError("unescaped-char", "Invalid character in sequence", startPosition);
            return ParseResult.error();
        }
        return ParseResult.success(this.input.substring(startPosition, endPosition));
    }

    private boolean isLegalUnescapedChar(char c) {
        return c >= ' ' && c <= '!' || c >= '#' && c <= '[' || c >= ']';
    }

    private ParseResult<String> parseEscapedChar(int startPosition, int endPosition) {
        if (endPosition > this.input.length()) {
            this.logError("escaped-char", "Invalid end position", startPosition);
            return ParseResult.error();
        }
        if (this.charsInRange(startPosition, endPosition) != 2) {
            this.logError("escaped-char", "Invalid length", startPosition);
            return ParseResult.error();
        }
        if (!this.startsWith(startPosition, '\\')) {
            this.logError("escaped-char", "Expected '\\'", startPosition);
            return ParseResult.error();
        }
        char escapedChar = this.input.charAt(startPosition + 1);
        switch (escapedChar) {
            case '\"': {
                return ParseResult.success("\"");
            }
            case '\\': {
                return ParseResult.success("\\");
            }
            case '/': {
                return ParseResult.success("/");
            }
            case 'b': {
                return ParseResult.success("\b");
            }
            case 'f': {
                return ParseResult.success("\f");
            }
            case 'n': {
                return ParseResult.success("\n");
            }
            case 'r': {
                return ParseResult.success("\r");
            }
            case 't': {
                return ParseResult.success("\t");
            }
        }
        this.logError("escaped-char", "Invalid escape sequence", startPosition);
        return ParseResult.error();
    }

    private ParseResult<String> parseEscapedUnicodeSequence(int startPosition, int endPosition) {
        char unicodeChar;
        if (endPosition > this.input.length()) {
            this.logError("escaped-unicode-sequence", "Invalid end position", startPosition);
            return ParseResult.error();
        }
        if (this.charsInRange(startPosition, endPosition) != 6) {
            this.logError("escaped-unicode-sequence", "Invalid length", startPosition);
            return ParseResult.error();
        }
        if (this.input.charAt(startPosition) != '\\') {
            this.logError("escaped-unicode-sequence", "Expected '\\'", startPosition);
            return ParseResult.error();
        }
        char escapedChar = this.input.charAt(startPosition + 1);
        if (escapedChar != 'u') {
            this.logError("escaped-unicode-sequence", "Invalid escape sequence", startPosition);
            return ParseResult.error();
        }
        String unicodePattern = this.input.substring(startPosition + 2, startPosition + 2 + 4);
        try {
            unicodeChar = (char)Integer.parseInt(unicodePattern, 16);
        }
        catch (NumberFormatException e) {
            this.logError("escaped-unicode-sequence", "Invalid unicode hex sequence", startPosition);
            return ParseResult.error();
        }
        return ParseResult.success(String.valueOf(unicodeChar));
    }

    private ParseResult<WildcardExpression> parseWildcardExpression(int startPosition, int endPosition) {
        return this.parseExpectedToken("star-expression", startPosition, endPosition, '*').mapResult(v -> new WildcardExpression());
    }

    private int charsInRange(int startPosition, int endPosition) {
        return endPosition - startPosition;
    }

    private List<Integer> findCharacters(int startPosition, int endPosition, String symbol) {
        int match;
        ArrayList<Integer> results = new ArrayList<Integer>();
        int start = startPosition;
        while ((match = this.input.indexOf(symbol, start)) >= 0 && match < endPosition) {
            results.add(match);
            start = match + 1;
        }
        return results;
    }

    private ParseResult<Character> parseExpectedToken(String parser, int startPosition, int endPosition, char expectedToken) {
        if (this.input.charAt(startPosition) != expectedToken) {
            this.logError(parser, "Expected '" + expectedToken + "'", startPosition);
            return ParseResult.error();
        }
        if (this.charsInRange(startPosition, endPosition) != 1) {
            this.logError(parser, "Unexpected character", startPosition + 1);
            return ParseResult.error();
        }
        return ParseResult.success(Character.valueOf(expectedToken));
    }

    private int trimLeftWhitespace(int startPosition, int endPosition) {
        while (this.input.charAt(startPosition) == ' ' && startPosition < endPosition - 1) {
            ++startPosition;
        }
        return startPosition;
    }

    private int trimRightWhitespace(int startPosition, int endPosition) {
        while (this.input.charAt(endPosition - 1) == ' ' && startPosition < endPosition - 1) {
            --endPosition;
        }
        return endPosition;
    }

    private boolean startsWith(int startPosition, char character) {
        return this.input.charAt(startPosition) == character;
    }

    private boolean endsWith(int endPosition, char character) {
        return this.input.charAt(endPosition - 1) == character;
    }

    private boolean startsAndEndsWith(int startPosition, int endPosition, char startChar, char endChar) {
        return this.startsWith(startPosition, startChar) && this.endsWith(endPosition, endChar);
    }

    private void logError(String parser, String message, int position) {
        log.debug(() -> parser + " at " + position + ": " + message);
    }
}

