/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.transform;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.transform.protocols.EventStreamJsonMarshallerSpec;
import software.amazon.awssdk.codegen.poet.transform.protocols.JsonMarshallerSpec;
import software.amazon.awssdk.codegen.poet.transform.protocols.MarshallerProtocolSpec;
import software.amazon.awssdk.codegen.poet.transform.protocols.QueryMarshallerSpec;
import software.amazon.awssdk.codegen.poet.transform.protocols.XmlMarshallerSpec;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.utils.Validate;

public class MarshallerSpec
implements ClassSpec {
    private final IntermediateModel intermediateModel;
    private final ShapeModel shapeModel;
    private final ClassName baseMashallerName;
    private final TypeName httpRequestName;
    private final ClassName requestName;
    private final ClassName className;
    private final ClassName requestClassName;
    private final MarshallerProtocolSpec protocolSpec;

    public MarshallerSpec(IntermediateModel intermediateModel, ShapeModel shapeModel) {
        this.intermediateModel = intermediateModel;
        this.shapeModel = shapeModel;
        String modelPackage = intermediateModel.getMetadata().getFullModelPackageName();
        this.baseMashallerName = ClassName.get(Marshaller.class);
        this.httpRequestName = ClassName.get(SdkHttpFullRequest.class);
        this.requestName = ClassName.get((String)modelPackage, (String)shapeModel.getShapeName(), (String[])new String[0]);
        this.className = new PoetExtensions(intermediateModel).getRequestTransformClass(shapeModel.getShapeName() + "Marshaller");
        this.requestClassName = ClassName.get((String)modelPackage, (String)shapeModel.getShapeName(), (String[])new String[0]);
        this.protocolSpec = this.getProtocolSpecs(intermediateModel.getMetadata().getProtocol());
    }

    @Override
    public TypeSpec poetSpec() {
        return TypeSpec.classBuilder((ClassName)this.className).addJavadoc("{@link $T} Marshaller", new Object[]{this.requestClassName}).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(PoetUtils.generatedAnnotation()).addAnnotation(SdkInternalApi.class).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)this.baseMashallerName, (TypeName[])new TypeName[]{this.requestName})).addFields(this.protocolSpec.memberVariables()).addFields(this.protocolSpec.additionalFields()).addMethods(this.methods()).build();
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    private List<MethodSpec> methods() {
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        this.protocolSpec.constructor().ifPresent(methodSpecs::add);
        methodSpecs.add(this.marshallMethod());
        methodSpecs.addAll(this.protocolSpec.additionalMethods());
        return methodSpecs;
    }

    private MethodSpec marshallMethod() {
        String variableName = this.shapeModel.getVariable().getVariableName();
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)"marshall").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.requestClassName, variableName, new Modifier[0]).returns(this.httpRequestName);
        methodSpecBuilder.addStatement("$T.paramNotNull($L, $S)", new Object[]{ClassName.get(Validate.class), variableName, variableName});
        methodSpecBuilder.beginControlFlow("try", new Object[0]);
        methodSpecBuilder.addCode(this.protocolSpec.marshalCodeBlock(this.requestClassName));
        methodSpecBuilder.endControlFlow();
        methodSpecBuilder.beginControlFlow("catch (Exception e)", new Object[0]);
        methodSpecBuilder.addStatement("throw $T.builder().message(\"Unable to marshall request to JSON: \" + e.getMessage()).cause(e).build()", new Object[]{ClassName.get(SdkClientException.class)});
        methodSpecBuilder.endControlFlow();
        return methodSpecBuilder.build();
    }

    private MarshallerProtocolSpec getProtocolSpecs(Protocol protocol) {
        switch (protocol) {
            case REST_JSON: 
            case CBOR: 
            case ION: 
            case AWS_JSON: {
                return this.getJsonMarshallerSpec();
            }
            case QUERY: 
            case EC2: {
                return new QueryMarshallerSpec(this.intermediateModel, this.shapeModel);
            }
            case REST_XML: {
                return new XmlMarshallerSpec(this.intermediateModel, this.shapeModel);
            }
        }
        throw new RuntimeException("Unknown protocol: " + protocol.name());
    }

    private MarshallerProtocolSpec getJsonMarshallerSpec() {
        if (this.shapeModel.isEvent()) {
            return new EventStreamJsonMarshallerSpec(this.intermediateModel, this.shapeModel);
        }
        return new JsonMarshallerSpec(this.shapeModel);
    }
}

