/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import software.amazon.awssdk.utils.StringUtils;

public enum AuthType {
    NONE("none"),
    CUSTOM("custom"),
    IAM("iam"),
    V4("v4"),
    V4_UNSIGNED_BODY("v4-unsigned-body"),
    S3("s3"),
    S3V4("s3v4");

    private final String value;

    private AuthType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static AuthType fromValue(String value) {
        String normalizedValue = StringUtils.lowerCase((String)value);
        return Arrays.stream(AuthType.values()).filter(authType -> authType.value.equals(normalizedValue)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unknown AuthType '%s'", normalizedValue)));
    }
}

