/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters;

import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskExecutor;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public class CodeEmitter
implements SdkAutoCloseable {
    private final Iterable<GeneratorTask> generatorTasks;
    private final GeneratorTaskExecutor taskExecutor;

    public CodeEmitter(Iterable<GeneratorTask> generatorTasks, GeneratorTaskExecutor taskExecutor) {
        this.generatorTasks = generatorTasks;
        this.taskExecutor = taskExecutor;
    }

    public void emit() {
        this.generatorTasks.forEach(this.taskExecutor::submit);
    }

    public void close() {
        FunctionalUtils.invokeSafely(this.taskExecutor::waitForCompletion);
        this.taskExecutor.shutdown();
    }
}

