/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.eventstream;

import java.util.Objects;
import java.util.stream.Stream;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;

public class EventStreamUtils {
    private EventStreamUtils() {
    }

    public static ShapeModel getEventStreamInRequest(ShapeModel requestShape) {
        return EventStreamUtils.eventStreamFrom(requestShape);
    }

    public static ShapeModel getEventStreamInResponse(ShapeModel responseShape) {
        return EventStreamUtils.eventStreamFrom(responseShape);
    }

    private static ShapeModel eventStreamFrom(ShapeModel shapeModel) {
        if (shapeModel == null || shapeModel.getMembers() == null) {
            return null;
        }
        return shapeModel.getMembers().stream().map(MemberModel::getShape).filter(Objects::nonNull).filter(ShapeModel::isEventStream).findFirst().orElseThrow(() -> new IllegalStateException(String.format("%s has no event stream member", shapeModel.getC2jName())));
    }

    public static ShapeModel getBaseEventStreamShape(IntermediateModel model, ShapeModel eventShape) {
        return model.getShapes().values().stream().filter(ShapeModel::isEventStream).filter(s -> s.getMembers().stream().anyMatch(m -> m.getShape().equals(eventShape))).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Event shape %s not referenced in model by any eventstream shape", eventShape.getC2jName())));
    }

    public static Stream<ShapeModel> getEvents(ShapeModel eventStreamShape) {
        return EventStreamUtils.getEventMembers(eventStreamShape).map(MemberModel::getShape);
    }

    public static Stream<MemberModel> getEventMembers(ShapeModel eventStreamShape) {
        if (eventStreamShape == null || eventStreamShape.getMembers() == null) {
            return Stream.empty();
        }
        return eventStreamShape.getMembers().stream().filter(m -> m.getShape() != null && m.getShape().isEvent());
    }

    public static OperationModel findOperationWithEventStream(IntermediateModel model, ShapeModel eventStreamShape) {
        return model.getOperations().values().stream().filter(op -> EventStreamUtils.operationContainsEventStream(op, eventStreamShape)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("%s is an event shape but has no corresponding operation in the model", eventStreamShape.getC2jName())));
    }

    public static boolean doesShapeContainsEventStream(ShapeModel parentShape, ShapeModel childEventStreamShape) {
        return parentShape != null && parentShape.getMembers() != null && parentShape.getMembers().stream().filter(m -> m.getShape() != null).filter(m -> m.getShape().equals(childEventStreamShape)).anyMatch(m -> m.getShape().isEventStream());
    }

    public static boolean isRequestEvent(IntermediateModel model, ShapeModel eventShape) {
        try {
            ShapeModel eventStreamShape = EventStreamUtils.getBaseEventStreamShape(model, eventShape);
            return model.getOperations().values().stream().anyMatch(o -> EventStreamUtils.doesShapeContainsEventStream(o.getInputShape(), eventStreamShape));
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    private static boolean operationContainsEventStream(OperationModel opModel, ShapeModel eventStreamShape) {
        return EventStreamUtils.doesShapeContainsEventStream(opModel.getInputShape(), eventStreamShape) || EventStreamUtils.doesShapeContainsEventStream(opModel.getOutputShape(), eventStreamShape);
    }

    public static boolean isEventStreamParentModel(ShapeModel shapeModel) {
        return EventStreamUtils.containsEventStream(shapeModel);
    }

    private static boolean containsEventStream(ShapeModel shapeModel) {
        return shapeModel != null && shapeModel.getMembers() != null && shapeModel.getMembers().stream().filter(m -> m.getShape() != null).anyMatch(m -> m.getShape().isEventStream());
    }
}

