/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.SimpleGeneratorTask;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;

public final class PackageInfoGeneratorTasks
extends BaseGeneratorTasks {
    private final String baseDirectory;

    PackageInfoGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.baseDirectory = dependencies.getPathProvider().getClientDirectory();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        Metadata metadata = this.model.getMetadata();
        String packageInfoContents = String.format("/**%n * %s%n*/%npackage %s;", metadata.getDocumentation(), metadata.getFullClientPackageName());
        this.info("Emitting package info file");
        return Collections.singletonList(new SimpleGeneratorTask(this.baseDirectory, "package-info.java", this.model.getFileHeader(), packageInfoContents));
    }
}

