/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import software.amazon.awssdk.codegen.emitters.CodeTransformer;
import software.amazon.awssdk.codegen.emitters.JavaCodeFormatter;
import software.amazon.awssdk.codegen.emitters.LinkRemover;
import software.amazon.awssdk.codegen.emitters.UnusedImportRemover;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.utils.StringUtils;

public class CodeWriter
extends StringWriter {
    private final CodeTransformer codeWriteTransformer = CodeTransformer.chain(new UnusedImportRemover(), new JavaCodeFormatter());
    private final CodeTransformer codeComparisonTransformer = new LinkRemover();
    private final String dir;
    private final String file;

    public CodeWriter(String dir, String file) {
        this(dir, file, ".java");
    }

    public CodeWriter(String dir, String file, String fileNameSuffix) {
        if (dir == null) {
            throw new IllegalArgumentException("Output Directory cannot be null.");
        }
        if (file == null) {
            throw new IllegalArgumentException("File name cannot be null.");
        }
        if (fileNameSuffix == null) {
            throw new IllegalArgumentException("File name suffix cannot be null.");
        }
        if (!file.endsWith(fileNameSuffix)) {
            file = file + fileNameSuffix;
        }
        this.dir = dir;
        this.file = file;
        Utils.createDirectory(dir);
    }

    @Override
    public void flush() {
        PrintWriter out;
        block5: {
            out = null;
            try {
                File outputFile = Utils.createFile(this.dir, this.file);
                String contents = this.getBuffer().toString();
                String formattedContents = this.codeWriteTransformer.apply(contents);
                if (outputFile.length() == 0L) {
                    out = new PrintWriter(outputFile, "UTF-8");
                    out.write(formattedContents);
                    break block5;
                }
                this.validateFileContentMatches(outputFile, formattedContents);
            }
            catch (IOException e) {
                try {
                    throw new IllegalStateException(e);
                }
                catch (Throwable throwable) {
                    Utils.closeQuietly(out);
                    throw throwable;
                }
            }
        }
        Utils.closeQuietly(out);
    }

    private void validateFileContentMatches(File outputFile, String newFileContents) throws IOException {
        String newContentForComparison;
        byte[] currentFileBytes = Files.readAllBytes(outputFile.toPath());
        String currentFileContents = new String(currentFileBytes, StandardCharsets.UTF_8);
        String currentContentForComparison = this.codeComparisonTransformer.apply(currentFileContents);
        if (!StringUtils.equals((String)currentContentForComparison, (String)(newContentForComparison = this.codeComparisonTransformer.apply(newFileContents)))) {
            throw new IllegalStateException("Attempted to clobber existing file (" + outputFile + ") with a new file that has different content. This may indicate forgetting to clean up old generated files before running the generator?\nExisting file: \n" + currentContentForComparison + "\n\nNew file: \n" + newContentForComparison);
        }
    }
}

