/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;

class ShapeModelSpec {
    private final ShapeModel shapeModel;
    private final TypeProvider typeProvider;
    private final PoetExtensions poetExtensions;

    ShapeModelSpec(ShapeModel shapeModel, TypeProvider typeProvider, PoetExtensions poetExtensions) {
        this.shapeModel = shapeModel;
        this.typeProvider = typeProvider;
        this.poetExtensions = poetExtensions;
    }

    ClassName className() {
        return this.poetExtensions.getModelClass(this.shapeModel.getShapeName());
    }

    public List<FieldSpec> fields() {
        return this.fields(Modifier.PRIVATE, Modifier.FINAL);
    }

    public List<FieldSpec> fields(Modifier ... modifiers) {
        return this.shapeModel.getNonStreamingMembers().stream().filter(m -> m.getShape() == null || m.getShape().getShapeType() != ShapeType.Exception).map(m -> this.typeProvider.asField((MemberModel)m, modifiers)).collect(Collectors.toList());
    }
}

