/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.eventstream;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.function.Supplier;
import javax.lang.model.element.Modifier;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.awscore.eventstream.EventStreamResponseHandler;
import software.amazon.awssdk.codegen.docs.DocumentationBuilder;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamUtils;

public class EventStreamResponseHandlerBuilderInterfaceSpec
implements ClassSpec {
    final EventStreamUtils eventStreamUtils;
    private final ClassName responsePojoType;
    private final ClassName responseHandlerType;

    EventStreamResponseHandlerBuilderInterfaceSpec(EventStreamUtils eventStreamUtils) {
        this.eventStreamUtils = eventStreamUtils;
        this.responsePojoType = eventStreamUtils.responsePojoType();
        this.responseHandlerType = eventStreamUtils.responseHandlerType();
    }

    @Override
    public final TypeSpec poetSpec() {
        return this.createTypeSpecBuilder().addMethod(this.applySubscriberMethodSpecUpdates(this.createSubscriberMethodSpecBuilder()).build()).addMethod(this.applyBuildMethodSpecUpdates(this.createBuildMethodSpecBuilder()).build()).build();
    }

    protected TypeSpec.Builder createTypeSpecBuilder() {
        ParameterizedTypeName superBuilderInterface = ParameterizedTypeName.get((ClassName)ClassName.get(EventStreamResponseHandler.class).nestedClass("Builder"), (TypeName[])new TypeName[]{this.responsePojoType, this.eventStreamUtils.eventStreamBaseClass(), this.className()});
        return PoetUtils.createInterfaceBuilder(this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addJavadoc("Builder for {@link $1T}. This can be used to create the {@link $1T} in a more functional way, you may also directly implement the {@link $1T} interface if preferred.", new Object[]{this.responseHandlerType}).addSuperinterface((TypeName)superBuilderInterface);
    }

    protected MethodSpec.Builder applySubscriberMethodSpecUpdates(MethodSpec.Builder builder) {
        String javadocs = new DocumentationBuilder().description("Sets the subscriber to the {@link $T} of events. The given {@link $T} will be called for each event received by the publisher. Events are requested sequentially after each event is processed. If you need more control over the backpressure strategy consider using {@link #subscriber($T)} instead.").param("visitor", "Visitor that will be invoked for each incoming event.").returns("This builder for method chaining").build();
        ClassName visitorInterface = this.eventStreamUtils.responseHandlerVisitorType();
        return builder.addModifiers(new Modifier[]{Modifier.ABSTRACT}).addJavadoc(javadocs, new Object[]{Publisher.class, visitorInterface, Supplier.class});
    }

    private MethodSpec.Builder createSubscriberMethodSpecBuilder() {
        ClassName visitorInterface = this.eventStreamUtils.responseHandlerVisitorType();
        return MethodSpec.methodBuilder((String)"subscriber").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)visitorInterface, (String)"visitor", (Modifier[])new Modifier[0]).build()).returns((TypeName)this.eventStreamUtils.responseHandlerBuilderType());
    }

    protected MethodSpec.Builder applyBuildMethodSpecUpdates(MethodSpec.Builder builder) {
        return builder.addModifiers(new Modifier[]{Modifier.ABSTRACT}).addJavadoc("@return A {@link $T} implementation that can be used in the $L API call.", new Object[]{this.responseHandlerType, this.eventStreamUtils.getApiName()});
    }

    private MethodSpec.Builder createBuildMethodSpecBuilder() {
        return MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.responseHandlerType);
    }

    @Override
    public ClassName className() {
        return this.eventStreamUtils.responseHandlerBuilderType();
    }
}

