/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.codegen.model.intermediate.ExceptionModel;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ReturnTypeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.VariableModel;

final class RemoveUnusedShapes {
    private RemoveUnusedShapes() {
    }

    public static Map<String, ShapeModel> removeUnusedShapes(IntermediateModel model) {
        HashMap<String, ShapeModel> out = new HashMap<String, ShapeModel>();
        Map<String, ShapeModel> in = model.getShapes();
        for (OperationModel opModel : model.getOperations().values()) {
            RemoveUnusedShapes.addOperationShapes(opModel, in, out);
        }
        return out;
    }

    private static void addOperationShapes(OperationModel op, Map<String, ShapeModel> in, Map<String, ShapeModel> out) {
        ReturnTypeModel output;
        VariableModel input = op.getInput();
        if (input != null) {
            RemoveUnusedShapes.addShapeAndMembers(input.getSimpleType(), in, out);
        }
        if ((output = op.getReturnType()) != null) {
            RemoveUnusedShapes.addShapeAndMembers(output.getReturnType(), in, out);
        }
        List<ExceptionModel> exceptions = op.getExceptions();
        if (op.getExceptions() != null) {
            for (ExceptionModel e : exceptions) {
                RemoveUnusedShapes.addShapeAndMembers(e.getExceptionName(), in, out);
            }
        }
    }

    private static void addShapeAndMembers(String shapeName, Map<String, ShapeModel> in, Map<String, ShapeModel> out) {
        if (shapeName == null) {
            return;
        }
        ShapeModel shape = in.get(shapeName);
        if (shape == null) {
            return;
        }
        if (!out.containsKey(shapeName)) {
            out.put(shapeName, in.get(shapeName));
            List<MemberModel> members = shape.getMembers();
            if (members != null) {
                for (MemberModel member : members) {
                    List<String> memberShapes = RemoveUnusedShapes.resolveMemberShapes(member);
                    if (memberShapes == null) continue;
                    for (String memberShape : memberShapes) {
                        RemoveUnusedShapes.addShapeAndMembers(memberShape, in, out);
                    }
                }
            }
        }
    }

    private static List<String> resolveMemberShapes(MemberModel member) {
        if (member == null) {
            return new LinkedList<String>();
        }
        if (member.getEnumType() != null) {
            return Collections.singletonList(member.getEnumType());
        }
        if (member.isList()) {
            return RemoveUnusedShapes.resolveMemberShapes(member.getListModel().getListMemberModel());
        }
        if (member.isMap()) {
            LinkedList<String> memberShapes = new LinkedList<String>();
            memberShapes.addAll(RemoveUnusedShapes.resolveMemberShapes(member.getMapModel().getKeyModel()));
            memberShapes.addAll(RemoveUnusedShapes.resolveMemberShapes(member.getMapModel().getValueModel()));
            return memberShapes;
        }
        if (member.isSimple()) {
            return new LinkedList<String>();
        }
        return Collections.singletonList(member.getVariable().getSimpleType());
    }
}

