/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.builder;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.List;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.QueryStringSigner;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.service.AuthType;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.StringUtils;

public class BaseClientBuilderClass
implements ClassSpec {
    private final IntermediateModel model;
    private final ClassName builderInterfaceName;
    private final ClassName builderClassName;
    private final String basePackage;

    public BaseClientBuilderClass(IntermediateModel model) {
        this.model = model;
        this.basePackage = model.getMetadata().getFullClientPackageName();
        this.builderInterfaceName = ClassName.get((String)this.basePackage, (String)model.getMetadata().getBaseBuilderInterface(), (String[])new String[0]);
        this.builderClassName = ClassName.get((String)this.basePackage, (String)model.getMetadata().getBaseBuilder(), (String[])new String[0]);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = PoetUtils.createClassBuilder(this.builderClassName).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addAnnotation(SdkInternalApi.class).addTypeVariable(PoetUtils.createBoundedTypeVariableName("B", this.builderInterfaceName, "B", "C")).addTypeVariable(TypeVariableName.get((String)"C")).superclass((TypeName)PoetUtils.createParameterizedTypeName(AwsDefaultClientBuilder.class, "B", "C")).addJavadoc("Internal base class for {@link $T} and {@link $T}.", new Object[]{ClassName.get((String)this.basePackage, (String)this.model.getMetadata().getSyncBuilder(), (String[])new String[0]), ClassName.get((String)this.basePackage, (String)this.model.getMetadata().getAsyncBuilder(), (String[])new String[0])});
        builder.addMethod(this.serviceEndpointPrefixMethod());
        builder.addMethod(this.mergeServiceDefaultsMethod());
        builder.addMethod(this.finalizeServiceConfigurationMethod());
        builder.addMethod(this.defaultSignerMethod());
        builder.addMethod(this.signingNameMethod());
        if (this.model.getCustomizationConfig().getServiceSpecificClientConfigClass() != null) {
            builder.addMethod(this.setServiceConfigurationMethod()).addMethod(this.beanStyleSetServiceConfigurationMethod());
        }
        if (this.model.getCustomizationConfig().getServiceSpecificHttpConfig() != null) {
            builder.addMethod(this.serviceSpecificHttpConfigMethod());
        } else if (this.model.getMetadata().supportsH2()) {
            builder.addMethod(this.enableH2HttpConfigMethod());
        }
        return builder.build();
    }

    private MethodSpec signingNameMethod() {
        return MethodSpec.methodBuilder((String)"signingName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(String.class).addCode("return $S;", new Object[]{this.model.getMetadata().getSigningName()}).build();
    }

    private MethodSpec defaultSignerMethod() {
        return MethodSpec.methodBuilder((String)"defaultSigner").returns(Signer.class).addModifiers(new Modifier[]{Modifier.PRIVATE}).addCode(this.signerDefinitionMethodBody()).build();
    }

    private MethodSpec serviceEndpointPrefixMethod() {
        return MethodSpec.methodBuilder((String)"serviceEndpointPrefix").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(String.class).addCode("return $S;", new Object[]{this.model.getMetadata().getEndpointPrefix()}).build();
    }

    private MethodSpec mergeServiceDefaultsMethod() {
        boolean crc32FromCompressedDataEnabled = this.model.getCustomizationConfig().isCalculateCrc32FromCompressedData();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"mergeServiceDefaults").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(SdkClientConfiguration.class).addParameter(SdkClientConfiguration.class, "config", new Modifier[0]).addCode("return config.merge(c -> c.option($T.SIGNER, defaultSigner())\n", new Object[]{SdkAdvancedClientOption.class}).addCode("                          .option($T.CRC32_FROM_COMPRESSED_DATA_ENABLED, $L)", new Object[]{SdkClientOption.class, crc32FromCompressedDataEnabled});
        if (StringUtils.isNotBlank((CharSequence)this.model.getCustomizationConfig().getCustomRetryPolicy())) {
            builder.addCode(".option($T.RETRY_POLICY, $T.defaultPolicy())", new Object[]{SdkClientOption.class, PoetUtils.classNameFromFqcn(this.model.getCustomizationConfig().getCustomRetryPolicy())});
        }
        builder.addCode(");", new Object[0]);
        return builder.build();
    }

    private MethodSpec finalizeServiceConfigurationMethod() {
        String requestHandlerDirectory = Utils.packageToDirectory(this.model.getMetadata().getFullClientPackageName());
        String requestHandlerPath = String.format("%s/execution.interceptors", requestHandlerDirectory);
        return MethodSpec.methodBuilder((String)"finalizeServiceConfiguration").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(SdkClientConfiguration.class).addParameter(SdkClientConfiguration.class, "config", new Modifier[0]).addCode("$1T interceptorFactory = new $1T();\n", new Object[]{ClasspathInterceptorChainFactory.class}).addCode("$T<$T> interceptors = interceptorFactory.getInterceptors($S);\n", new Object[]{List.class, ExecutionInterceptor.class, requestHandlerPath}).addCode("interceptors = $T.mergeLists(interceptors, config.option($T.EXECUTION_INTERCEPTORS));\n", new Object[]{CollectionUtils.class, SdkClientOption.class}).addCode("return config.toBuilder()\n             .option($T.EXECUTION_INTERCEPTORS, interceptors)\n             .build();", new Object[]{SdkClientOption.class}).build();
    }

    private MethodSpec setServiceConfigurationMethod() {
        ClassName serviceConfiguration = ClassName.get((String)this.basePackage, (String)this.model.getCustomizationConfig().getServiceSpecificClientConfigClass(), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"serviceConfiguration").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeVariableName.get((String)"B")).addParameter((TypeName)serviceConfiguration, "serviceConfiguration", new Modifier[0]).addStatement("clientConfiguration.option($T.SERVICE_CONFIGURATION, serviceConfiguration)", new Object[]{SdkClientOption.class}).addStatement("return thisBuilder()", new Object[0]).build();
    }

    private MethodSpec beanStyleSetServiceConfigurationMethod() {
        ClassName serviceConfiguration = ClassName.get((String)this.basePackage, (String)this.model.getCustomizationConfig().getServiceSpecificClientConfigClass(), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"setServiceConfiguration").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)serviceConfiguration, "serviceConfiguration", new Modifier[0]).addStatement("serviceConfiguration(serviceConfiguration)", new Object[0]).build();
    }

    private MethodSpec serviceSpecificHttpConfigMethod() {
        return MethodSpec.methodBuilder((String)"serviceHttpConfig").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(AttributeMap.class).addCode("return $L;", new Object[]{this.model.getCustomizationConfig().getServiceSpecificHttpConfig()}).build();
    }

    private MethodSpec enableH2HttpConfigMethod() {
        return MethodSpec.methodBuilder((String)"serviceHttpConfig").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(AttributeMap.class).addCode("return $T.builder()\n.put($T.PROTOCOL, $T.HTTP2)\n.build();", new Object[]{AttributeMap.class, SdkHttpConfigurationOption.class, Protocol.class}).build();
    }

    private CodeBlock signerDefinitionMethodBody() {
        AuthType authType = this.model.getMetadata().getAuthType();
        switch (authType) {
            case V4: {
                return this.v4SignerDefinitionMethodBody();
            }
            case V2: {
                return this.v2SignerDefinitionMethodBody();
            }
            case S3: {
                return this.s3SignerDefinitionMethodBody();
            }
        }
        throw new UnsupportedOperationException("Unsupported signer type: " + (Object)((Object)authType));
    }

    private CodeBlock v4SignerDefinitionMethodBody() {
        return CodeBlock.of((String)"return $T.create();", (Object[])new Object[]{Aws4Signer.class});
    }

    private CodeBlock v2SignerDefinitionMethodBody() {
        return CodeBlock.of((String)"return $T.create();", (Object[])new Object[]{QueryStringSigner.class});
    }

    private CodeBlock s3SignerDefinitionMethodBody() {
        return CodeBlock.of((String)"return $T.create();\n", (Object[])new Object[]{ClassName.get((String)"software.amazon.awssdk.auth.signer", (String)"AwsS3V4Signer", (String[])new String[0])});
    }

    @Override
    public ClassName className() {
        return this.builderClassName;
    }
}

