/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.MapModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.StaticImport;
import software.amazon.awssdk.codegen.poet.model.ServiceModelCopiers;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;

class MemberCopierSpec
implements ClassSpec {
    private final MemberModel memberModel;
    private final ServiceModelCopiers serviceModelCopiers;
    private final TypeProvider typeProvider;
    private final PoetExtensions poetExtensions;

    MemberCopierSpec(MemberModel memberModel, ServiceModelCopiers serviceModelCopiers, TypeProvider typeProvider, PoetExtensions poetExtensions) {
        this.memberModel = memberModel;
        this.serviceModelCopiers = serviceModelCopiers;
        this.typeProvider = typeProvider;
        this.poetExtensions = poetExtensions;
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.FINAL}).addAnnotation(PoetUtils.GENERATED).addMethod(this.copyMethod());
        if (this.serviceModelCopiers.requiresBuilderCopier(this.memberModel)) {
            builder.addMethod(this.builderCopyMethod());
        }
        return builder.build();
    }

    @Override
    public ClassName className() {
        return this.serviceModelCopiers.copierClassFor(this.memberModel).get();
    }

    @Override
    public Iterable<StaticImport> staticImports() {
        if (this.memberModel.isList()) {
            return Collections.singletonList(StaticImport.staticMethodImport(Collectors.class, "toList"));
        }
        if (this.memberModel.isMap()) {
            return Collections.singletonList(StaticImport.staticMethodImport(Collectors.class, "toMap"));
        }
        return Collections.emptyList();
    }

    private MethodSpec copyMethod() {
        return this.copyMethodProto().addCode(this.copyMethodBody()).build();
    }

    private MethodSpec.Builder copyMethodProto() {
        TypeName parameterType = this.typeProvider.parameterType(this.memberModel);
        return MethodSpec.methodBuilder((String)this.serviceModelCopiers.copyMethodName()).addModifiers(new Modifier[]{Modifier.STATIC}).addParameter(parameterType, this.memberParamName(), new Modifier[0]).returns(this.typeProvider.fieldType(this.memberModel));
    }

    private MethodSpec builderCopyMethod() {
        if (this.memberModel.isList()) {
            return this.builderCopyMethodForMap();
        }
        if (this.memberModel.isMap()) {
            return this.builderCopyMethodForList();
        }
        throw new UnsupportedOperationException();
    }

    private MethodSpec builderCopyMethodForList() {
        TypeName keyType = this.typeProvider.getTypeNameForSimpleType(this.memberModel.getMapModel().getKeyModel().getVariable().getVariableType());
        ClassName valueParameter = this.poetExtensions.getModelClass(this.memberModel.getMapModel().getValueModel().getC2jShape());
        ClassName builderForParameter = valueParameter.nestedClass("Builder");
        ParameterizedTypeName parameterType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{keyType, WildcardTypeName.subtypeOf((TypeName)builderForParameter)});
        CodeBlock code = CodeBlock.builder().beginControlFlow("if ($N == null)", new Object[]{this.memberParamName()}).addStatement("return null", new Object[0]).endControlFlow().addStatement("return $N($N.entrySet().stream().collect(toMap($T::getKey, e -> e.getValue().build())))", new Object[]{this.serviceModelCopiers.copyMethodName(), this.memberParamName(), Map.Entry.class}).build();
        return MethodSpec.methodBuilder((String)this.serviceModelCopiers.builderCopyMethodName()).addModifiers(new Modifier[]{Modifier.STATIC}).addParameter((TypeName)parameterType, this.memberParamName(), new Modifier[0]).returns(this.typeProvider.fieldType(this.memberModel)).addCode(code).build();
    }

    private MethodSpec builderCopyMethodForMap() {
        ClassName listParameter = this.poetExtensions.getModelClass(this.memberModel.getListModel().getListMemberModel().getC2jShape());
        ClassName builderForParameter = listParameter.nestedClass("Builder");
        ParameterizedTypeName parameterType = ParameterizedTypeName.get((ClassName)ClassName.get(Collection.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)builderForParameter)});
        CodeBlock code = CodeBlock.builder().beginControlFlow("if ($N == null)", new Object[]{this.memberParamName()}).addStatement("return null", new Object[0]).endControlFlow().addStatement("return $N($N.stream().map($T::$N).collect(toList()))", new Object[]{this.serviceModelCopiers.copyMethodName(), this.memberParamName(), builderForParameter, "build"}).build();
        return MethodSpec.methodBuilder((String)this.serviceModelCopiers.builderCopyMethodName()).addModifiers(new Modifier[]{Modifier.STATIC}).addParameter((TypeName)parameterType, this.memberParamName(), new Modifier[0]).returns(this.typeProvider.fieldType(this.memberModel)).addCode(code).build();
    }

    private CodeBlock copyMethodBody() {
        if (this.memberModel.isMap()) {
            return this.mapCopyBody();
        }
        if (this.memberModel.isList()) {
            return this.listCopyBody();
        }
        return this.modelCopyBody();
    }

    private CodeBlock listCopyBody() {
        String paramName = this.memberParamName();
        MemberModel listMember = this.memberModel.getListModel().getListMemberModel();
        String copyName = paramName + "Copy";
        CodeBlock.Builder builder = CodeBlock.builder().beginControlFlow("if ($N == null)", new Object[]{this.memberParamName()}).addStatement("return null", new Object[0]).endControlFlow().add("$T $N = $N.stream()", new Object[]{this.typeProvider.fieldType(this.memberModel), copyName, paramName});
        this.serviceModelCopiers.copierClassFor(listMember).ifPresent(copyClass -> builder.add(".map($T::$N)", new Object[]{copyClass, this.serviceModelCopiers.copyMethodName()}));
        builder.add(".collect(toList());", new Object[0]);
        return builder.addStatement("return $T.unmodifiableList($N)", new Object[]{Collections.class, copyName}).build();
    }

    private CodeBlock mapCopyBody() {
        MapModel mapModel = this.memberModel.getMapModel();
        String copyMethod = this.serviceModelCopiers.copyMethodName();
        String paramName = this.memberParamName();
        String copyName = paramName + "Copy";
        CodeBlock keyCopyExpr = Optional.ofNullable(mapModel.getKeyModel()).map(model -> this.serviceModelCopiers.copierClassFor((MemberModel)model).map(copier -> CodeBlock.of((String)"e -> $T.$N(e.getKey())", (Object[])new Object[]{copier, copyMethod})).orElseGet(() -> CodeBlock.of((String)"$T::getKey", (Object[])new Object[]{Map.Entry.class}))).orElseGet(() -> CodeBlock.of((String)"e -> $T.$N(e.getKey())", (Object[])new Object[]{StandardMemberCopier.class, copyMethod}));
        CodeBlock valueCopyExpr = Optional.ofNullable(mapModel.getValueModel()).map(model -> this.serviceModelCopiers.copierClassFor((MemberModel)model).map(copier -> CodeBlock.of((String)"e -> $T.$N(e.getValue())", (Object[])new Object[]{copier, copyMethod})).orElseGet(() -> CodeBlock.of((String)"$T::getValue", (Object[])new Object[]{Map.Entry.class}))).orElseGet(() -> CodeBlock.of((String)"e -> $T.$N(e.getValue())", (Object[])new Object[]{StandardMemberCopier.class, copyMethod}));
        CodeBlock.Builder builder = CodeBlock.builder().beginControlFlow("if ($N == null)", new Object[]{this.memberParamName()}).addStatement("return null", new Object[0]).endControlFlow().addStatement("$T $N = $N.entrySet().stream().collect(toMap($L, $L))", new Object[]{this.typeProvider.fieldType(this.memberModel), copyName, this.memberParamName(), keyCopyExpr, valueCopyExpr});
        return builder.addStatement("return $T.unmodifiableMap($N)", new Object[]{Collections.class, copyName}).build();
    }

    private CodeBlock modelCopyBody() {
        return CodeBlock.builder().addStatement("return $N", new Object[]{this.memberParamName()}).build();
    }

    private String memberParamName() {
        if (this.memberModel.isSimple()) {
            return Utils.unCapitialize(this.memberModel.getVariable().getSimpleType()) + "Param";
        }
        return Utils.unCapitialize(this.memberModel.getC2jShape()) + "Param";
    }
}

