/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.model.AbstractMemberSetters;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;

class ListSetters
extends AbstractMemberSetters {
    private final TypeProvider typeProvider;
    private final PoetExtensions poetExtensions;

    ListSetters(IntermediateModel intermediateModel, ShapeModel shapeModel, MemberModel memberModel, TypeProvider typeProvider) {
        super(intermediateModel, shapeModel, memberModel, typeProvider);
        this.typeProvider = typeProvider;
        this.poetExtensions = new PoetExtensions(intermediateModel);
    }

    @Override
    public List<MethodSpec> fluentDeclarations(TypeName returnType) {
        ArrayList<MethodSpec> fluentDeclarations = new ArrayList<MethodSpec>();
        String setterDocumentation = this.memberModel().getFluentSetterDocumentation();
        fluentDeclarations.add(this.fluentAbstractSetterDeclaration(this.memberAsParameter(), returnType).addJavadoc("$L", new Object[]{setterDocumentation}).build());
        fluentDeclarations.add(this.fluentAbstractSetterDeclaration(ParameterSpec.builder((TypeName)this.asArray(), (String)this.fieldName(), (Modifier[])new Modifier[0]).build(), returnType).addJavadoc("$L", new Object[]{setterDocumentation}).varargs(true).build());
        if (this.memberModel().getEnumType() != null) {
            fluentDeclarations.add(this.fluentAbstractSetterDeclaration(ParameterSpec.builder((TypeName)this.asArrayOfModeledEnum(), (String)this.fieldName(), (Modifier[])new Modifier[0]).build(), returnType).varargs(true).addJavadoc("$L", new Object[]{setterDocumentation}).build());
        }
        return fluentDeclarations;
    }

    @Override
    public List<MethodSpec> fluent(TypeName returnType) {
        ArrayList<MethodSpec> fluent = new ArrayList<MethodSpec>();
        fluent.add(this.fluentCopySetter(returnType));
        fluent.add(this.fluentVarargToListSetter(returnType));
        if (this.memberModel().getEnumType() != null) {
            fluent.add(this.fluentEnumVarargToListSetter(returnType));
        }
        return fluent;
    }

    @Override
    public MethodSpec beanStyle() {
        MethodSpec.Builder builder = this.beanStyleSetterBuilder().addCode(this.memberModel().isCollectionWithBuilderMember() ? this.copySetterBuilderBody() : this.copySetterBody());
        if (this.annotateJsonProperty()) {
            builder.addAnnotation(AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", new Object[]{this.memberModel().getHttp().getMarshallLocationName()}).build());
        }
        return builder.build();
    }

    private MethodSpec fluentCopySetter(TypeName returnType) {
        return this.fluentSetterBuilder(returnType).addCode(this.copySetterBody().toBuilder().addStatement("return this", new Object[0]).build()).build();
    }

    private MethodSpec fluentVarargToListSetter(TypeName returnType) {
        return this.fluentSetterBuilder(ParameterSpec.builder((TypeName)this.asArray(), (String)this.fieldName(), (Modifier[])new Modifier[0]).build(), returnType).varargs(true).addAnnotation(SafeVarargs.class).addCode(this.varargToListSetterBody()).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec fluentEnumVarargToListSetter(TypeName returnType) {
        return this.fluentSetterBuilder(ParameterSpec.builder((TypeName)this.asArrayOfModeledEnum(), (String)this.fieldName(), (Modifier[])new Modifier[0]).build(), returnType).varargs(true).addAnnotation(SafeVarargs.class).addCode(this.enumVarargToListSetterBody()).addStatement("return this", new Object[0]).build();
    }

    private CodeBlock varargToListSetterBody() {
        return CodeBlock.of((String)"$1L($2T.asList($1L));", (Object[])new Object[]{this.fieldName(), Arrays.class});
    }

    private CodeBlock enumVarargToListSetterBody() {
        return CodeBlock.of((String)"$1L($2T.asList($1L).stream().map($3T::toString).collect($4T.toList()));", (Object[])new Object[]{this.fieldName(), Arrays.class, Object.class, Collectors.class});
    }

    private MemberModel elementModel() {
        return this.memberModel().getListModel().getListMemberModel();
    }

    private TypeName modeledEnumElement() {
        return this.poetExtensions.getModelClass(this.memberModel().getEnumType());
    }

    private TypeName listElementType() {
        return this.typeProvider.parameterType(this.elementModel());
    }

    private ArrayTypeName asArray() {
        return ArrayTypeName.of((TypeName)this.listElementType());
    }

    private ArrayTypeName asArrayOfModeledEnum() {
        return ArrayTypeName.of((TypeName)this.modeledEnumElement());
    }
}

