/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.docs.ClientType;
import software.amazon.awssdk.codegen.docs.SimpleMethodOverload;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.utils.PaginatorUtils;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.async.AsyncRequestProvider;
import software.amazon.awssdk.core.async.AsyncResponseHandler;
import software.amazon.awssdk.core.auth.DefaultCredentialsProvider;
import software.amazon.awssdk.core.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public class AsyncClientInterface
implements ClassSpec {
    public static final TypeVariableName STREAMING_TYPE_VARIABLE = TypeVariableName.get((String)"ReturnT");
    protected final IntermediateModel model;
    protected final ClassName className;
    protected final String clientPackageName;
    private final String modelPackage;
    private final PoetExtensions poetExtensions;

    public AsyncClientInterface(IntermediateModel model) {
        this.modelPackage = model.getMetadata().getFullModelPackageName();
        this.clientPackageName = model.getMetadata().getFullClientPackageName();
        this.model = model;
        this.className = ClassName.get((String)model.getMetadata().getFullClientPackageName(), (String)model.getMetadata().getAsyncInterface(), (String[])new String[0]);
        this.poetExtensions = new PoetExtensions(model);
    }

    @Override
    public TypeSpec poetSpec() {
        return PoetUtils.createInterfaceBuilder(this.className).addSuperinterface(SdkClient.class).addSuperinterface(SdkAutoCloseable.class).addJavadoc(this.getJavadoc(), new Object[0]).addField(FieldSpec.builder(String.class, (String)"SERVICE_NAME", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{this.model.getMetadata().getSigningName()}).build()).addMethod(this.create()).addMethod(this.builder()).addMethods(this.operationsAndSimpleMethods()).build();
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    private String getJavadoc() {
        return "Service client for accessing " + this.model.getMetadata().getServiceAbbreviation() + " asynchronously. This can be created using the static {@link #builder()} method.\n\n" + this.model.getMetadata().getDocumentation();
    }

    private MethodSpec create() {
        return MethodSpec.methodBuilder((String)"create").returns((TypeName)this.className).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addJavadoc("Create a {@link $T} with the region loaded from the {@link $T} and credentials loaded from the {@link $T}.", new Object[]{this.className, DefaultAwsRegionProviderChain.class, DefaultCredentialsProvider.class}).addStatement("return builder().build()", new Object[0]).build();
    }

    private MethodSpec builder() {
        ClassName builderClass = ClassName.get((String)this.clientPackageName, (String)this.model.getMetadata().getAsyncBuilder(), (String[])new String[0]);
        ClassName builderInterface = ClassName.get((String)this.clientPackageName, (String)this.model.getMetadata().getAsyncBuilderInterface(), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"builder").returns((TypeName)builderInterface).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addJavadoc("Create a builder that can be used to configure and create a {@link $T}.", new Object[]{this.className}).addStatement("return new $T()", new Object[]{builderClass}).build();
    }

    protected final List<MethodSpec> operations() {
        return this.model.getOperations().values().stream().map(this::traditionalMethod).map(MethodSpec.Builder::build).collect(Collectors.toList());
    }

    private Iterable<MethodSpec> operationsAndSimpleMethods() {
        List<MethodSpec> methods = this.operations();
        methods.addAll(this.model.getOperations().values().stream().map(this::addMethodOverloads).flatMap(Collection::stream).map(MethodSpec.Builder::build).collect(Collectors.toList()));
        methods.addAll(this.paginatedTraditionalMethods());
        methods.addAll(this.paginatedSimpleMethods());
        return methods.stream().sorted(Comparator.comparing(m -> m.name)).collect(Collectors.toList());
    }

    protected List<MethodSpec> paginatedTraditionalMethods() {
        return this.model.getOperations().values().stream().filter(operationModel -> operationModel.isPaginated()).map(this::paginatedTraditionalMethod).collect(Collectors.toList());
    }

    private MethodSpec paginatedTraditionalMethod(OperationModel opModel) {
        String methodName = PaginatorUtils.getPaginatedMethodName(opModel.getMethodName());
        ClassName requestType = ClassName.get((String)this.modelPackage, (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        ClassName responsePojoType = this.poetExtensions.getResponseClassForPaginatedAsyncOperation(opModel.getOperationName());
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).returns((TypeName)responsePojoType).addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]).addJavadoc(opModel.getDocs(this.model, ClientType.ASYNC, SimpleMethodOverload.PAGINATED), new Object[0]);
        return this.paginatedMethodBody(builder, opModel).build();
    }

    protected MethodSpec.Builder paginatedMethodBody(MethodSpec.Builder builder, OperationModel operationModel) {
        return builder.addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class});
    }

    private List<MethodSpec> paginatedSimpleMethods() {
        return this.model.getOperations().values().stream().filter(operationModel -> operationModel.isPaginated()).filter(operationModel -> operationModel.getInputShape().isSimpleMethod()).map(this::paginatedSimpleMethod).collect(Collectors.toList());
    }

    private MethodSpec paginatedSimpleMethod(OperationModel opModel) {
        String methodName = PaginatorUtils.getPaginatedMethodName(opModel.getMethodName());
        ClassName requestType = ClassName.get((String)this.modelPackage, (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        ClassName responsePojoType = this.poetExtensions.getResponseClassForPaginatedAsyncOperation(opModel.getOperationName());
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).returns((TypeName)responsePojoType).addStatement("return $L($T.builder().build())", new Object[]{methodName, requestType}).addJavadoc(opModel.getDocs(this.model, ClientType.ASYNC, SimpleMethodOverload.NO_ARG_PAGINATED), new Object[0]);
        return builder.build();
    }

    private List<MethodSpec.Builder> addMethodOverloads(OperationModel opModel) {
        ArrayList<MethodSpec.Builder> methodOverloads = new ArrayList<MethodSpec.Builder>();
        if (opModel.getInputShape().isSimpleMethod()) {
            methodOverloads.add(this.noArgSimpleMethod(opModel));
        }
        if (opModel.hasStreamingInput()) {
            methodOverloads.add(this.streamingInputFileSimpleMethod(opModel));
        }
        if (opModel.hasStreamingOutput()) {
            methodOverloads.add(this.streamingOutputFileSimpleMethod(opModel));
        }
        if (!opModel.isStreaming()) {
            methodOverloads.add(this.builderConsumerMethod(opModel));
        }
        return methodOverloads;
    }

    protected MethodSpec.Builder operationBody(MethodSpec.Builder builder, OperationModel operationModel) {
        return builder.addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class});
    }

    private MethodSpec.Builder traditionalMethod(OperationModel opModel) {
        ClassName responsePojoType = this.getPojoResponseType(opModel);
        ClassName requestType = ClassName.get((String)this.modelPackage, (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        MethodSpec.Builder builder = this.methodSignatureWithReturnType(opModel).addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]).addJavadoc(opModel.getDocs(this.model, ClientType.ASYNC), new Object[0]);
        if (opModel.hasStreamingInput()) {
            builder.addParameter((TypeName)ClassName.get(AsyncRequestProvider.class), "requestProvider", new Modifier[0]);
        }
        if (opModel.hasStreamingOutput()) {
            builder.addTypeVariable(STREAMING_TYPE_VARIABLE);
            ParameterizedTypeName asyncResponseHandlerType = ParameterizedTypeName.get((ClassName)ClassName.get(AsyncResponseHandler.class), (TypeName[])new TypeName[]{responsePojoType, STREAMING_TYPE_VARIABLE});
            builder.addParameter((TypeName)asyncResponseHandlerType, "asyncResponseHandler", new Modifier[0]);
        }
        return this.operationBody(builder, opModel);
    }

    private MethodSpec.Builder noArgSimpleMethod(OperationModel opModel) {
        return this.interfaceMethodSignature(opModel).addJavadoc(opModel.getDocs(this.model, ClientType.ASYNC, SimpleMethodOverload.NO_ARG), new Object[0]).addStatement("return $N($N.builder().build())", new Object[]{opModel.getMethodName(), opModel.getInput().getVariableType()});
    }

    private MethodSpec.Builder builderConsumerMethod(OperationModel opModel) {
        ClassName requestType = ClassName.get((String)this.model.getMetadata().getFullModelPackageName(), (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        ClassName builder = requestType.nestedClass("Builder");
        ParameterizedTypeName consumer = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{builder});
        return this.interfaceMethodSignature(opModel).addParameter((TypeName)consumer, opModel.getInput().getVariableName(), new Modifier[0]).addJavadoc(opModel.getDocs(this.model, ClientType.ASYNC, SimpleMethodOverload.CONSUMER_BUILDER), new Object[0]).addStatement("return $N($T.builder().apply($N).build())", new Object[]{opModel.getMethodName(), requestType, opModel.getInput().getVariableName()});
    }

    private MethodSpec.Builder streamingInputFileSimpleMethod(OperationModel opModel) {
        ClassName requestType = ClassName.get((String)this.modelPackage, (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        return this.interfaceMethodSignature(opModel).addJavadoc(opModel.getDocs(this.model, ClientType.ASYNC, SimpleMethodOverload.FILE), new Object[0]).addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]).addParameter((TypeName)ClassName.get(Path.class), "path", new Modifier[0]).addStatement("return $L($L, $T.fromFile(path))", new Object[]{opModel.getMethodName(), opModel.getInput().getVariableName(), ClassName.get(AsyncRequestProvider.class)});
    }

    private MethodSpec.Builder streamingOutputFileSimpleMethod(OperationModel opModel) {
        ClassName requestType = ClassName.get((String)this.modelPackage, (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        return this.interfaceMethodSignature(opModel).returns((TypeName)this.completableFutureType((TypeName)this.getPojoResponseType(opModel))).addJavadoc(opModel.getDocs(this.model, ClientType.ASYNC, SimpleMethodOverload.FILE), new Object[0]).addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]).addParameter((TypeName)ClassName.get(Path.class), "path", new Modifier[0]).addStatement("return $L($L, $T.toFile(path))", new Object[]{opModel.getMethodName(), opModel.getInput().getVariableName(), ClassName.get(AsyncResponseHandler.class)});
    }

    private MethodSpec.Builder methodSignatureWithReturnType(OperationModel opModel) {
        ClassName responsePojoType = this.getPojoResponseType(opModel);
        return MethodSpec.methodBuilder((String)opModel.getMethodName()).returns(this.getAsyncReturnType(opModel, responsePojoType));
    }

    private MethodSpec.Builder interfaceMethodSignature(OperationModel opModel) {
        return this.methodSignatureWithReturnType(opModel).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT});
    }

    private ClassName getPojoResponseType(OperationModel opModel) {
        return ClassName.get((String)this.modelPackage, (String)opModel.getReturnType().getReturnType(), (String[])new String[0]);
    }

    private TypeName getAsyncReturnType(OperationModel opModel, ClassName responsePojoType) {
        if (opModel.hasStreamingOutput()) {
            return this.completableFutureType((TypeName)STREAMING_TYPE_VARIABLE);
        }
        return this.completableFutureType((TypeName)responsePojoType);
    }

    private ParameterizedTypeName completableFutureType(TypeName typeName) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{typeName});
    }
}

