/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client.specs;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.w3c.dom.Node;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.client.specs.ProtocolSpec;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.http.DefaultErrorResponseHandler;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.StaxResponseHandler;
import software.amazon.awssdk.core.runtime.transform.StandardErrorUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.StreamingRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.utils.StringUtils;

public class QueryXmlProtocolSpec
implements ProtocolSpec {
    private final PoetExtensions poetExtensions;
    private final TypeName unmarshallerType = ParameterizedTypeName.get(Unmarshaller.class, (Type[])new Type[]{SdkServiceException.class, Node.class});
    private final TypeName listOfUnmarshallersType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"java.util", (String)"List", (String[])new String[0]), (TypeName[])new TypeName[]{this.unmarshallerType});

    public QueryXmlProtocolSpec(PoetExtensions poetExtensions) {
        this.poetExtensions = poetExtensions;
    }

    @Override
    public FieldSpec protocolFactory(IntermediateModel model) {
        return FieldSpec.builder((TypeName)this.listOfUnmarshallersType, (String)"exceptionUnmarshallers", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    @Override
    public MethodSpec initProtocolFactory(IntermediateModel model) {
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)"init").returns(this.listOfUnmarshallersType).addModifiers(new Modifier[]{Modifier.PRIVATE});
        methodSpec.addStatement("$T<$T> unmarshallers = new $T<>()", new Object[]{List.class, this.unmarshallerType, ArrayList.class});
        this.errorUnmarshallers(model).forEach(arg_0 -> ((MethodSpec.Builder)methodSpec).addCode(arg_0));
        methodSpec.addCode(CodeBlock.builder().add("unmarshallers.add(new $T($T.class));", new Object[]{this.getErrorUnmarshallerClass(model), this.poetExtensions.getModelClass(model.getSdkModeledExceptionBaseClassName())}).build());
        methodSpec.addStatement("return $N", new Object[]{"unmarshallers"});
        return methodSpec.build();
    }

    private ClassName getErrorUnmarshallerClass(IntermediateModel model) {
        return StringUtils.isNotBlank((CharSequence)model.getExceptionUnmarshallerImpl()) ? PoetUtils.classNameFromFqcn(model.getExceptionUnmarshallerImpl()) : ClassName.get(StandardErrorUnmarshaller.class);
    }

    @Override
    public CodeBlock responseHandler(OperationModel opModel) {
        ClassName unmarshaller = this.poetExtensions.getTransformClass(opModel.getReturnType().getReturnType() + "Unmarshaller");
        ClassName responseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        if (opModel.hasStreamingOutput()) {
            return CodeBlock.builder().addStatement("\n\n$T<$T> responseHandler = $T.createStreamingResponseHandler(new $T())", new Object[]{HttpResponseHandler.class, responseType, StaxResponseHandler.class, unmarshaller}).build();
        }
        return CodeBlock.builder().addStatement("\n\n$T<$T> responseHandler = new $T<$T>(new $T())", new Object[]{StaxResponseHandler.class, responseType, StaxResponseHandler.class, responseType, unmarshaller}).build();
    }

    @Override
    public CodeBlock errorResponseHandler(OperationModel opModel) {
        return CodeBlock.builder().add("\n\n$T errorResponseHandler = new $T($N);", new Object[]{DefaultErrorResponseHandler.class, DefaultErrorResponseHandler.class, "exceptionUnmarshallers"}).build();
    }

    @Override
    public CodeBlock executionHandler(OperationModel opModel) {
        ClassName responseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        ClassName requestType = this.poetExtensions.getModelClass(opModel.getInput().getVariableType());
        ClassName marshaller = this.poetExtensions.getTransformClass(opModel.getInputShape().getShapeName() + "Marshaller");
        CodeBlock.Builder codeBlock = CodeBlock.builder().add("\n\nreturn clientHandler.execute(new $T<$T, $T>().withResponseHandler($N).withErrorResponseHandler($N).withInput($L)", new Object[]{ClientExecutionParams.class, requestType, responseType, "responseHandler", "errorResponseHandler", opModel.getInput().getVariableName()});
        if (opModel.hasStreamingInput()) {
            return codeBlock.add(".withMarshaller(new $T(new $T(), requestBody)));", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(StreamingRequestMarshaller.class), (TypeName[])new TypeName[]{requestType}), marshaller}).build();
        }
        return codeBlock.add(".withMarshaller(new $T()) $L);", new Object[]{marshaller, opModel.hasStreamingOutput() ? ", streamingResponseHandler" : ""}).build();
    }

    @Override
    public CodeBlock asyncExecutionHandler(OperationModel opModel) {
        ClassName pojoResponseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        ClassName requestType = this.poetExtensions.getModelClass(opModel.getInput().getVariableType());
        ClassName marshaller = this.poetExtensions.getRequestTransformClass(opModel.getInputShape().getShapeName() + "Marshaller");
        String asyncRequestProvider = opModel.hasStreamingInput() ? ".withAsyncRequestProvider(requestProvider)" : "";
        return CodeBlock.builder().add("\n\nreturn clientHandler.execute(new $T<$T, $T>()\n.withMarshaller(new $T()).withResponseHandler(responseHandler).withErrorResponseHandler($N)\n" + asyncRequestProvider + ".withInput($L) $L);", new Object[]{ClientExecutionParams.class, requestType, pojoResponseType, marshaller, "errorResponseHandler", opModel.getInput().getVariableName(), opModel.hasStreamingOutput() ? ", asyncResponseHandler" : ""}).build();
    }

    @Override
    public Optional<MethodSpec> createErrorResponseHandler() {
        return Optional.empty();
    }

    @Override
    public List<CodeBlock> errorUnmarshallers(IntermediateModel model) {
        List exceptions = model.getShapes().values().stream().filter(s -> s.getType().equals("Exception")).collect(Collectors.toList());
        return exceptions.stream().map(s -> {
            ClassName exceptionClass = this.poetExtensions.getTransformClass(s.getShapeName() + "Unmarshaller");
            return CodeBlock.builder().add("unmarshallers.add(new $T());", new Object[]{exceptionClass}).build();
        }).collect(Collectors.toList());
    }
}

