/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.internal;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.util.List;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.config.templates.ChildTemplate;
import software.amazon.awssdk.codegen.model.config.templates.CodeGenTemplatesConfig;
import software.amazon.awssdk.codegen.model.config.templates.TopLevelTemplate;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;

public class Freemarker {
    private final CodeGenTemplatesConfig templateConfig;

    private Freemarker(CodeGenTemplatesConfig templateConfig) {
        this.templateConfig = templateConfig;
    }

    public static Freemarker create(IntermediateModel model) {
        return new Freemarker(Freemarker.loadProtocolTemplatesConfig(model));
    }

    private static CodeGenTemplatesConfig loadProtocolTemplatesConfig(IntermediateModel model) {
        Protocol templateProtocol = model.getMetadata().getProtocol();
        if (Protocol.CBOR.equals((Object)model.getMetadata().getProtocol()) || Protocol.ION.equals((Object)model.getMetadata().getProtocol())) {
            templateProtocol = Protocol.AWS_JSON;
        }
        CodeGenTemplatesConfig protocolDefaultConfig = CodeGenTemplatesConfig.load(templateProtocol);
        CustomizationConfig customConfig = model.getCustomizationConfig();
        if (customConfig == null || customConfig.getCustomCodeTemplates() == null) {
            return protocolDefaultConfig;
        }
        return CodeGenTemplatesConfig.merge(protocolDefaultConfig, customConfig.getCustomCodeTemplates());
    }

    private static void importChildTemplates(Configuration freeMarkerConfig, List<ChildTemplate> childTemplates) {
        if (childTemplates == null) {
            return;
        }
        for (ChildTemplate template : childTemplates) {
            freeMarkerConfig.addAutoImport(template.getImportAsNamespace(), template.getLocation());
        }
    }

    private Configuration newFreeMarkerConfig() {
        Configuration freeMarkerConfig = new Configuration(Configuration.VERSION_2_3_24);
        freeMarkerConfig.setDefaultEncoding("UTF-8");
        freeMarkerConfig.setClassForTemplateLoading(this.getClass(), "/");
        freeMarkerConfig.setTemplateExceptionHandler(TemplateExceptionHandler.DEBUG_HANDLER);
        return freeMarkerConfig;
    }

    private Template getTemplate(TopLevelTemplate template) throws IOException {
        Configuration fmConfig = this.newFreeMarkerConfig();
        Freemarker.importChildTemplates(fmConfig, this.templateConfig.getCommonChildTemplates());
        Freemarker.importChildTemplates(fmConfig, template.getChildTemplates());
        return fmConfig.getTemplate(template.getMainTemplate());
    }

    public Template getSyncClientBuilderTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getSyncClientBuilder());
    }

    public Template getAsyncClientBuilderTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getAsyncClientBuilder());
    }

    public Template getModelMarshallerTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getModelMarshaller());
    }

    public Template getRequestMarshallerTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getRequestMarshaller());
    }

    public Template getModelUnmarshallerTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getModelUnmarshaller());
    }

    public Template getExceptionUnmarshallerTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getExceptionUnmarshaller());
    }

    public Template getPolicyActionClassTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getPolicyActionClass());
    }

    public Template getCucumberModuleInjectorTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getCucumberModuleInjector());
    }

    public Template getCucumberTestTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getCucumberTest());
    }

    public Template getCucumberPropertiesTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getCucumberPropertiesFile());
    }

    public Template getApiGatewayPomTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getApiGatewayPomTemplate());
    }

    public Template getApiGatewayGradleBuildTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getApiGatewayGradleBuildTemplate());
    }

    public Template getApiGatewayGradleSettingsTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getApiGatewayGradleSettingsTemplate());
    }

    public Template getApiGatewayReadmeTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getApiGatewayReadmeTemplate());
    }

    public Template getPackageInfoTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getPackageInfo());
    }

    public Template getBaseExceptionClassTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getBaseExceptionClass());
    }

    public Template getCustomAuthorizerTemplate() throws IOException {
        return this.getTemplate(this.templateConfig.getCustomRequestSignerClass());
    }
}

