/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.Generated;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.DocumentationModel;
import software.amazon.awssdk.codegen.model.intermediate.HasDeprecation;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.utils.StringUtils;

public final class PoetUtils {
    public static final AnnotationSpec GENERATED = AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{"software.amazon.awssdk:codegen"}).build();

    private PoetUtils() {
    }

    public static MethodSpec.Builder toStringBuilder() {
        return MethodSpec.methodBuilder((String)"toString").returns(String.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class);
    }

    public static void addDeprecated(Consumer<Class<?>> builder, HasDeprecation deprecation) {
        if (deprecation.isDeprecated()) {
            PoetUtils.addDeprecated(builder);
        }
    }

    public static void addDeprecated(Consumer<Class<?>> builder) {
        builder.accept(Deprecated.class);
    }

    public static void addJavadoc(Consumer<String> builder, String javadoc) {
        if (StringUtils.isNotBlank((CharSequence)javadoc)) {
            builder.accept(javadoc + (javadoc.endsWith("\n") ? "" : "\n"));
        }
    }

    public static void addJavadoc(Consumer<String> builder, DocumentationModel docModel) {
        PoetUtils.addJavadoc(builder, docModel.getDocumentation());
    }

    public static TypeSpec.Builder createEnumBuilder(ClassName name) {
        return TypeSpec.enumBuilder((ClassName)name).addAnnotation(GENERATED).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public static TypeSpec.Builder createInterfaceBuilder(ClassName name) {
        return TypeSpec.interfaceBuilder((ClassName)name).addAnnotation(GENERATED).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    public static TypeSpec.Builder createClassBuilder(ClassName name) {
        return TypeSpec.classBuilder((ClassName)name).addAnnotation(GENERATED);
    }

    public static ParameterizedTypeName createParameterizedTypeName(ClassName className, String ... typeVariables) {
        TypeName[] typeParameters = (TypeName[])Arrays.stream(typeVariables).map(TypeVariableName::get).toArray(TypeName[]::new);
        return ParameterizedTypeName.get((ClassName)className, (TypeName[])typeParameters);
    }

    public static ParameterizedTypeName createParameterizedTypeName(Class<?> clazz, String ... typeVariables) {
        return PoetUtils.createParameterizedTypeName(ClassName.get(clazz), typeVariables);
    }

    public static TypeVariableName createBoundedTypeVariableName(String parameterName, ClassName upperBound, String ... typeVariables) {
        return TypeVariableName.get((String)parameterName, (TypeName[])new TypeName[]{PoetUtils.createParameterizedTypeName(upperBound, typeVariables)});
    }

    public static ClassName classNameFromFqcn(String fqcn) {
        String basePath = fqcn.substring(0, fqcn.lastIndexOf("."));
        String className = fqcn.substring(fqcn.lastIndexOf(".") + 1);
        return ClassName.get((String)basePath, (String)className, (String[])new String[0]);
    }

    public static JavaFile buildJavaFile(ClassSpec spec) {
        JavaFile.Builder builder = JavaFile.builder((String)spec.className().packageName(), (TypeSpec)spec.poetSpec()).skipJavaLangImports(true);
        spec.staticImports().forEach(i -> i.memberNames().forEach(m -> builder.addStaticImport(i.className(), new String[]{m})));
        return builder.build();
    }
}

