/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.codegen.IntermediateModelBuilder;
import software.amazon.awssdk.codegen.internal.TypeUtils;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.intermediate.EnumModel;
import software.amazon.awssdk.codegen.model.intermediate.ListModel;
import software.amazon.awssdk.codegen.model.intermediate.MapModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ParameterHttpMapping;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.model.intermediate.ReturnTypeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.VariableModel;
import software.amazon.awssdk.codegen.model.service.Location;
import software.amazon.awssdk.codegen.model.service.Member;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.model.service.Shape;
import software.amazon.awssdk.codegen.naming.NamingStrategy;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.Validate;

abstract class AddShapes {
    private final IntermediateModelBuilder builder;
    private final NamingStrategy namingStrategy;

    AddShapes(IntermediateModelBuilder builder) {
        this.builder = builder;
        this.namingStrategy = builder.getNamingStrategy();
    }

    protected final TypeUtils getTypeUtils() {
        return this.builder.getTypeUtils();
    }

    protected final NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    protected final ServiceModel getServiceModel() {
        return this.builder.getService();
    }

    protected final CustomizationConfig getCustomizationConfig() {
        return this.builder.getCustomConfig();
    }

    protected final ShapeModel generateShapeModel(String javaClassName, String shapeName) {
        List<String> enumValues;
        ShapeModel shapeModel = new ShapeModel(shapeName);
        shapeModel.setShapeName(javaClassName);
        Shape shape = this.getServiceModel().getShapes().get(shapeName);
        shapeModel.setDocumentation(shape.getDocumentation());
        shapeModel.setVariable(new VariableModel(this.getNamingStrategy().getVariableName(javaClassName), javaClassName));
        shapeModel.setRequired(shape.getRequired());
        shapeModel.setDeprecated(shape.isDeprecated());
        shapeModel.setWrapper(shape.isWrapper());
        boolean hasHeaderMember = false;
        boolean hasStatusCodeMember = false;
        boolean hasPayloadMember = false;
        boolean hasStreamingMember = false;
        Map<String, Member> members = shape.getMembers();
        if (members != null) {
            for (Map.Entry<String, Member> memberEntry : members.entrySet()) {
                String c2jMemberName = memberEntry.getKey();
                Member c2jMemberDefinition = memberEntry.getValue();
                Shape parentShape = shape;
                MemberModel memberModel = this.generateMemberModel(c2jMemberName, c2jMemberDefinition, this.getProtocol(), parentShape, this.getServiceModel().getShapes());
                if (memberModel.getHttp().getLocation() == Location.HEADER) {
                    hasHeaderMember = true;
                } else if (memberModel.getHttp().getLocation() == Location.STATUS_CODE) {
                    hasStatusCodeMember = true;
                } else if (memberModel.getHttp().getIsPayload()) {
                    hasPayloadMember = true;
                    if (memberModel.getHttp().getIsStreaming()) {
                        hasStreamingMember = true;
                    }
                }
                shapeModel.addMember(memberModel);
            }
            shapeModel.withHasHeaderMember(hasHeaderMember).withHasStatusCodeMember(hasStatusCodeMember).withHasPayloadMember(hasPayloadMember).withHasStreamingMember(hasStreamingMember);
        }
        if ((enumValues = shape.getEnumValues()) != null && !enumValues.isEmpty()) {
            for (String enumValue : enumValues) {
                shapeModel.addEnum(new EnumModel(this.getNamingStrategy().getEnumValueName(enumValue), enumValue));
            }
        }
        return shapeModel;
    }

    private MemberModel generateMemberModel(String c2jMemberName, Member c2jMemberDefinition, String protocol, Shape parentShape, Map<String, Shape> allC2jShapes) {
        String c2jShapeName = c2jMemberDefinition.getShape();
        Shape c2jShape = allC2jShapes.get(c2jShapeName);
        String variableName = this.getNamingStrategy().getVariableName(c2jMemberName);
        String variableType = this.getTypeUtils().getJavaDataType(allC2jShapes, c2jShapeName);
        String variableDeclarationType = this.getTypeUtils().getJavaDataType(allC2jShapes, c2jShapeName, this.getCustomizationConfig());
        if (c2jMemberDefinition.isIdempotencyToken() && !variableType.equals(String.class.getSimpleName())) {
            throw new IllegalArgumentException(c2jMemberName + " is idempotent. It's shape should be string type but it is of " + variableType + " type.");
        }
        MemberModel memberModel = new MemberModel();
        memberModel.withC2jName(c2jMemberName).withC2jShape(c2jShapeName).withName(Utils.capitialize(c2jMemberName)).withVariable(new VariableModel(variableName, variableType, variableDeclarationType).withDocumentation(c2jMemberDefinition.getDocumentation())).withSetterModel(new VariableModel(variableName, variableType, variableDeclarationType)).withGetterModel(new ReturnTypeModel(variableType));
        memberModel.setDocumentation(c2jMemberDefinition.getDocumentation());
        memberModel.setDeprecated(c2jMemberDefinition.isDeprecated());
        memberModel.withFluentGetterMethodName(this.namingStrategy.getFluentGetterMethodName(c2jMemberName, c2jShape)).withFluentEnumGetterMethodName(this.namingStrategy.getFluentEnumGetterMethodName(c2jMemberName, c2jShape)).withFluentSetterMethodName(this.namingStrategy.getFluentSetterMethodName(c2jMemberName)).withBeanStyleGetterMethodName(this.namingStrategy.getBeanStyleGetterMethodName(c2jMemberName)).withBeanStyleSetterMethodName(this.namingStrategy.getBeanStyleSetterMethodName(c2jMemberName));
        memberModel.setIdempotencyToken(c2jMemberDefinition.isIdempotencyToken());
        if (c2jMemberDefinition.getXmlNamespace() != null) {
            memberModel.setXmlNameSpaceUri(c2jMemberDefinition.getXmlNamespace().getUri());
        }
        this.fillContainerTypeMemberMetadata(allC2jShapes, c2jMemberDefinition.getShape(), memberModel, protocol);
        ParameterHttpMapping httpMapping = this.generateParameterHttpMapping(parentShape, c2jMemberName, c2jMemberDefinition, protocol, allC2jShapes);
        String payload = parentShape.getPayload();
        boolean shapeIsStreaming = c2jShape.isStreaming();
        boolean memberIsStreaming = c2jMemberDefinition.isStreaming();
        boolean payloadIsStreaming = shapeIsStreaming || memberIsStreaming;
        httpMapping.withPayload(payload != null && payload.equals(c2jMemberName)).withStreaming(payloadIsStreaming);
        memberModel.setHttp(httpMapping);
        return memberModel;
    }

    private ParameterHttpMapping generateParameterHttpMapping(Shape parentShape, String memberName, Member member, String protocol, Map<String, Shape> allC2jShapes) {
        ParameterHttpMapping mapping = new ParameterHttpMapping();
        Shape memberShape = allC2jShapes.get(member.getShape());
        mapping.withLocation(Location.forValue(member.getLocation())).withPayload(member.isPayload()).withStreaming(member.isStreaming()).withFlattened(member.isFlattened() || memberShape.isFlattened()).withUnmarshallLocationName(this.deriveUnmarshallerLocationName(memberName, member)).withMarshallLocationName(this.deriveMarshallerLocationName(memberName, member, protocol)).withIsGreedy(this.isGreedy(parentShape, allC2jShapes, mapping));
        return mapping;
    }

    private boolean isGreedy(Shape parentShape, Map<String, Shape> allC2jShapes, ParameterHttpMapping mapping) {
        if (mapping.getLocation() == Location.URI) {
            String requestUri = this.findRequestUri(parentShape, allC2jShapes);
            if (requestUri.contains(String.format("{%s+}", mapping.getMarshallLocationName()))) {
                return true;
            }
        }
        return false;
    }

    private String findRequestUri(Shape parentShape, Map<String, Shape> allC2jShapes) {
        return this.builder.getService().getOperations().values().stream().filter(o -> o.getInput() != null).filter(o -> ((Shape)allC2jShapes.get(o.getInput().getShape())).equals(parentShape)).map(o -> o.getHttp().getRequestUri()).findFirst().orElseThrow(() -> new RuntimeException("Could not find request URI for input shape"));
    }

    private String deriveUnmarshallerLocationName(String memberName, Member member) {
        String locationName = member.getLocationName();
        if (locationName != null && !locationName.trim().isEmpty()) {
            return locationName;
        }
        return memberName;
    }

    private String deriveMarshallerLocationName(String memberName, Member member, String protocol) {
        String queryName = member.getQueryName();
        if (queryName != null && !queryName.trim().isEmpty()) {
            return queryName;
        }
        String locationName = member.getLocationName();
        if (locationName != null && !locationName.trim().isEmpty()) {
            if (protocol.equals(Protocol.EC2.getValue())) {
                return StringUtils.upperCase((String)locationName.substring(0, 1)) + locationName.substring(1);
            }
            return locationName;
        }
        return memberName;
    }

    private void fillContainerTypeMemberMetadata(Map<String, Shape> c2jShapes, String memberC2jShapeName, MemberModel memberModel, String protocol) {
        Shape memberC2jShape = c2jShapes.get(memberC2jShapeName);
        if (Utils.isListShape(memberC2jShape)) {
            Member listMemberDefinition = memberC2jShape.getListMember();
            String listMemberC2jShapeName = listMemberDefinition.getShape();
            MemberModel listMemberModel = this.generateMemberModel("member", listMemberDefinition, protocol, memberC2jShape, c2jShapes);
            String listImpl = TypeUtils.getDataTypeMapping("listDefaultImpl");
            memberModel.setListModel(new ListModel(this.getTypeUtils().getJavaDataType(c2jShapes, listMemberC2jShapeName), memberC2jShape.getListMember().getLocationName(), listImpl, TypeUtils.getDataTypeMapping("listInterface"), listMemberModel));
        } else if (Utils.isMapShape(memberC2jShape)) {
            Member mapKeyMemberDefinition = memberC2jShape.getMapKeyType();
            String mapKeyShapeName = mapKeyMemberDefinition.getShape();
            Shape mapKeyShape = c2jShapes.get(mapKeyShapeName);
            Member mapValueMemberDefinition = memberC2jShape.getMapValueType();
            Validate.isTrue((boolean)Utils.isScalar(mapKeyShape), (String)"The key type of %s must be a scalar!", (Object[])new Object[]{mapKeyShapeName});
            MemberModel mapKeyModel = this.generateMemberModel("key", mapKeyMemberDefinition, protocol, memberC2jShape, c2jShapes);
            MemberModel mapValueModel = this.generateMemberModel("value", mapValueMemberDefinition, protocol, memberC2jShape, c2jShapes);
            String mapImpl = TypeUtils.getDataTypeMapping("mapDefaultImpl");
            String keyLocation = memberC2jShape.getMapKeyType().getLocationName() != null ? memberC2jShape.getMapKeyType().getLocationName() : "key";
            String valueLocation = memberC2jShape.getMapValueType().getLocationName() != null ? memberC2jShape.getMapValueType().getLocationName() : "value";
            memberModel.setMapModel(new MapModel(mapImpl, TypeUtils.getDataTypeMapping("mapInterface"), keyLocation, mapKeyModel, valueLocation, mapValueModel));
        } else if (memberC2jShape.getEnumValues() != null) {
            memberModel.withEnumType(this.getNamingStrategy().getJavaClassName(memberC2jShapeName));
        }
    }

    protected String getProtocol() {
        return this.getServiceModel().getMetadata().getProtocol();
    }
}

