/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.model.AbstractMemberSetters;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;

class NonCollectionSetters
extends AbstractMemberSetters {
    NonCollectionSetters(IntermediateModel intermediateModel, ShapeModel shapeModel, MemberModel memberModel, TypeProvider typeProvider) {
        super(intermediateModel, shapeModel, memberModel, typeProvider);
    }

    @Override
    public List<MethodSpec> fluentDeclarations(TypeName returnType) {
        ArrayList<MethodSpec> fluentDeclarations = new ArrayList<MethodSpec>();
        fluentDeclarations.add(this.fluentSetterDeclaration(this.memberAsParameter(), returnType).addJavadoc("$L", new Object[]{this.memberModel().getFluentSetterDocumentation()}).build());
        if (this.memberModel().getEnumType() != null) {
            fluentDeclarations.add(this.fluentSetterDeclaration(this.modeledParam(), returnType).addJavadoc("$L", new Object[]{this.memberModel().getFluentSetterDocumentation()}).build());
        }
        return fluentDeclarations;
    }

    @Override
    public List<MethodSpec> fluent(TypeName returnType) {
        ArrayList<MethodSpec> fluentSetters = new ArrayList<MethodSpec>();
        fluentSetters.add(this.fluentAssignmentSetter(returnType));
        if (this.memberModel().getEnumType() != null) {
            fluentSetters.add(this.fluentEnumToStringSetter(returnType));
        }
        return fluentSetters;
    }

    @Override
    public MethodSpec beanStyle() {
        MethodSpec.Builder builder = this.beanStyleSetterBuilder().addCode(this.copySetterBuilderBody());
        if (this.annotateJsonProperty()) {
            builder.addAnnotation(AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", new Object[]{this.memberModel().getHttp().getMarshallLocationName()}).build());
        }
        return builder.build();
    }

    private MethodSpec fluentAssignmentSetter(TypeName returnType) {
        return this.fluentSetterBuilder(returnType).addCode(this.copySetterBody().toBuilder().addStatement("return this", new Object[0]).build()).build();
    }

    private MethodSpec fluentEnumToStringSetter(TypeName returnType) {
        return this.fluentSetterBuilder(this.modeledParam(), returnType).addCode(this.enumToStringAssignmentBody().toBuilder().addStatement("return this", new Object[0]).build()).build();
    }

    private CodeBlock enumToStringAssignmentBody() {
        return CodeBlock.builder().addStatement("this.$N($N.toString())", new Object[]{this.fieldName(), this.fieldName()}).build();
    }

    private ParameterSpec modeledParam() {
        return ParameterSpec.builder((TypeName)this.poetExtensions.getModelClass(this.memberModel().getShape().getShapeName()), (String)this.fieldName(), (Modifier[])new Modifier[0]).build();
    }
}

