/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.model.ShapeInterfaceProvider;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AwsShapePublicInterfaceProvider
implements ShapeInterfaceProvider {
    private final IntermediateModel intermediateModel;
    private final ShapeModel shapeModel;
    private final PoetExtensions poetExtensions;

    public AwsShapePublicInterfaceProvider(IntermediateModel intermediateModel, ShapeModel shapeModel) {
        this.intermediateModel = intermediateModel;
        this.shapeModel = shapeModel;
        this.poetExtensions = new PoetExtensions(intermediateModel);
    }

    @Override
    public boolean shouldImplementInterface(Class<?> iface) {
        return this.interfacesToImplement().contains(ClassName.get(iface));
    }

    @Override
    public Set<TypeName> interfacesToImplement() {
        HashSet<TypeName> superInterfaces = new HashSet<TypeName>();
        switch (this.shapeModel.getShapeType()) {
            case Exception: 
            case Request: 
            case Model: 
            case Response: {
                superInterfaces.add(this.toCopyableBuilderInterface());
                break;
            }
        }
        if (this.implementStructuredPojoInterface()) {
            superInterfaces.add((TypeName)ClassName.get(StructuredPojo.class));
        }
        return superInterfaces;
    }

    @Override
    public TypeName baseClassToExtend() {
        switch (this.shapeModel.getShapeType()) {
            case Request: {
                return ClassName.get(AmazonWebServiceRequest.class);
            }
            case Response: {
                if (this.intermediateModel.getMetadata().getProtocol() == Protocol.API_GATEWAY) {
                    return ClassName.get((String)"software.amazon.awssdk.opensdk", (String)"BaseResult", (String[])new String[0]);
                }
                return ParameterizedTypeName.get(AmazonWebServiceResult.class, (Type[])new Type[]{ResponseMetadata.class});
            }
            case Exception: {
                return this.exceptionBaseClass();
            }
        }
        return ClassName.OBJECT;
    }

    private TypeName exceptionBaseClass() {
        String customExceptionBase = this.intermediateModel.getCustomizationConfig().getSdkModeledExceptionBaseClassName();
        if (customExceptionBase != null) {
            return this.poetExtensions.getModelClass(customExceptionBase);
        }
        return this.poetExtensions.getModelClass(this.intermediateModel.getSdkModeledExceptionBaseClassName());
    }

    private boolean implementStructuredPojoInterface() {
        return this.intermediateModel.getMetadata().isJsonProtocol() && this.shapeModel.getShapeType() == ShapeType.Model;
    }

    private TypeName toCopyableBuilderInterface() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(ToCopyableBuilder.class), (TypeName[])new TypeName[]{this.modelClassName().nestedClass("Builder"), this.modelClassName()});
    }

    private ClassName modelClassName() {
        return this.poetExtensions.getModelClass(this.shapeModel.getShapeName());
    }
}

