/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.intermediate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Map;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.intermediate.AuthorizerModel;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.model.intermediate.ServiceExamples;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.IoUtils;

public final class IntermediateModel {
    private static final String DEFAULT_CLIENT_CONFIG_FACTORY = "LegacyClientConfigurationFactory";
    private final Metadata metadata;
    private final Map<String, OperationModel> operations;
    private final Map<String, ShapeModel> shapes;
    private final CustomizationConfig customizationConfig;
    private final ServiceExamples examples;
    private final Map<String, AuthorizerModel> customAuthorizers;

    @JsonCreator
    public IntermediateModel(@JsonProperty(value="metadata") Metadata metadata, @JsonProperty(value="operations") Map<String, OperationModel> operations, @JsonProperty(value="shapes") Map<String, ShapeModel> shapes, @JsonProperty(value="customizationConfig") CustomizationConfig customizationConfig, @JsonProperty(value="serviceExamples") ServiceExamples examples) {
        this(metadata, operations, shapes, customizationConfig, examples, Collections.emptyMap());
    }

    public IntermediateModel(Metadata metadata, Map<String, OperationModel> operations, Map<String, ShapeModel> shapes, CustomizationConfig customizationConfig, ServiceExamples examples, Map<String, AuthorizerModel> customAuthorizers) {
        this.metadata = metadata;
        this.operations = operations;
        this.shapes = shapes;
        this.customizationConfig = customizationConfig;
        this.examples = examples;
        this.customAuthorizers = customAuthorizers;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Map<String, OperationModel> getOperations() {
        return this.operations;
    }

    public OperationModel getOperation(String operationName) {
        return this.getOperations().get(operationName);
    }

    public Map<String, ShapeModel> getShapes() {
        return this.shapes;
    }

    public ShapeModel getShapeByC2jName(String c2jName) {
        return Utils.findShapeModelByC2jName(this, c2jName);
    }

    public CustomizationConfig getCustomizationConfig() {
        return this.customizationConfig;
    }

    public ServiceExamples getExamples() {
        return this.examples;
    }

    public String getExceptionUnmarshallerImpl() {
        if (this.customizationConfig.getCustomExceptionUnmarshallerImpl() != null) {
            return this.customizationConfig.getCustomExceptionUnmarshallerImpl();
        }
        return this.metadata.getProtocolDefaultExceptionUmarshallerImpl();
    }

    public String getServiceBaseExceptionFqcn() {
        return this.metadata.getProtocol().getProvider().getBaseExceptionFqcn();
    }

    public String getSdkModeledExceptionBaseFqcn() {
        return String.format("%s.%s", this.metadata.getFullModelPackageName(), this.getSdkModeledExceptionBaseClassName());
    }

    public String getSdkModeledExceptionBaseClassName() {
        if (this.customizationConfig.getSdkModeledExceptionBaseClassName() != null) {
            return this.customizationConfig.getSdkModeledExceptionBaseClassName();
        }
        return this.metadata.getBaseExceptionName();
    }

    public String getFileHeader() throws IOException {
        if (this.customizationConfig.getCustomFileHeader() != null) {
            return String.format("/**%n%s%n*/", this.customizationConfig.getCustomFileHeader());
        }
        return this.loadDeafultFileHeader();
    }

    private String loadDeafultFileHeader() throws IOException {
        try (InputStream inputStream = this.getClass().getResourceAsStream("/software/amazon/awssdk/codegen/DefaultFileHeader.txt");){
            String string = IoUtils.toString((InputStream)inputStream).replaceFirst("%COPYRIGHT_DATE_RANGE%", this.getCopyrightDateRange());
            return string;
        }
    }

    private String getCopyrightDateRange() {
        int currentYear = ZonedDateTime.now().getYear();
        int copyrightStartYear = currentYear - 5;
        return String.format("%d-%d", copyrightStartYear, currentYear);
    }

    public String getSdkBaseResponseFqcn() {
        if (this.metadata.getProtocol() == Protocol.API_GATEWAY) {
            return "software.amazon.awssdk.opensdk.BaseResult";
        }
        return String.format("%s<%s>", AmazonWebServiceResult.class.getName(), this.getResponseMetadataClassName());
    }

    private String getResponseMetadataClassName() {
        return this.customizationConfig.getCustomResponseMetadataClassName() == null ? ResponseMetadata.class.getName() : this.customizationConfig.getCustomResponseMetadataClassName();
    }

    public Map<String, AuthorizerModel> getCustomAuthorizers() {
        return this.customAuthorizers;
    }
}

