/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters;

import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;

public class GeneratorPathProvider {
    private final IntermediateModel model;
    private final String sourceDirectory;
    private final String testDirectory;

    public GeneratorPathProvider(IntermediateModel model, String sourceDirectory, String testDirectory) {
        this.model = model;
        this.sourceDirectory = sourceDirectory;
        this.testDirectory = testDirectory;
    }

    public String getSourceDirectory() {
        return this.sourceDirectory;
    }

    public String getTestDirectory() {
        return this.testDirectory;
    }

    public String getModelDirectory() {
        return this.sourceDirectory + "/" + Utils.packageToDirectory(this.model.getMetadata().getFullModelPackageName());
    }

    public String getTransformDirectory() {
        return this.sourceDirectory + "/" + Utils.packageToDirectory(this.model.getMetadata().getFullTransformPackageName());
    }

    public String getRequestTransformDirectory() {
        return this.sourceDirectory + "/" + Utils.packageToDirectory(this.model.getMetadata().getFullRequestTransformPackageName());
    }

    public String getClientDirectory() {
        return this.sourceDirectory + "/" + Utils.packageToDirectory(this.model.getMetadata().getFullClientPackageName());
    }

    public String getPolicyEnumDirectory() {
        return this.sourceDirectory + "/" + "software/amazon/awssdk/auth/policy/actions";
    }

    public String getAuthorizerDirectory() {
        return this.sourceDirectory + "/" + Utils.packageToDirectory(this.model.getMetadata().getFullAuthPolicyPackageName());
    }

    public String getSmokeTestDirectory() {
        return this.testDirectory + '/' + Utils.packageToDirectory(this.model.getMetadata().getFullSmokeTestsPackageName());
    }
}

