/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.async.AsyncRequestProvider;
import software.amazon.awssdk.async.AsyncResponseHandler;
import software.amazon.awssdk.auth.DefaultCredentialsProvider;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;

public class AsyncClientInterface
implements ClassSpec {
    public static final TypeVariableName STREAMING_TYPE_VARIABLE = TypeVariableName.get((String)"ReturnT");
    protected final IntermediateModel model;
    protected final ClassName className;
    protected final String clientPackageName;
    private final String modelPackage;

    public AsyncClientInterface(IntermediateModel model) {
        this.modelPackage = model.getMetadata().getFullModelPackageName();
        this.clientPackageName = model.getMetadata().getFullClientPackageName();
        this.model = model;
        this.className = ClassName.get((String)model.getMetadata().getFullClientPackageName(), (String)model.getMetadata().getAsyncInterface(), (String[])new String[0]);
    }

    @Override
    public TypeSpec poetSpec() {
        return PoetUtils.createInterfaceBuilder(this.className).addSuperinterface(AutoCloseable.class).addJavadoc(this.getJavadoc(), new Object[0]).addMethod(this.create()).addMethod(this.builder()).addMethods(this.operations()).build();
    }

    @Override
    public ClassName className() {
        return this.className;
    }

    private String getJavadoc() {
        return "Service client for accessing " + this.model.getMetadata().getServiceAbbreviation() + " asynchronously. This can be created using the static {@link #builder()} method.\n\n" + this.model.getMetadata().getDocumentation();
    }

    private MethodSpec create() {
        return MethodSpec.methodBuilder((String)"create").returns((TypeName)this.className).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addJavadoc("Create a {@link $T} with the region loaded from the {@link $T} and credentials loaded from the {@link $T}.", new Object[]{this.className, DefaultAwsRegionProviderChain.class, DefaultCredentialsProvider.class}).addStatement("return builder().build()", new Object[0]).build();
    }

    private MethodSpec builder() {
        ClassName builderClass = ClassName.get((String)this.clientPackageName, (String)this.model.getMetadata().getAsyncBuilder(), (String[])new String[0]);
        ClassName builderInterface = ClassName.get((String)this.clientPackageName, (String)this.model.getMetadata().getAsyncBuilderInterface(), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"builder").returns((TypeName)builderInterface).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addJavadoc("Create a builder that can be used to configure and create a {@link $T}.", new Object[]{this.className}).addStatement("return new $T()", new Object[]{builderClass}).build();
    }

    protected final Iterable<MethodSpec> operations() {
        return this.model.getOperations().values().stream().map(this::operationSignatureAndJavaDoc).flatMap(Collection::stream).map(b -> this.operationBody(((BuilderModelBag)b).builder, ((BuilderModelBag)b).opModel, ((BuilderModelBag)b).simpleMethod)).map(MethodSpec.Builder::build).collect(Collectors.toList());
    }

    protected MethodSpec.Builder operationBody(MethodSpec.Builder builder, OperationModel operationModel, boolean simpleMethod) {
        return builder.addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class});
    }

    private List<BuilderModelBag> operationSignatureAndJavaDoc(OperationModel opModel) {
        ArrayList<BuilderModelBag> builderModelBags = new ArrayList<BuilderModelBag>();
        if (opModel.getInputShape().isSimpleMethod()) {
            builderModelBags.add(this.simpleMethod(opModel));
        }
        builderModelBags.add(this.operationMethod(opModel));
        return builderModelBags;
    }

    private BuilderModelBag operationMethod(OperationModel opModel) {
        ClassName responsePojoType = ClassName.get((String)this.modelPackage, (String)opModel.getReturnType().getReturnType(), (String[])new String[0]);
        ClassName requestType = ClassName.get((String)this.modelPackage, (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        MethodSpec.Builder builder = this.operationMethodSignatureAndJavadoc(opModel).addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]);
        if (opModel.hasStreamingInput()) {
            builder.addParameter((TypeName)ClassName.get(AsyncRequestProvider.class), "requestProvider", new Modifier[0]);
        }
        if (opModel.hasStreamingOutput()) {
            builder.addTypeVariable(STREAMING_TYPE_VARIABLE);
            ParameterizedTypeName asyncResponseHandlerType = ParameterizedTypeName.get((ClassName)ClassName.get(AsyncResponseHandler.class), (TypeName[])new TypeName[]{responsePojoType, STREAMING_TYPE_VARIABLE});
            builder.addParameter((TypeName)asyncResponseHandlerType, "asyncResponseHandler", new Modifier[0]);
        }
        return new BuilderModelBag(builder, opModel, false);
    }

    private BuilderModelBag simpleMethod(OperationModel opModel) {
        MethodSpec.Builder methodBuilder = this.operationMethodSignatureAndJavadoc(opModel);
        return new BuilderModelBag(methodBuilder, opModel, true);
    }

    private MethodSpec.Builder operationMethodSignatureAndJavadoc(OperationModel opModel) {
        ClassName responsePojoType = ClassName.get((String)this.modelPackage, (String)opModel.getReturnType().getReturnType(), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)opModel.getMethodName()).returns(this.getAsyncReturnType(opModel, responsePojoType)).addJavadoc(opModel.getAsyncDocumentation(this.model, opModel), new Object[0]);
    }

    private TypeName getAsyncReturnType(OperationModel opModel, ClassName responsePojoType) {
        if (opModel.hasStreamingOutput()) {
            return ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{STREAMING_TYPE_VARIABLE});
        }
        return ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{responsePojoType});
    }

    private static class BuilderModelBag {
        private final MethodSpec.Builder builder;
        private final OperationModel opModel;
        private final boolean simpleMethod;

        private BuilderModelBag(MethodSpec.Builder builder, OperationModel opModel, boolean simpleMethod) {
            this.builder = builder;
            this.opModel = opModel;
            this.simpleMethod = simpleMethod;
        }
    }
}

